/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.gsub.GlyphSubstitutionDataExtractor;
import org.apache.fontbox.ttf.model.GsubData;
import org.apache.fontbox.ttf.table.common.CoverageTable;
import org.apache.fontbox.ttf.table.common.CoverageTableFormat1;
import org.apache.fontbox.ttf.table.common.CoverageTableFormat2;
import org.apache.fontbox.ttf.table.common.FeatureListTable;
import org.apache.fontbox.ttf.table.common.FeatureRecord;
import org.apache.fontbox.ttf.table.common.FeatureTable;
import org.apache.fontbox.ttf.table.common.LangSysTable;
import org.apache.fontbox.ttf.table.common.LookupListTable;
import org.apache.fontbox.ttf.table.common.LookupSubTable;
import org.apache.fontbox.ttf.table.common.LookupTable;
import org.apache.fontbox.ttf.table.common.RangeRecord;
import org.apache.fontbox.ttf.table.common.ScriptTable;
import org.apache.fontbox.ttf.table.gsub.LigatureSetTable;
import org.apache.fontbox.ttf.table.gsub.LigatureTable;
import org.apache.fontbox.ttf.table.gsub.LookupTypeLigatureSubstitutionSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeMultipleSubstitutionFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat1;
import org.apache.fontbox.ttf.table.gsub.LookupTypeSingleSubstFormat2;
import org.apache.fontbox.ttf.table.gsub.SequenceTable;

public class GlyphSubstitutionTable
extends TTFTable {
    private static final Log LOG = LogFactory.getLog(GlyphSubstitutionTable.class);
    public static final String TAG = "GSUB";
    private Map<String, ScriptTable> scriptList;
    private FeatureListTable featureListTable;
    private LookupListTable lookupListTable;
    private final Map<Integer, Integer> lookupCache = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> reverseLookup = new HashMap<Integer, Integer>();
    private String lastUsedSupportedScript;
    private GsubData gsubData;
    private static final Pattern WORDPATTERN = Pattern.compile("\\w{4}");

    GlyphSubstitutionTable() {
    }

    @Override
    void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        long start = data.getCurrentPosition();
        int majorVersion = data.readUnsignedShort();
        int minorVersion = data.readUnsignedShort();
        int scriptListOffset = data.readUnsignedShort();
        int featureListOffset = data.readUnsignedShort();
        int lookupListOffset = data.readUnsignedShort();
        long featureVariationsOffset = -1L;
        if ((long)minorVersion == 1L) {
            featureVariationsOffset = data.readUnsignedInt();
        }
        this.scriptList = this.readScriptList(data, start + (long)scriptListOffset);
        this.featureListTable = this.readFeatureList(data, start + (long)featureListOffset);
        if (lookupListOffset > 0) {
            this.lookupListTable = this.readLookupList(data, start + (long)lookupListOffset);
        } else {
            LOG.warn("lookupListOffset is 0, LookupListTable is considered empty");
            this.lookupListTable = new LookupListTable(0, new LookupTable[0]);
        }
        GlyphSubstitutionDataExtractor glyphSubstitutionDataExtractor = new GlyphSubstitutionDataExtractor();
        this.gsubData = glyphSubstitutionDataExtractor.getGsubData(this.scriptList, this.featureListTable, this.lookupListTable);
        this.initialized = true;
    }

    private Map<String, ScriptTable> readScriptList(TTFDataStream data, long offset) throws IOException {
        int i2;
        data.seek(offset);
        int scriptCount = data.readUnsignedShort();
        int[] scriptOffsets = new int[scriptCount];
        String[] scriptTags = new String[scriptCount];
        LinkedHashMap<String, ScriptTable> resultScriptList = new LinkedHashMap<String, ScriptTable>(scriptCount);
        for (i2 = 0; i2 < scriptCount; ++i2) {
            scriptTags[i2] = data.readString(4);
            scriptOffsets[i2] = data.readUnsignedShort();
        }
        for (i2 = 0; i2 < scriptCount; ++i2) {
            ScriptTable scriptTable = this.readScriptTable(data, offset + (long)scriptOffsets[i2]);
            resultScriptList.put(scriptTags[i2], scriptTable);
        }
        return Collections.unmodifiableMap(resultScriptList);
    }

    private ScriptTable readScriptTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int defaultLangSys = data.readUnsignedShort();
        int langSysCount = data.readUnsignedShort();
        String[] langSysTags = new String[langSysCount];
        int[] langSysOffsets = new int[langSysCount];
        for (int i2 = 0; i2 < langSysCount; ++i2) {
            langSysTags[i2] = data.readString(4);
            if (i2 > 0 && langSysTags[i2].compareTo(langSysTags[i2 - 1]) <= 0) {
                LOG.error("LangSysRecords not alphabetically sorted by LangSys tag: " + langSysTags[i2] + " <= " + langSysTags[i2 - 1]);
                return new ScriptTable(null, new LinkedHashMap<String, LangSysTable>());
            }
            langSysOffsets[i2] = data.readUnsignedShort();
        }
        LangSysTable defaultLangSysTable = null;
        if (defaultLangSys != 0) {
            defaultLangSysTable = this.readLangSysTable(data, offset + (long)defaultLangSys);
        }
        LinkedHashMap<String, LangSysTable> langSysTables = new LinkedHashMap<String, LangSysTable>(langSysCount);
        for (int i3 = 0; i3 < langSysCount; ++i3) {
            LangSysTable langSysTable = this.readLangSysTable(data, offset + (long)langSysOffsets[i3]);
            langSysTables.put(langSysTags[i3], langSysTable);
        }
        return new ScriptTable(defaultLangSysTable, Collections.unmodifiableMap(langSysTables));
    }

    private LangSysTable readLangSysTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int lookupOrder = data.readUnsignedShort();
        int requiredFeatureIndex = data.readUnsignedShort();
        int featureIndexCount = data.readUnsignedShort();
        int[] featureIndices = new int[featureIndexCount];
        for (int i2 = 0; i2 < featureIndexCount; ++i2) {
            featureIndices[i2] = data.readUnsignedShort();
        }
        return new LangSysTable(lookupOrder, requiredFeatureIndex, featureIndexCount, featureIndices);
    }

    private FeatureListTable readFeatureList(TTFDataStream data, long offset) throws IOException {
        int i2;
        data.seek(offset);
        int featureCount = data.readUnsignedShort();
        FeatureRecord[] featureRecords = new FeatureRecord[featureCount];
        int[] featureOffsets = new int[featureCount];
        String[] featureTags = new String[featureCount];
        for (i2 = 0; i2 < featureCount; ++i2) {
            featureTags[i2] = data.readString(4);
            if (i2 > 0 && featureTags[i2].compareTo(featureTags[i2 - 1]) < 0) {
                if (WORDPATTERN.matcher(featureTags[i2]).matches() && WORDPATTERN.matcher(featureTags[i2 - 1]).matches()) {
                    LOG.debug("FeatureRecord array not alphabetically sorted by FeatureTag: " + featureTags[i2] + " < " + featureTags[i2 - 1]);
                } else {
                    LOG.warn("FeatureRecord array not alphabetically sorted by FeatureTag: " + featureTags[i2] + " < " + featureTags[i2 - 1]);
                    return new FeatureListTable(0, new FeatureRecord[0]);
                }
            }
            featureOffsets[i2] = data.readUnsignedShort();
        }
        for (i2 = 0; i2 < featureCount; ++i2) {
            FeatureTable featureTable = this.readFeatureTable(data, offset + (long)featureOffsets[i2]);
            featureRecords[i2] = new FeatureRecord(featureTags[i2], featureTable);
        }
        return new FeatureListTable(featureCount, featureRecords);
    }

    private FeatureTable readFeatureTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int featureParams = data.readUnsignedShort();
        int lookupIndexCount = data.readUnsignedShort();
        int[] lookupListIndices = new int[lookupIndexCount];
        for (int i2 = 0; i2 < lookupIndexCount; ++i2) {
            lookupListIndices[i2] = data.readUnsignedShort();
        }
        return new FeatureTable(featureParams, lookupIndexCount, lookupListIndices);
    }

    private LookupListTable readLookupList(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int lookupCount = data.readUnsignedShort();
        int[] lookups = new int[lookupCount];
        for (int i2 = 0; i2 < lookupCount; ++i2) {
            lookups[i2] = data.readUnsignedShort();
            if (lookups[i2] == 0) {
                LOG.error("lookups[" + i2 + "] is 0 at offset " + (data.getCurrentPosition() - 2L));
                continue;
            }
            if (offset + (long)lookups[i2] <= data.getOriginalDataSize()) continue;
            LOG.error(offset + (long)lookups[i2] + " > " + data.getOriginalDataSize());
        }
        LookupTable[] lookupTables = new LookupTable[lookupCount];
        for (int i3 = 0; i3 < lookupCount; ++i3) {
            lookupTables[i3] = this.readLookupTable(data, offset + (long)lookups[i3]);
        }
        return new LookupListTable(lookupCount, lookupTables);
    }

    private LookupSubTable readLookupSubtable(TTFDataStream data, long offset, int lookupType) throws IOException {
        switch (lookupType) {
            case 1: {
                return this.readSingleLookupSubTable(data, offset);
            }
            case 2: {
                return this.readMultipleSubstitutionSubtable(data, offset);
            }
            case 4: {
                return this.readLigatureSubstitutionSubtable(data, offset);
            }
        }
        LOG.debug("Type " + lookupType + " GSUB lookup table is not supported and will be ignored");
        return null;
    }

    private LookupTable readLookupTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int lookupType = data.readUnsignedShort();
        int lookupFlag = data.readUnsignedShort();
        int subTableCount = data.readUnsignedShort();
        int[] subTableOffsets = new int[subTableCount];
        for (int i2 = 0; i2 < subTableCount; ++i2) {
            subTableOffsets[i2] = data.readUnsignedShort();
            if (subTableOffsets[i2] == 0) {
                LOG.error("subTableOffsets[" + i2 + "] is 0 at offset " + (data.getCurrentPosition() - 2L));
                continue;
            }
            if (offset + (long)subTableOffsets[i2] <= data.getOriginalDataSize()) continue;
            LOG.error(offset + (long)subTableOffsets[i2] + " > " + data.getOriginalDataSize());
        }
        int markFilteringSet = (lookupFlag & 0x10) != 0 ? data.readUnsignedShort() : 0;
        LookupSubTable[] subTables = new LookupSubTable[subTableCount];
        switch (lookupType) {
            case 1: 
            case 2: 
            case 4: {
                for (int i3 = 0; i3 < subTableCount; ++i3) {
                    subTables[i3] = this.readLookupSubtable(data, offset + (long)subTableOffsets[i3], lookupType);
                }
                break;
            }
            case 7: {
                for (int i4 = 0; i4 < subTableCount; ++i4) {
                    data.seek(offset + (long)subTableOffsets[i4]);
                    int substFormat = data.readUnsignedShort();
                    if (substFormat != 1) {
                        LOG.error("The expected SubstFormat for ExtensionSubstFormat1 subtable is " + substFormat + " but should be 1 at offset " + (offset + (long)subTableOffsets[i4]));
                        continue;
                    }
                    int extensionLookupType = data.readUnsignedShort();
                    if (lookupType != 7 && lookupType != extensionLookupType) {
                        LOG.error("extensionLookupType changed from " + lookupType + " to " + extensionLookupType + " at offset " + (offset + (long)subTableOffsets[i4] + 2L));
                        continue;
                    }
                    lookupType = extensionLookupType;
                    long extensionOffset = data.readUnsignedInt();
                    long extensionLookupTableAddress = offset + (long)subTableOffsets[i4] + extensionOffset;
                    subTables[i4] = this.readLookupSubtable(data, extensionLookupTableAddress, extensionLookupType);
                }
                break;
            }
            default: {
                LOG.debug("Type " + lookupType + " GSUB lookup table is not supported and will be ignored");
            }
        }
        return new LookupTable(lookupType, lookupFlag, markFilteringSet, subTables);
    }

    private LookupSubTable readSingleLookupSubTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int substFormat = data.readUnsignedShort();
        switch (substFormat) {
            case 1: {
                int coverageOffset = data.readUnsignedShort();
                short deltaGlyphID = data.readSignedShort();
                CoverageTable coverageTable = this.readCoverageTable(data, offset + (long)coverageOffset);
                return new LookupTypeSingleSubstFormat1(substFormat, coverageTable, deltaGlyphID);
            }
            case 2: {
                int coverageOffset = data.readUnsignedShort();
                int glyphCount = data.readUnsignedShort();
                int[] substituteGlyphIDs = new int[glyphCount];
                for (int i2 = 0; i2 < glyphCount; ++i2) {
                    substituteGlyphIDs[i2] = data.readUnsignedShort();
                }
                CoverageTable coverageTable = this.readCoverageTable(data, offset + (long)coverageOffset);
                return new LookupTypeSingleSubstFormat2(substFormat, coverageTable, substituteGlyphIDs);
            }
        }
        LOG.warn("Unknown substFormat: " + substFormat);
        return null;
    }

    private LookupSubTable readMultipleSubstitutionSubtable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int substFormat = data.readUnsignedShort();
        if (substFormat != 1) {
            throw new IOException("The expected SubstFormat for LigatureSubstitutionTable is 1");
        }
        int coverage = data.readUnsignedShort();
        int sequenceCount = data.readUnsignedShort();
        int[] sequenceOffsets = new int[sequenceCount];
        for (int i2 = 0; i2 < sequenceCount; ++i2) {
            sequenceOffsets[i2] = data.readUnsignedShort();
        }
        CoverageTable coverageTable = this.readCoverageTable(data, offset + (long)coverage);
        if (sequenceCount != coverageTable.getSize()) {
            throw new IOException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of SequenceTables");
        }
        SequenceTable[] sequenceTables = new SequenceTable[sequenceCount];
        for (int i3 = 0; i3 < sequenceCount; ++i3) {
            data.seek(offset + (long)sequenceOffsets[i3]);
            int glyphCount = data.readUnsignedShort();
            int[] substituteGlyphIDs = data.readUnsignedShortArray(glyphCount);
            sequenceTables[i3] = new SequenceTable(glyphCount, substituteGlyphIDs);
        }
        return new LookupTypeMultipleSubstitutionFormat1(substFormat, coverageTable, sequenceTables);
    }

    private LookupSubTable readLigatureSubstitutionSubtable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int substFormat = data.readUnsignedShort();
        if (substFormat != 1) {
            throw new IOException("The expected SubstFormat for LigatureSubstitutionTable is 1");
        }
        int coverage = data.readUnsignedShort();
        int ligSetCount = data.readUnsignedShort();
        int[] ligatureOffsets = new int[ligSetCount];
        for (int i2 = 0; i2 < ligSetCount; ++i2) {
            ligatureOffsets[i2] = data.readUnsignedShort();
        }
        CoverageTable coverageTable = this.readCoverageTable(data, offset + (long)coverage);
        if (ligSetCount != coverageTable.getSize()) {
            throw new IOException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of LigatureSetTables");
        }
        LigatureSetTable[] ligatureSetTables = new LigatureSetTable[ligSetCount];
        for (int i3 = 0; i3 < ligSetCount; ++i3) {
            int coverageGlyphId = coverageTable.getGlyphId(i3);
            ligatureSetTables[i3] = this.readLigatureSetTable(data, offset + (long)ligatureOffsets[i3], coverageGlyphId);
        }
        return new LookupTypeLigatureSubstitutionSubstFormat1(substFormat, coverageTable, ligatureSetTables);
    }

    private LigatureSetTable readLigatureSetTable(TTFDataStream data, long ligatureSetTableLocation, int coverageGlyphId) throws IOException {
        int i2;
        data.seek(ligatureSetTableLocation);
        int ligatureCount = data.readUnsignedShort();
        int[] ligatureOffsets = new int[ligatureCount];
        LigatureTable[] ligatureTables = new LigatureTable[ligatureCount];
        for (i2 = 0; i2 < ligatureOffsets.length; ++i2) {
            ligatureOffsets[i2] = data.readUnsignedShort();
        }
        for (i2 = 0; i2 < ligatureOffsets.length; ++i2) {
            int ligatureOffset = ligatureOffsets[i2];
            ligatureTables[i2] = this.readLigatureTable(data, ligatureSetTableLocation + (long)ligatureOffset, coverageGlyphId);
        }
        return new LigatureSetTable(ligatureCount, ligatureTables);
    }

    private LigatureTable readLigatureTable(TTFDataStream data, long ligatureTableLocation, int coverageGlyphId) throws IOException {
        data.seek(ligatureTableLocation);
        int ligatureGlyph = data.readUnsignedShort();
        int componentCount = data.readUnsignedShort();
        int[] componentGlyphIDs = new int[componentCount];
        if (componentCount > 0) {
            componentGlyphIDs[0] = coverageGlyphId;
        }
        for (int i2 = 1; i2 <= componentCount - 1; ++i2) {
            componentGlyphIDs[i2] = data.readUnsignedShort();
        }
        return new LigatureTable(ligatureGlyph, componentCount, componentGlyphIDs);
    }

    private CoverageTable readCoverageTable(TTFDataStream data, long offset) throws IOException {
        data.seek(offset);
        int coverageFormat = data.readUnsignedShort();
        switch (coverageFormat) {
            case 1: {
                int glyphCount = data.readUnsignedShort();
                int[] glyphArray = new int[glyphCount];
                for (int i2 = 0; i2 < glyphCount; ++i2) {
                    glyphArray[i2] = data.readUnsignedShort();
                }
                return new CoverageTableFormat1(coverageFormat, glyphArray);
            }
            case 2: {
                int rangeCount = data.readUnsignedShort();
                RangeRecord[] rangeRecords = new RangeRecord[rangeCount];
                for (int i3 = 0; i3 < rangeCount; ++i3) {
                    rangeRecords[i3] = this.readRangeRecord(data);
                }
                return new CoverageTableFormat2(coverageFormat, rangeRecords);
            }
        }
        throw new IOException("Unknown coverage format: " + coverageFormat);
    }

    private String selectScriptTag(String[] tags) {
        String tag;
        if (tags.length == 1 && ("Inherited".equals(tag = tags[0]) || "DFLT".equals(tag) && !this.scriptList.containsKey(tag))) {
            if (this.lastUsedSupportedScript == null) {
                this.lastUsedSupportedScript = this.scriptList.keySet().iterator().next();
            }
            return this.lastUsedSupportedScript;
        }
        for (String tag2 : tags) {
            if (!this.scriptList.containsKey(tag2)) continue;
            this.lastUsedSupportedScript = tag2;
            return this.lastUsedSupportedScript;
        }
        return tags[0];
    }

    private Collection<LangSysTable> getLangSysTables(String scriptTag) {
        Collection<LangSysTable> result = Collections.emptyList();
        ScriptTable scriptTable = this.scriptList.get(scriptTag);
        if (scriptTable != null) {
            if (scriptTable.getDefaultLangSysTable() == null) {
                result = scriptTable.getLangSysTables().values();
            } else {
                result = new ArrayList<LangSysTable>(scriptTable.getLangSysTables().values());
                result.add(scriptTable.getDefaultLangSysTable());
            }
        }
        return result;
    }

    private List<FeatureRecord> getFeatureRecords(Collection<LangSysTable> langSysTables, List<String> enabledFeatures) {
        if (langSysTables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FeatureRecord> result = new ArrayList<FeatureRecord>();
        langSysTables.forEach(langSysTable -> {
            int required = langSysTable.getRequiredFeatureIndex();
            FeatureRecord[] featureRecords = this.featureListTable.getFeatureRecords();
            if (required != 65535 && required < featureRecords.length) {
                result.add(featureRecords[required]);
            }
            for (int featureIndex : langSysTable.getFeatureIndices()) {
                if (featureIndex >= featureRecords.length || enabledFeatures != null && !enabledFeatures.contains(featureRecords[featureIndex].getFeatureTag())) continue;
                result.add(featureRecords[featureIndex]);
            }
        });
        if (this.containsFeature(result, "vrt2")) {
            this.removeFeature(result, "vert");
        }
        if (enabledFeatures != null && result.size() > 1) {
            result.sort((o1, o2) -> Integer.compare(enabledFeatures.indexOf(o1.getFeatureTag()), enabledFeatures.indexOf(o2.getFeatureTag())));
        }
        return result;
    }

    private boolean containsFeature(List<FeatureRecord> featureRecords, String featureTag) {
        return featureRecords.stream().anyMatch(featureRecord -> featureRecord.getFeatureTag().equals(featureTag));
    }

    private void removeFeature(List<FeatureRecord> featureRecords, String featureTag) {
        Iterator<FeatureRecord> iter = featureRecords.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getFeatureTag().equals(featureTag)) continue;
            iter.remove();
        }
    }

    private int applyFeature(FeatureRecord featureRecord, int gid) {
        int lookupResult = gid;
        for (int lookupListIndex : featureRecord.getFeatureTable().getLookupListIndices()) {
            LookupTable lookupTable = this.lookupListTable.getLookups()[lookupListIndex];
            if (lookupTable.getLookupType() != 1) {
                LOG.warn("Skipping GSUB feature '" + featureRecord.getFeatureTag() + "' because it requires unsupported lookup table type " + lookupTable.getLookupType());
                continue;
            }
            lookupResult = this.doLookup(lookupTable, lookupResult);
        }
        return lookupResult;
    }

    private int doLookup(LookupTable lookupTable, int gid) {
        for (LookupSubTable lookupSubtable : lookupTable.getSubTables()) {
            int coverageIndex = lookupSubtable.getCoverageTable().getCoverageIndex(gid);
            if (coverageIndex < 0) continue;
            return lookupSubtable.doSubstitution(gid, coverageIndex);
        }
        return gid;
    }

    public int getSubstitution(int gid, String[] scriptTags, List<String> enabledFeatures) {
        if (gid == -1) {
            return -1;
        }
        Integer cached = this.lookupCache.get(gid);
        if (cached != null) {
            return cached;
        }
        String scriptTag = this.selectScriptTag(scriptTags);
        Collection<LangSysTable> langSysTables = this.getLangSysTables(scriptTag);
        List<FeatureRecord> featureRecords = this.getFeatureRecords(langSysTables, enabledFeatures);
        int sgid = gid;
        for (FeatureRecord featureRecord : featureRecords) {
            sgid = this.applyFeature(featureRecord, sgid);
        }
        this.lookupCache.put(gid, sgid);
        this.reverseLookup.put(sgid, gid);
        return sgid;
    }

    public int getUnsubstitution(int sgid) {
        Integer gid = this.reverseLookup.get(sgid);
        if (gid == null) {
            LOG.warn("Trying to un-substitute a never-before-seen gid: " + sgid);
            return sgid;
        }
        return gid;
    }

    public GsubData getGsubData() {
        return this.gsubData;
    }

    public GsubData getGsubData(String scriptTag) {
        ScriptTable scriptTable = this.scriptList.get(scriptTag);
        if (scriptTable == null) {
            return null;
        }
        return new GlyphSubstitutionDataExtractor().getGsubData(scriptTag, scriptTable, this.featureListTable, this.lookupListTable);
    }

    public Set<String> getSupportedScriptTags() {
        return Collections.unmodifiableSet(this.scriptList.keySet());
    }

    private RangeRecord readRangeRecord(TTFDataStream data) throws IOException {
        int startGlyphID = data.readUnsignedShort();
        int endGlyphID = data.readUnsignedShort();
        int startCoverageIndex = data.readUnsignedShort();
        return new RangeRecord(startGlyphID, endGlyphID, startCoverageIndex);
    }
}

