/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.blend;

import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;

public class BlendMode {
    private static final BlendChannelFunction fNormal = (src, dest) -> src;
    private static final BlendChannelFunction fMultiply = (src, dest) -> src * dest;
    private static final BlendChannelFunction fScreen = (src, dest) -> src + dest - src * dest;
    private static final BlendChannelFunction fOverlay = (src, dest) -> (double)dest <= 0.5 ? 2.0f * dest * src : 2.0f * (src + dest - src * dest) - 1.0f;
    private static final BlendChannelFunction fDarken = Math::min;
    private static final BlendChannelFunction fLighten = Math::max;
    private static final BlendChannelFunction fColorDodge = (src, dest) -> {
        if (Float.compare(dest, 0.0f) == 0) {
            return 0.0f;
        }
        if (dest >= 1.0f - src) {
            return 1.0f;
        }
        return dest / (1.0f - src);
    };
    private static final BlendChannelFunction fColorBurn = (src, dest) -> {
        if (Float.compare(dest, 1.0f) == 0) {
            return 1.0f;
        }
        if (1.0f - dest >= src) {
            return 0.0f;
        }
        return 1.0f - (1.0f - dest) / src;
    };
    private static final BlendChannelFunction fHardLight = (src, dest) -> (double)src <= 0.5 ? 2.0f * dest * src : 2.0f * (src + dest - src * dest) - 1.0f;
    private static final BlendChannelFunction fSoftLight = (src, dest) -> {
        if ((double)src <= 0.5) {
            return dest - (1.0f - 2.0f * src) * dest * (1.0f - dest);
        }
        float d2 = (double)dest <= 0.25 ? ((16.0f * dest - 12.0f) * dest + 4.0f) * dest : (float)Math.sqrt(dest);
        return dest + (2.0f * src - 1.0f) * (d2 - dest);
    };
    private static final BlendChannelFunction fDifference = (src, dest) -> Math.abs(dest - src);
    private static final BlendChannelFunction fExclusion = (src, dest) -> dest + src - 2.0f * dest * src;
    private static final BlendFunction fHue = (src, dest, result) -> {
        float[] temp = new float[3];
        BlendMode.getSaturationRGB(dest, src, temp);
        BlendMode.getLuminosityRGB(dest, temp, result);
    };
    private static final BlendFunction fSaturation = BlendMode::getSaturationRGB;
    private static final BlendFunction fColor = (src, dest, result) -> BlendMode.getLuminosityRGB(dest, src, result);
    private static final BlendFunction fLuminosity = BlendMode::getLuminosityRGB;
    public static final BlendMode NORMAL;
    public static final BlendMode COMPATIBLE;
    public static final BlendMode MULTIPLY;
    public static final BlendMode SCREEN;
    public static final BlendMode OVERLAY;
    public static final BlendMode DARKEN;
    public static final BlendMode LIGHTEN;
    public static final BlendMode COLOR_DODGE;
    public static final BlendMode COLOR_BURN;
    public static final BlendMode HARD_LIGHT;
    public static final BlendMode SOFT_LIGHT;
    public static final BlendMode DIFFERENCE;
    public static final BlendMode EXCLUSION;
    public static final BlendMode HUE;
    public static final BlendMode SATURATION;
    public static final BlendMode COLOR;
    public static final BlendMode LUMINOSITY;
    private static final Map<COSName, BlendMode> BLEND_MODES;
    private final COSName name;
    private final BlendChannelFunction blendChannel;
    private final BlendFunction blend;
    private final boolean isSeparable;

    private static Map<COSName, BlendMode> createBlendModeMap() {
        HashMap<COSName, BlendMode> map = new HashMap<COSName, BlendMode>(13);
        map.put(COSName.NORMAL, NORMAL);
        map.put(COSName.COMPATIBLE, NORMAL);
        map.put(COSName.MULTIPLY, MULTIPLY);
        map.put(COSName.SCREEN, SCREEN);
        map.put(COSName.OVERLAY, OVERLAY);
        map.put(COSName.DARKEN, DARKEN);
        map.put(COSName.LIGHTEN, LIGHTEN);
        map.put(COSName.COLOR_DODGE, COLOR_DODGE);
        map.put(COSName.COLOR_BURN, COLOR_BURN);
        map.put(COSName.HARD_LIGHT, HARD_LIGHT);
        map.put(COSName.SOFT_LIGHT, SOFT_LIGHT);
        map.put(COSName.DIFFERENCE, DIFFERENCE);
        map.put(COSName.EXCLUSION, EXCLUSION);
        map.put(COSName.HUE, HUE);
        map.put(COSName.SATURATION, SATURATION);
        map.put(COSName.LUMINOSITY, LUMINOSITY);
        map.put(COSName.COLOR, COLOR);
        return map;
    }

    private BlendMode(COSName name, BlendChannelFunction blendChannel, BlendFunction blend) {
        this.name = name;
        this.blendChannel = blendChannel;
        this.blend = blend;
        this.isSeparable = blendChannel != null;
    }

    public COSName getCOSName() {
        return this.name;
    }

    public boolean isSeparableBlendMode() {
        return this.isSeparable;
    }

    public BlendChannelFunction getBlendChannelFunction() {
        return this.blendChannel;
    }

    public BlendFunction getBlendFunction() {
        return this.blend;
    }

    public static BlendMode getInstance(COSBase cosBlendMode) {
        BlendMode result = null;
        if (cosBlendMode instanceof COSName) {
            result = BLEND_MODES.get(cosBlendMode);
        } else if (cosBlendMode instanceof COSArray) {
            COSBase cosBase;
            COSArray cosBlendModeArray = (COSArray)cosBlendMode;
            for (int i2 = 0; !(i2 >= cosBlendModeArray.size() || (cosBase = cosBlendModeArray.getObject(i2)) instanceof COSName && (result = BLEND_MODES.get(cosBase)) != null); ++i2) {
            }
        }
        return result != null ? result : NORMAL;
    }

    private static int get255Value(float val) {
        return (int)Math.floor((double)val >= 1.0 ? 255.0 : (double)val * 255.0);
    }

    private static void getSaturationRGB(float[] srcValues, float[] dstValues, float[] result) {
        int b2;
        int g2;
        int maxb;
        int bd;
        int gd;
        int rd = BlendMode.get255Value(dstValues[0]);
        int minb = Math.min(rd, Math.min(gd = BlendMode.get255Value(dstValues[1]), bd = BlendMode.get255Value(dstValues[2])));
        if (minb == (maxb = Math.max(rd, Math.max(gd, bd)))) {
            result[0] = (float)gd / 255.0f;
            result[1] = (float)gd / 255.0f;
            result[2] = (float)gd / 255.0f;
            return;
        }
        int rs = BlendMode.get255Value(srcValues[0]);
        int gs = BlendMode.get255Value(srcValues[1]);
        int bs = BlendMode.get255Value(srcValues[2]);
        int mins = Math.min(rs, Math.min(gs, bs));
        int y = rd * 77 + gd * 151 + bd * 28 + 128 >> 8;
        int maxs = Math.max(rs, Math.max(gs, bs));
        int scale = (maxs - mins << 16) / (maxb - minb);
        int r = y + ((rd - y) * scale + 32768 >> 16);
        if (((r | (g2 = y + ((gd - y) * scale + 32768 >> 16)) | (b2 = y + ((bd - y) * scale + 32768 >> 16))) & 0x100) == 256) {
            int min = Math.min(r, Math.min(g2, b2));
            int max = Math.max(r, Math.max(g2, b2));
            int scalemin = min < 0 ? (y << 16) / (y - min) : 65536;
            int scalemax = max > 255 ? (255 - y << 16) / (max - y) : 65536;
            scale = Math.min(scalemin, scalemax);
            r = y + ((r - y) * scale + 32768 >> 16);
            g2 = y + ((g2 - y) * scale + 32768 >> 16);
            b2 = y + ((b2 - y) * scale + 32768 >> 16);
        }
        result[0] = (float)r / 255.0f;
        result[1] = (float)g2 / 255.0f;
        result[2] = (float)b2 / 255.0f;
    }

    private static void getLuminosityRGB(float[] srcValues, float[] dstValues, float[] result) {
        int b2;
        int g2;
        int bs;
        int gs;
        int rd = BlendMode.get255Value(dstValues[0]);
        int gd = BlendMode.get255Value(dstValues[1]);
        int bd = BlendMode.get255Value(dstValues[2]);
        int rs = BlendMode.get255Value(srcValues[0]);
        int delta = (rs - rd) * 77 + ((gs = BlendMode.get255Value(srcValues[1])) - gd) * 151 + ((bs = BlendMode.get255Value(srcValues[2])) - bd) * 28 + 128 >> 8;
        int r = rd + delta;
        if (((r | (g2 = gd + delta) | (b2 = bd + delta)) & 0x100) == 256) {
            int min;
            int max;
            int y = rs * 77 + gs * 151 + bs * 28 + 128 >> 8;
            int scale = delta > 0 ? ((max = Math.max(r, Math.max(g2, b2))) == y ? 0 : (255 - y << 16) / (max - y)) : (y == (min = Math.min(r, Math.min(g2, b2))) ? 0 : (y << 16) / (y - min));
            r = y + ((r - y) * scale + 32768 >> 16);
            g2 = y + ((g2 - y) * scale + 32768 >> 16);
            b2 = y + ((b2 - y) * scale + 32768 >> 16);
        }
        result[0] = (float)r / 255.0f;
        result[1] = (float)g2 / 255.0f;
        result[2] = (float)b2 / 255.0f;
    }

    static {
        COMPATIBLE = NORMAL = new BlendMode(COSName.NORMAL, fNormal, null);
        MULTIPLY = new BlendMode(COSName.MULTIPLY, fMultiply, null);
        SCREEN = new BlendMode(COSName.SCREEN, fScreen, null);
        OVERLAY = new BlendMode(COSName.OVERLAY, fOverlay, null);
        DARKEN = new BlendMode(COSName.DARKEN, fDarken, null);
        LIGHTEN = new BlendMode(COSName.LIGHTEN, fLighten, null);
        COLOR_DODGE = new BlendMode(COSName.COLOR_DODGE, fColorDodge, null);
        COLOR_BURN = new BlendMode(COSName.COLOR_BURN, fColorBurn, null);
        HARD_LIGHT = new BlendMode(COSName.HARD_LIGHT, fHardLight, null);
        SOFT_LIGHT = new BlendMode(COSName.SOFT_LIGHT, fSoftLight, null);
        DIFFERENCE = new BlendMode(COSName.DIFFERENCE, fDifference, null);
        EXCLUSION = new BlendMode(COSName.EXCLUSION, fExclusion, null);
        HUE = new BlendMode(COSName.HUE, null, fHue);
        SATURATION = new BlendMode(COSName.SATURATION, null, fSaturation);
        COLOR = new BlendMode(COSName.COLOR, null, fColor);
        LUMINOSITY = new BlendMode(COSName.LUMINOSITY, null, fLuminosity);
        BLEND_MODES = BlendMode.createBlendModeMap();
    }

    @FunctionalInterface
    public static interface BlendFunction {
        public void blend(float[] var1, float[] var2, float[] var3);
    }

    @FunctionalInterface
    public static interface BlendChannelFunction {
        public float blendChannel(float var1, float var2);
    }
}

