/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QPEncoderStream
extends FilterOutputStream {
    private int count = 0;
    private int bytesPerLine;
    private boolean gotSpace = false;
    private boolean gotCR = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public QPEncoderStream(OutputStream out, int bytesPerLine) {
        super(out);
        this.bytesPerLine = bytesPerLine - 1;
    }

    public QPEncoderStream(OutputStream out) {
        this(out, 76);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        for (int i2 = 0; i2 < len; ++i2) {
            this.write(b2[off + i2]);
        }
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(int c2) throws IOException {
        c2 &= 0xFF;
        if (this.gotSpace) {
            if (c2 == 13 || c2 == 10) {
                this.output(32, true);
            } else {
                this.output(32, false);
            }
            this.gotSpace = false;
        }
        if (c2 == 13) {
            this.gotCR = true;
            this.outputCRLF();
        } else {
            if (c2 == 10) {
                if (!this.gotCR) {
                    this.outputCRLF();
                }
            } else if (c2 == 32) {
                this.gotSpace = true;
            } else if (c2 < 32 || c2 >= 127 || c2 == 61) {
                this.output(c2, true);
            } else {
                this.output(c2, false);
            }
            this.gotCR = false;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.gotSpace) {
            this.output(32, true);
            this.gotSpace = false;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void outputCRLF() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.count = 0;
    }

    protected void output(int c2, boolean encode) throws IOException {
        if (encode) {
            if ((this.count += 3) > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 3;
            }
            this.out.write(61);
            this.out.write(hex[c2 >> 4]);
            this.out.write(hex[c2 & 0xF]);
        } else {
            if (++this.count > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 1;
            }
            this.out.write(c2);
        }
    }
}

