/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.model.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jaxb.core.v2.model.annotation.Locatable;
import org.glassfish.jaxb.runtime.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import org.glassfish.jaxb.runtime.v2.model.annotation.LocatableAnnotation;
import org.glassfish.jaxb.runtime.v2.model.annotation.Messages;
import org.glassfish.jaxb.runtime.v2.model.annotation.RuntimeAnnotationReader;

public final class RuntimeInlineAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private final Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache = new HashMap<Class<? extends Annotation>, Map<Package, Annotation>>();

    @Override
    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation, Field field, Locatable srcPos) {
        return LocatableAnnotation.create(field.getAnnotation(annotation), srcPos);
    }

    @Override
    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field) {
        return field.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> annotationType) {
        return clazz.isAnnotationPresent(annotationType);
    }

    @Override
    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        Annotation[] r = field.getAnnotations();
        for (int i2 = 0; i2 < r.length; ++i2) {
            r[i2] = LocatableAnnotation.create(r[i2], srcPos);
        }
        return r;
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation, Method method, Locatable srcPos) {
        return LocatableAnnotation.create(method.getAnnotation(annotation), srcPos);
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> annotation, Method method) {
        return method.isAnnotationPresent(annotation);
    }

    @Override
    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        Annotation[] r = method.getAnnotations();
        for (int i2 = 0; i2 < r.length; ++i2) {
            r[i2] = LocatableAnnotation.create(r[i2], srcPos);
        }
        return r;
    }

    @Override
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        Annotation[] pa;
        for (Annotation a2 : pa = method.getParameterAnnotations()[paramIndex]) {
            if (a2.annotationType() != annotation) continue;
            return (A)LocatableAnnotation.create(a2, srcPos);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<A> a2, Class clazz, Locatable srcPos) {
        return LocatableAnnotation.create(clazz.getAnnotation(a2), srcPos);
    }

    @Override
    public <A extends Annotation> A getPackageAnnotation(Class<A> a2, Class clazz, Locatable srcPos) {
        Package p = clazz.getPackage();
        if (p == null) {
            return null;
        }
        Map cache = this.packageCache.computeIfAbsent(a2, k2 -> new HashMap());
        if (cache.containsKey(p)) {
            return (A)((Annotation)cache.get(p));
        }
        A ann = LocatableAnnotation.create(p.getAnnotation(a2), srcPos);
        cache.put(p, ann);
        return ann;
    }

    @Override
    public Class getClassValue(Annotation a2, String name) {
        try {
            return (Class)a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(Messages.CLASS_NOT_FOUND.format(a2.annotationType(), e3.getMessage()));
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    public Class[] getClassArrayValue(Annotation a2, String name) {
        try {
            return (Class[])a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(e3.getMessage());
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    @Override
    protected String fullName(Method m2) {
        return m2.getDeclaringClass().getName() + "#" + m2.getName();
    }
}

