/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.model.impl;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlRegistry;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.v2.model.annotation.AnnotationReader;
import org.glassfish.jaxb.core.v2.model.annotation.Locatable;
import org.glassfish.jaxb.core.v2.model.core.ArrayInfo;
import org.glassfish.jaxb.core.v2.model.core.ClassInfo;
import org.glassfish.jaxb.core.v2.model.core.ElementInfo;
import org.glassfish.jaxb.core.v2.model.core.EnumLeafInfo;
import org.glassfish.jaxb.core.v2.model.core.ErrorHandler;
import org.glassfish.jaxb.core.v2.model.core.NonElement;
import org.glassfish.jaxb.core.v2.model.core.PropertyInfo;
import org.glassfish.jaxb.core.v2.model.core.PropertyKind;
import org.glassfish.jaxb.core.v2.model.core.Ref;
import org.glassfish.jaxb.core.v2.model.core.RegistryInfo;
import org.glassfish.jaxb.core.v2.model.core.TypeInfo;
import org.glassfish.jaxb.core.v2.model.core.TypeInfoSet;
import org.glassfish.jaxb.core.v2.model.impl.ModelBuilderI;
import org.glassfish.jaxb.core.v2.model.nav.Navigator;
import org.glassfish.jaxb.core.v2.runtime.IllegalAnnotationException;
import org.glassfish.jaxb.runtime.v2.model.annotation.ClassLocatable;
import org.glassfish.jaxb.runtime.v2.model.impl.ArrayInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.BuiltinLeafInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.ClassInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.ElementInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.EnumLeafInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.Messages;
import org.glassfish.jaxb.runtime.v2.model.impl.RegistryInfoImpl;
import org.glassfish.jaxb.runtime.v2.model.impl.TypeInfoSetImpl;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimePropertyInfo;

public class ModelBuilder<T, C, F, M>
implements ModelBuilderI<T, C, F, M> {
    private static final Logger logger = Logger.getLogger(ModelBuilder.class.getName());
    final TypeInfoSetImpl<T, C, F, M> typeInfoSet;
    public final AnnotationReader<T, C, F, M> reader;
    public final Navigator<T, C, F, M> nav;
    private final Map<QName, TypeInfo> typeNames = new HashMap<QName, TypeInfo>();
    public final String defaultNsUri;
    final Map<String, RegistryInfoImpl<T, C, F, M>> registries = new HashMap<String, RegistryInfoImpl<T, C, F, M>>();
    private final Map<C, C> subclassReplacements;
    private ErrorHandler errorHandler;
    private boolean hadError;
    public boolean hasSwaRef;
    private final ErrorHandler proxyErrorHandler = new ErrorHandler(){

        @Override
        public void error(IllegalAnnotationException e2) {
            ModelBuilder.this.reportError(e2);
        }
    };
    private boolean linked;

    public ModelBuilder(AnnotationReader<T, C, F, M> reader, Navigator<T, C, F, M> navigator, Map<C, C> subclassReplacements, String defaultNamespaceRemap) {
        this.reader = reader;
        this.nav = navigator;
        this.subclassReplacements = subclassReplacements;
        if (defaultNamespaceRemap == null) {
            defaultNamespaceRemap = "";
        }
        this.defaultNsUri = defaultNamespaceRemap;
        reader.setErrorHandler(this.proxyErrorHandler);
        this.typeInfoSet = (TypeInfoSetImpl)this.createTypeInfoSet();
    }

    protected TypeInfoSet<T, C, F, M> createTypeInfoSet() {
        return new TypeInfoSetImpl<T, C, F, M>(this.nav, this.reader, BuiltinLeafInfoImpl.createLeaves(this.nav));
    }

    public NonElement<T, C> getClassInfo(C clazz, Locatable upstream) {
        return this.getClassInfo(clazz, false, upstream);
    }

    public NonElement<T, C> getClassInfo(C clazz, boolean searchForSuperClass, Locatable upstream) {
        assert (clazz != null);
        NonElement r = this.typeInfoSet.getClassInfo(clazz);
        if (r != null) {
            return r;
        }
        if (this.nav.isEnum(clazz)) {
            EnumLeafInfoImpl li = (EnumLeafInfoImpl)this.createEnumLeafInfo(clazz, upstream);
            this.typeInfoSet.add(li);
            r = li;
            this.addTypeName(r);
        } else {
            boolean isReplaced = this.subclassReplacements.containsKey(clazz);
            if (isReplaced && !searchForSuperClass) {
                r = this.getClassInfo(this.subclassReplacements.get(clazz), upstream);
            } else if (this.reader.hasClassAnnotation(clazz, XmlTransient.class) || isReplaced) {
                r = this.getClassInfo(this.nav.getSuperClass(clazz), searchForSuperClass, new ClassLocatable<C>(upstream, clazz, this.nav));
            } else {
                ClassInfoImpl ci = (ClassInfoImpl)this.createClassInfo(clazz, upstream);
                this.typeInfoSet.add(ci);
                for (PropertyInfo p : ci.getProperties()) {
                    if (p.kind() == PropertyKind.REFERENCE) {
                        this.addToRegistry(clazz, (Locatable)((Object)p));
                        Class[] prmzdClasses = this.getParametrizedTypes(p);
                        if (prmzdClasses != null) {
                            for (Class prmzdClass : prmzdClasses) {
                                if (prmzdClass == clazz) continue;
                                this.addToRegistry(prmzdClass, (Locatable)((Object)p));
                            }
                        }
                    }
                    for (TypeInfo typeInfo : p.ref()) {
                    }
                }
                ci.getBaseClass();
                r = ci;
                this.addTypeName(r);
            }
        }
        XmlSeeAlso sa = this.reader.getClassAnnotation(XmlSeeAlso.class, clazz, upstream);
        if (sa != null) {
            for (T t : this.reader.getClassArrayValue(sa, "value")) {
                this.getTypeInfo(t, (Locatable)((Object)sa));
            }
        }
        return r;
    }

    private void addToRegistry(C clazz, Locatable p) {
        C c2;
        String pkg = this.nav.getPackageName(clazz);
        if (!this.registries.containsKey(pkg) && (c2 = this.nav.loadObjectFactory(clazz, pkg)) != null) {
            this.addRegistry(c2, p);
        }
    }

    private Class[] getParametrizedTypes(PropertyInfo p) {
        try {
            ParameterizedType prmzdType;
            Type pType = ((RuntimePropertyInfo)p).getIndividualType();
            if (pType instanceof ParameterizedType && (prmzdType = (ParameterizedType)pType).getRawType() == JAXBElement.class) {
                Type[] actualTypes = prmzdType.getActualTypeArguments();
                Class[] result = new Class[actualTypes.length];
                for (int i2 = 0; i2 < actualTypes.length; ++i2) {
                    result[i2] = (Class)actualTypes[i2];
                }
                return result;
            }
        }
        catch (Exception e2) {
            logger.log(Level.FINE, "Error in ModelBuilder.getParametrizedTypes. " + e2.getMessage());
        }
        return null;
    }

    private void addTypeName(NonElement<T, C> r) {
        QName t = r.getTypeName();
        if (t == null) {
            return;
        }
        TypeInfo old = this.typeNames.put(t, r);
        if (old != null) {
            this.reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_TYPE_MAPPING.format(r.getTypeName()), old, r));
        }
    }

    public NonElement<T, C> getTypeInfo(T t, Locatable upstream) {
        NonElement<T, C> r = this.typeInfoSet.getTypeInfo(t);
        if (r != null) {
            return r;
        }
        if (this.nav.isArray(t)) {
            ArrayInfoImpl ai = (ArrayInfoImpl)this.createArrayInfo(upstream, t);
            this.addTypeName(ai);
            this.typeInfoSet.add(ai);
            return ai;
        }
        C c2 = this.nav.asDecl(t);
        assert (c2 != null) : t.toString() + " must be a leaf, but we failed to recognize it.";
        return this.getClassInfo(c2, upstream);
    }

    public NonElement<T, C> getTypeInfo(Ref<T, C> ref) {
        assert (!ref.valueList);
        C c2 = this.nav.asDecl(ref.type);
        if (c2 != null && this.reader.getClassAnnotation(XmlRegistry.class, c2, null) != null) {
            if (!this.registries.containsKey(this.nav.getPackageName(c2))) {
                this.addRegistry(c2, null);
            }
            return null;
        }
        return this.getTypeInfo(ref.type, null);
    }

    protected EnumLeafInfo<T, C> createEnumLeafInfo(C clazz, Locatable upstream) {
        return new EnumLeafInfoImpl(this, upstream, clazz, this.nav.use(clazz));
    }

    protected ClassInfo<T, C> createClassInfo(C clazz, Locatable upstream) {
        return new ClassInfoImpl(this, upstream, clazz);
    }

    protected ElementInfo<T, C> createElementInfo(RegistryInfo<T, C> registryInfo, M m2) throws IllegalAnnotationException {
        return new ElementInfoImpl(this, (RegistryInfoImpl)registryInfo, m2);
    }

    protected ArrayInfo<T, C> createArrayInfo(Locatable upstream, T arrayType) {
        return new ArrayInfoImpl(this, upstream, arrayType);
    }

    public RegistryInfo<T, C> addRegistry(C registryClass, Locatable upstream) {
        return new RegistryInfoImpl(this, upstream, registryClass);
    }

    public RegistryInfo<T, C> getRegistry(String packageName) {
        return this.registries.get(packageName);
    }

    public TypeInfoSet<T, C, F, M> link() {
        assert (!this.linked);
        this.linked = true;
        for (ElementInfoImpl<T, C, F, M> elementInfoImpl : this.typeInfoSet.getAllElements()) {
            elementInfoImpl.link();
        }
        for (ClassInfoImpl classInfoImpl : this.typeInfoSet.beans().values()) {
            classInfoImpl.link();
        }
        for (EnumLeafInfoImpl enumLeafInfoImpl : this.typeInfoSet.enums().values()) {
            enumLeafInfoImpl.link();
        }
        if (this.hadError) {
            return null;
        }
        return this.typeInfoSet;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final void reportError(IllegalAnnotationException e2) {
        this.hadError = true;
        if (this.errorHandler != null) {
            this.errorHandler.error(e2);
        }
    }

    public boolean isReplaced(C sc) {
        return this.subclassReplacements.containsKey(sc);
    }

    @Override
    public Navigator<T, C, F, M> getNavigator() {
        return this.nav;
    }

    @Override
    public AnnotationReader<T, C, F, M> getReader() {
        return this.reader;
    }
}

