/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.DefaultTagProvider;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;

public class HtmlCleaner {
    public static final String DEFAULT_CHARSET = System.getProperty("file.encoding");
    private CleanerProperties properties;
    private ITagInfoProvider tagInfoProvider;
    private CleanerTransformations transformations = null;
    private transient OpenTags _openTags;
    private transient boolean _headOpened = false;
    private transient boolean _bodyOpened = false;
    private transient Set _headTags = new LinkedHashSet();
    private Set allTags = new TreeSet();
    private TagNode htmlNode;
    private TagNode bodyNode;
    private TagNode headNode;
    private TagNode rootNode;
    private Set pruneTagSet = new HashSet();
    private Set pruneNodeSet = new HashSet();

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider iTagInfoProvider) {
        this(iTagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties cleanerProperties) {
        this(null, cleanerProperties);
    }

    public HtmlCleaner(ITagInfoProvider iTagInfoProvider, CleanerProperties cleanerProperties) {
        this.tagInfoProvider = iTagInfoProvider == null ? DefaultTagProvider.getInstance() : iTagInfoProvider;
        this.properties = cleanerProperties == null ? new CleanerProperties() : cleanerProperties;
        this.properties.tagInfoProvider = this.tagInfoProvider;
    }

    public TagNode clean(String string) throws IOException {
        return this.clean(new StringReader(string));
    }

    public TagNode clean(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
        return this.clean(inputStreamReader);
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, DEFAULT_CHARSET);
    }

    public TagNode clean(URL uRL, String string) throws IOException {
        StringBuffer stringBuffer = Utils.readUrl(uRL, string);
        StringReader stringReader = new StringReader(stringBuffer.toString());
        return this.clean(stringReader);
    }

    public TagNode clean(URL uRL) throws IOException {
        return this.clean(uRL, DEFAULT_CHARSET);
    }

    public TagNode clean(InputStream inputStream, String string) throws IOException {
        return this.clean(new InputStreamReader(inputStream, string));
    }

    public TagNode clean(InputStream inputStream) throws IOException {
        return this.clean(inputStream, DEFAULT_CHARSET);
    }

    public TagNode clean(Reader reader) throws IOException {
        this._openTags = new OpenTags();
        this._headOpened = false;
        this._bodyOpened = false;
        this._headTags.clear();
        this.allTags.clear();
        this.setPruneTags(this.properties.pruneTags);
        this.htmlNode = new TagNode("html", this);
        this.bodyNode = new TagNode("body", this);
        this.headNode = new TagNode("head", this);
        this.rootNode = null;
        this.htmlNode.addChild(this.headNode);
        this.htmlNode.addChild(this.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader);
        htmlTokenizer.start();
        List list = htmlTokenizer.getTokenList();
        this.closeAll(list);
        this.createDocumentNodes(list);
        this.calculateRootNode(htmlTokenizer.getNamespacePrefixes());
        if (this.pruneNodeSet != null && !this.pruneNodeSet.isEmpty()) {
            Iterator iterator = this.pruneNodeSet.iterator();
            while (iterator.hasNext()) {
                TagNode tagNode = (TagNode)iterator.next();
                TagNode tagNode2 = tagNode.getParent();
                if (tagNode2 == null) continue;
                tagNode2.removeChild(tagNode);
            }
        }
        this.rootNode.setDocType(htmlTokenizer.getDocType());
        return this.rootNode;
    }

    private void calculateRootNode(Set set) {
        Object object;
        Iterator iterator;
        Object object2;
        this.rootNode = this.htmlNode;
        if (this.properties.omitHtmlEnvelope && (object2 = this.bodyNode.getChildren()) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof TagNode)) continue;
                this.rootNode = (TagNode)object;
            }
        }
        object2 = this.rootNode.getAttributes();
        if (this.properties.namespacesAware && set != null) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                String string = "xmlns:" + object;
                if (object2.containsKey(string)) continue;
                this.rootNode.addAttribute(string, (String)object);
            }
        }
    }

    private void addAttributesToTag(TagNode tagNode, Map map) {
        if (map != null) {
            Map map2 = tagNode.getAttributes();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (map2.containsKey(string)) continue;
                String string2 = (String)entry.getValue();
                tagNode.addAttribute(string, string2);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tagInfo) {
        if (tagInfo != null) {
            String string = tagInfo.getFatalTag();
            return string == null ? true : this._openTags.tagExists(string);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tagInfo) {
        String string;
        if (tagInfo != null && (string = tagInfo.getRequiredParent()) != null) {
            Object object;
            String string2 = tagInfo.getFatalTag();
            int n = -1;
            if (string2 != null && (object = this._openTags.findTag(string2)) != null) {
                n = ((TagPos)object).position;
            }
            object = this._openTags.list.listIterator(this._openTags.list.size());
            while (object.hasPrevious()) {
                TagPos tagPos = (TagPos)object.previous();
                if (!tagInfo.isHigher(tagPos.name)) continue;
                return tagPos.position <= n;
            }
            return true;
        }
        return false;
    }

    private TagNode createTagNode(TagNode tagNode) {
        tagNode.setFormed();
        return tagNode;
    }

    private boolean isAllowedInLastOpenTag(BaseToken baseToken) {
        TagPos tagPos = this._openTags.getLastTagPos();
        if (tagPos != null && tagPos.info != null) {
            return tagPos.info.allowsItem(baseToken);
        }
        return true;
    }

    private void saveToLastOpenTag(List list, Object object) {
        TagPos tagPos = this._openTags.getLastTagPos();
        if (tagPos != null && tagPos.info != null && tagPos.info.isIgnorePermitted()) {
            return;
        }
        TagPos tagPos2 = this._openTags.findTagToPlaceRubbish();
        if (tagPos2 != null) {
            TagNode tagNode = (TagNode)list.get(tagPos2.position);
            tagNode.addItemForMoving(object);
        }
    }

    private boolean isStartToken(Object object) {
        return object instanceof TagNode && !((TagNode)object).isFormed();
    }

    void makeTree(List list, ListIterator listIterator) {
        while (listIterator.hasNext()) {
            Object object;
            TagPos tagPos;
            TagInfo tagInfo;
            String string;
            TagToken tagToken;
            BaseToken baseToken = (BaseToken)listIterator.next();
            if (baseToken instanceof EndTagToken) {
                tagToken = (EndTagToken)baseToken;
                string = tagToken.getName();
                tagInfo = this.tagInfoProvider.getTagInfo(string);
                if (tagInfo == null && this.properties.omitUnknownTags || tagInfo != null && tagInfo.isDeprecated() && this.properties.omitDeprecatedTags) {
                    listIterator.set(null);
                    continue;
                }
                if (tagInfo != null && !tagInfo.allowsBody()) {
                    listIterator.set(null);
                    continue;
                }
                tagPos = this._openTags.findTag(string);
                if (tagPos != null) {
                    object = this.closeSnippet(list, tagPos, tagToken);
                    listIterator.set(null);
                    for (int i2 = object.size() - 1; i2 >= 1; --i2) {
                        TagNode tagNode = (TagNode)object.get(i2);
                        if (tagInfo == null || !tagInfo.isContinueAfter(tagNode.getName())) continue;
                        listIterator.add(tagNode.makeCopy());
                        listIterator.previous();
                    }
                    continue;
                }
                if (this.isAllowedInLastOpenTag(baseToken)) continue;
                this.saveToLastOpenTag(list, baseToken);
                listIterator.set(null);
                continue;
            }
            if (this.isStartToken(baseToken)) {
                tagToken = (TagNode)baseToken;
                string = tagToken.getName();
                tagInfo = this.tagInfoProvider.getTagInfo(string);
                tagPos = this._openTags.isEmpty() ? null : this._openTags.getLastTagPos();
                object = tagPos == null ? null : this.tagInfoProvider.getTagInfo(tagPos.name);
                this.allTags.add(string);
                if ("html".equals(string)) {
                    this.addAttributesToTag(this.htmlNode, ((TagNode)tagToken).getAttributes());
                    listIterator.set(null);
                    continue;
                }
                if ("body".equals(string)) {
                    this._bodyOpened = true;
                    this.addAttributesToTag(this.bodyNode, ((TagNode)tagToken).getAttributes());
                    listIterator.set(null);
                    continue;
                }
                if ("head".equals(string)) {
                    this._headOpened = true;
                    this.addAttributesToTag(this.headNode, ((TagNode)tagToken).getAttributes());
                    listIterator.set(null);
                    continue;
                }
                if (tagInfo == null && this.properties.omitUnknownTags || tagInfo != null && tagInfo.isDeprecated() && this.properties.omitDeprecatedTags) {
                    listIterator.set(null);
                    continue;
                }
                if (tagInfo == null && object != null && !((TagInfo)object).allowsAnything()) {
                    this.closeSnippet(list, tagPos, tagToken);
                    listIterator.previous();
                    continue;
                }
                if (tagInfo != null && tagInfo.hasPermittedTags() && this._openTags.someAlreadyOpen(tagInfo.getPermittedTags())) {
                    listIterator.set(null);
                    continue;
                }
                if (tagInfo != null && tagInfo.isUnique() && this._openTags.tagEncountered(string)) {
                    listIterator.set(null);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tagInfo)) {
                    listIterator.set(null);
                    continue;
                }
                if (this.mustAddRequiredParent(tagInfo)) {
                    String string2 = tagInfo.getRequiredParent();
                    TagNode tagNode = new TagNode(string2, this);
                    listIterator.previous();
                    listIterator.add(tagNode);
                    listIterator.previous();
                    continue;
                }
                if (tagInfo != null && tagPos != null && tagInfo.isMustCloseTag((TagInfo)object)) {
                    List list2 = this.closeSnippet(list, tagPos, tagToken);
                    int n = list2.size();
                    if (tagInfo.hasCopyTags() && n > 0) {
                        Object object2;
                        ListIterator listIterator2 = list2.listIterator(n);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        while (listIterator2.hasPrevious() && tagInfo.isCopy(((TagToken)(object2 = (TagNode)listIterator2.previous())).getName())) {
                            arrayList.add(0, object2);
                        }
                        if (arrayList.size() > 0) {
                            object2 = arrayList.iterator();
                            while (object2.hasNext()) {
                                TagNode tagNode = (TagNode)object2.next();
                                listIterator.add(tagNode.makeCopy());
                            }
                            for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                                listIterator.previous();
                            }
                        }
                    }
                    listIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(baseToken)) {
                    this.saveToLastOpenTag(list, baseToken);
                    listIterator.set(null);
                    continue;
                }
                if (tagInfo != null && !tagInfo.allowsBody()) {
                    TagNode tagNode = this.createTagNode((TagNode)tagToken);
                    this.addPossibleHeadCandidate(tagInfo, tagNode);
                    listIterator.set(tagNode);
                    continue;
                }
                this._openTags.addTag(string, listIterator.previousIndex());
                continue;
            }
            if (this.isAllowedInLastOpenTag(baseToken)) continue;
            this.saveToLastOpenTag(list, baseToken);
            listIterator.set(null);
        }
    }

    private void createDocumentNodes(List list) {
        TagNode tagNode;
        Object object;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) continue;
            boolean bl = true;
            if (object instanceof TagNode) {
                tagNode = (TagNode)object;
                TagInfo tagInfo = this.tagInfoProvider.getTagInfo(tagNode.getName());
                this.addPossibleHeadCandidate(tagInfo, tagNode);
            } else if (object instanceof ContentToken) {
                boolean bl2 = bl = !"".equals(object.toString());
            }
            if (!bl) continue;
            this.bodyNode.addChild(object);
        }
        object = this._headTags.iterator();
        while (object.hasNext()) {
            TagNode tagNode2 = (TagNode)object.next();
            boolean bl = true;
            for (tagNode = tagNode2.getParent(); tagNode != null; tagNode = tagNode.getParent()) {
                if (!this._headTags.contains(tagNode)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            tagNode2.removeFromTree();
            this.headNode.addChild(tagNode2);
        }
    }

    private List closeSnippet(List list, TagPos tagPos, Object object) {
        ArrayList<TagNode> arrayList = new ArrayList<TagNode>();
        ListIterator<Object> listIterator = list.listIterator(tagPos.position);
        Object object2 = null;
        Object e2 = listIterator.next();
        boolean bl = false;
        while (object == null && !bl || object != null && e2 != object) {
            if (this.isStartToken(e2)) {
                Object object3;
                TagNode tagNode = (TagNode)e2;
                arrayList.add(tagNode);
                List list2 = tagNode.getItemsToMove();
                if (list2 != null) {
                    object3 = this._openTags;
                    this._openTags = new OpenTags();
                    this.makeTree(list2, list2.listIterator(0));
                    this.closeAll(list2);
                    tagNode.setItemsToMove(null);
                    this._openTags = object3;
                }
                object3 = this.createTagNode(tagNode);
                TagInfo tagInfo = this.tagInfoProvider.getTagInfo(((TagToken)object3).getName());
                this.addPossibleHeadCandidate(tagInfo, (TagNode)object3);
                if (object2 != null) {
                    ((TagNode)object2).addChildren(list2);
                    ((TagNode)object2).addChild(object3);
                    listIterator.set(null);
                } else if (list2 != null) {
                    list2.add(object3);
                    listIterator.set(list2);
                } else {
                    listIterator.set(object3);
                }
                this._openTags.removeTag(((TagToken)object3).getName());
                object2 = object3;
            } else if (object2 != null) {
                listIterator.set(null);
                if (e2 != null) {
                    ((TagNode)object2).addChild(e2);
                }
            }
            if (listIterator.hasNext()) {
                e2 = listIterator.next();
                continue;
            }
            bl = true;
        }
        return arrayList;
    }

    private void closeAll(List list) {
        TagPos tagPos = this._openTags.findFirstTagPos();
        if (tagPos != null) {
            this.closeSnippet(list, tagPos, null);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && this._headOpened && !this._bodyOpened)) {
            this._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    public Set getPruneTagSet() {
        return this.pruneTagSet;
    }

    private void setPruneTags(String string) {
        this.pruneTagSet.clear();
        this.pruneNodeSet.clear();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.pruneTagSet.add(stringTokenizer.nextToken().trim().toLowerCase());
            }
        }
    }

    void addPruneNode(TagNode tagNode) {
        this.pruneNodeSet.add(tagNode);
    }

    public Set getAllTags() {
        return this.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.tagInfoProvider;
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public void setTransformations(CleanerTransformations cleanerTransformations) {
        this.transformations = cleanerTransformations;
    }

    public String getInnerHtml(TagNode tagNode) {
        if (tagNode != null) {
            try {
                String string = new SimpleXmlSerializer(this.properties).getXmlAsString(tagNode);
                int n = string.indexOf("<" + tagNode.getName());
                n = string.indexOf(62, n + 1);
                int n2 = string.lastIndexOf(60);
                return n >= 0 && n <= n2 ? string.substring(n + 1, n2) : null;
            }
            catch (IOException iOException) {
                throw new HtmlCleanerException(iOException);
            }
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode tagNode, String string) {
        if (tagNode != null) {
            Object object;
            String string2 = tagNode.getName();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<" + string2 + " marker=''>");
            stringBuffer.append(string);
            stringBuffer.append("</" + string2 + ">");
            for (TagNode tagNode2 = tagNode.getParent(); tagNode2 != null; tagNode2 = tagNode2.getParent()) {
                object = tagNode2.getName();
                stringBuffer.insert(0, "<" + (String)object + ">");
                stringBuffer.append("</" + (String)object + ">");
            }
            try {
                object = this.clean(stringBuffer.toString());
                TagNode tagNode3 = ((TagNode)object).findElementHavingAttribute("marker", true);
                if (tagNode3 != null) {
                    tagNode.setChildren(tagNode3.getChildren());
                }
            }
            catch (IOException iOException) {
                throw new HtmlCleanerException(iOException);
            }
        }
    }

    private class OpenTags {
        private List list = new ArrayList();
        private TagPos last = null;
        private Set set = new HashSet();

        private OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String string, int n) {
            this.last = new TagPos(n, string);
            this.list.add(this.last);
            this.set.add(string);
        }

        private void removeTag(String string) {
            ListIterator listIterator = this.list.listIterator(this.list.size());
            while (listIterator.hasPrevious()) {
                TagPos tagPos = (TagPos)listIterator.previous();
                if (!string.equals(tagPos.name)) continue;
                listIterator.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : (TagPos)this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : (TagPos)this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String string) {
            if (string != null) {
                ListIterator listIterator = this.list.listIterator(this.list.size());
                String string2 = null;
                TagInfo tagInfo = HtmlCleaner.this.tagInfoProvider.getTagInfo(string);
                if (tagInfo != null) {
                    string2 = tagInfo.getFatalTag();
                }
                while (listIterator.hasPrevious()) {
                    TagPos tagPos = (TagPos)listIterator.previous();
                    if (string.equals(tagPos.name)) {
                        return tagPos;
                    }
                    if (string2 == null || !string2.equals(tagPos.name)) continue;
                    return null;
                }
            }
            return null;
        }

        private boolean tagExists(String string) {
            TagPos tagPos = this.findTag(string);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos tagPos = null;
            TagPos tagPos2 = null;
            if (!this.isEmpty()) {
                ListIterator listIterator = this.list.listIterator(this.list.size());
                while (listIterator.hasPrevious()) {
                    tagPos = (TagPos)listIterator.previous();
                    if ((tagPos.info == null || tagPos.info.allowsAnything()) && tagPos2 != null) {
                        return tagPos2;
                    }
                    tagPos2 = tagPos;
                }
            }
            return tagPos;
        }

        private boolean tagEncountered(String string) {
            return this.set.contains(string);
        }

        private boolean someAlreadyOpen(Set set) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                TagPos tagPos = (TagPos)iterator.next();
                if (!set.contains(tagPos.name)) continue;
                return true;
            }
            return false;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int n, String string) {
            this.position = n;
            this.name = string;
            this.info = HtmlCleaner.this.tagInfoProvider.getTagInfo(string);
        }
    }
}

