/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.SpecialEntities;
import org.htmlcleaner.TagTransformation;

public class Utils {
    public static String VAR_START = "${";
    public static String VAR_END = "}";

    public static String ltrim(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n >= n2 ? "" : string.substring(n);
    }

    public static String rtrim(String string) {
        int n;
        int n2;
        if (string == null) {
            return null;
        }
        for (n2 = n = string.length(); n2 > 0 && Character.isWhitespace(string.charAt(n2 - 1)); --n2) {
        }
        return n2 <= 0 ? "" : string.substring(0, n2);
    }

    public static StringBuffer readUrl(URL uRL, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(1024);
        Object object = uRL.getContent();
        if (object instanceof InputStream) {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)object, string);
            char[] cArray = new char[1024];
            int n = 0;
            do {
                if ((n = inputStreamReader.read(cArray)) < 0) continue;
                stringBuffer.append(cArray, 0, n);
            } while (n > 0);
        }
        return stringBuffer;
    }

    public static boolean isHexadecimalDigit(char c2) {
        return Character.isDigit(c2) || c2 == 'A' || c2 == 'a' || c2 == 'B' || c2 == 'b' || c2 == 'C' || c2 == 'c' || c2 == 'D' || c2 == 'd' || c2 == 'E' || c2 == 'e' || c2 == 'F' || c2 == 'f';
    }

    public static String escapeXml(String string, CleanerProperties cleanerProperties, boolean bl) {
        boolean bl2 = cleanerProperties.isAdvancedXmlEscape();
        boolean bl3 = cleanerProperties.isRecognizeUnicodeChars();
        boolean bl4 = cleanerProperties.isTranslateSpecialEntities();
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i2 = 0; i2 < n; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '&') {
                    String string2;
                    Integer n2;
                    String string3;
                    int n3;
                    if ((bl2 || bl3) && i2 < n - 1 && string.charAt(i2 + 1) == '#') {
                        int n4;
                        String string4 = "";
                        for (n4 = i2 + 2; n4 < n && (Utils.isHexadecimalDigit(string.charAt(n4)) || string.charAt(n4) == 'x' || string.charAt(n4) == 'X'); ++n4) {
                            string4 = string4 + string.charAt(n4);
                        }
                        if (n4 == n || !"".equals(string4)) {
                            try {
                                char c3;
                                char c4 = c3 = string4.toLowerCase().startsWith("x") ? (char)Integer.parseInt(string4.substring(1), 16) : (char)Integer.parseInt(string4);
                                if ("&<>'\"".indexOf(c3) < 0) {
                                    int n5 = n4 < n && string.charAt(n4) == ';' ? string4.length() + 1 : string4.length();
                                    stringBuffer.append(bl3 ? String.valueOf(c3) : "&#" + string4 + ";");
                                    i2 += n5 + 1;
                                    continue;
                                }
                                i2 = n4;
                                stringBuffer.append("&amp;#" + string4 + ";");
                            }
                            catch (NumberFormatException numberFormatException) {
                                i2 = n4;
                                stringBuffer.append("&amp;#" + string4 + ";");
                            }
                            continue;
                        }
                        stringBuffer.append("&amp;");
                        continue;
                    }
                    if (bl4 && (n3 = (string3 = string.substring(i2, i2 + Math.min(10, n - i2))).indexOf(59)) > 0 && (n2 = (Integer)SpecialEntities.entities.get(string2 = string3.substring(1, n3))) != null) {
                        int n6 = string2.length();
                        if (bl3) {
                            stringBuffer.append((char)n2.intValue());
                        } else {
                            stringBuffer.append("&#" + n2 + ";");
                        }
                        i2 += n6 + 1;
                        continue;
                    }
                    if (bl2) {
                        String string5 = string.substring(i2);
                        if (string5.startsWith("&amp;")) {
                            stringBuffer.append(bl ? "&" : "&amp;");
                            i2 += 4;
                            continue;
                        }
                        if (string5.startsWith("&apos;")) {
                            stringBuffer.append(bl ? "'" : "&apos;");
                            i2 += 5;
                            continue;
                        }
                        if (string5.startsWith("&gt;")) {
                            stringBuffer.append(bl ? ">" : "&gt;");
                            i2 += 3;
                            continue;
                        }
                        if (string5.startsWith("&lt;")) {
                            stringBuffer.append(bl ? "<" : "&lt;");
                            i2 += 3;
                            continue;
                        }
                        if (string5.startsWith("&quot;")) {
                            stringBuffer.append(bl ? "\"" : "&quot;");
                            i2 += 5;
                            continue;
                        }
                        stringBuffer.append(bl ? "&" : "&amp;");
                        continue;
                    }
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c2 == '\'') {
                    stringBuffer.append("&apos;");
                    continue;
                }
                if (c2 == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c2 == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c2 == '\"') {
                    stringBuffer.append("&quot;");
                    continue;
                }
                stringBuffer.append(c2);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static boolean isWhitespaceString(Object object) {
        if (object != null) {
            String string = object.toString();
            return string != null && "".equals(string.trim());
        }
        return false;
    }

    public static boolean isIdentifierHelperChar(char c2) {
        return ':' == c2 || '.' == c2 || '-' == c2 || '_' == c2;
    }

    public static boolean isValidXmlIdentifier(String string) {
        if (string != null) {
            int n = string.length();
            if (n == 0) {
                return false;
            }
            for (int i2 = 0; i2 < n; ++i2) {
                char c2 = string.charAt(i2);
                if ((i2 != 0 || Character.isUnicodeIdentifierStart(c2)) && (Character.isUnicodeIdentifierStart(c2) || Character.isDigit(c2) || Utils.isIdentifierHelperChar(c2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmptyString(Object object) {
        return object == null || "".equals(object.toString().trim());
    }

    public static String evaluateTemplate(String string, Map map) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(VAR_START);
        int n2 = -1;
        while (n >= 0 && n < string.length()) {
            stringBuffer.append(string.substring(n2 + 1, n));
            n2 = string.indexOf(VAR_END, n);
            if (n2 > n) {
                String string2 = string.substring(n + VAR_START.length(), n2);
                String string3 = map != null ? map.get(string2.toLowerCase()) : "";
                stringBuffer.append(string3 == null ? "" : string3.toString());
            }
            n = string.indexOf(VAR_START, Math.max(n2 + VAR_END.length(), n + 1));
        }
        stringBuffer.append(string.substring(n2 + 1));
        return stringBuffer.toString();
    }

    public static String[] tokenize(String string, String string2) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static void updateTagTransformations(CleanerTransformations cleanerTransformations, String string, String string2) {
        int n = string.indexOf(46);
        if (n <= 0) {
            Object object;
            String string3 = null;
            boolean bl = true;
            if (string2 != null) {
                object = Utils.tokenize(string2, ",;");
                if (((String[])object).length > 0) {
                    string3 = object[0];
                }
                if (((String[])object).length > 1) {
                    bl = "true".equalsIgnoreCase(object[1]) || "yes".equalsIgnoreCase(object[1]) || "1".equals(object[1]);
                }
            }
            object = new TagTransformation(string, string3, bl);
            cleanerTransformations.addTransformation((TagTransformation)object);
        } else {
            String[] stringArray = Utils.tokenize(string, ".");
            String string4 = stringArray[0];
            TagTransformation tagTransformation = cleanerTransformations.getTransformation(string4);
            if (tagTransformation != null) {
                tagTransformation.addAttributeTransformation(stringArray[1], string2);
            }
        }
    }
}

