/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXButton
extends JButton {
    private String text = "";
    private boolean borderPainted;
    private boolean contentAreaFilled;
    private Painter<JXButton> fgPainter = new DefaultForegroundPainter();
    private Painter<JXButton> bgPainter = new DefaultBackgroundPainter();
    private boolean paintBorderInsets = true;
    private boolean painting;
    private boolean opaque = true;

    public JXButton() {
    }

    public JXButton(String text) {
        super(text);
        this.text = text;
    }

    public JXButton(Action a2) {
        this.setAction(a2);
    }

    public JXButton(Icon icon) {
        super(icon);
    }

    public JXButton(String text, Icon icon) {
        super(text, icon);
        this.text = text;
    }

    @Override
    protected void init(String text, Icon icon) {
        this.borderPainted = true;
        this.contentAreaFilled = true;
        super.init(text, icon);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        super.setText(text);
    }

    @Override
    public void repaint() {
        if (this.painting) {
            return;
        }
        super.repaint();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setBorderPainted(boolean b2) {
        this.borderPainted = b2;
        super.setBorderPainted(b2);
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setContentAreaFilled(boolean b2) {
        this.contentAreaFilled = b2;
        super.setContentAreaFilled(b2);
    }

    @Override
    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public Painter<JXButton> getBackgroundPainter() {
        return this.bgPainter;
    }

    public void setBackgroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getBackgroundPainter();
        this.bgPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter<JXButton> getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getForegroundPainter();
        this.fgPainter = p;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    @Override
    public boolean isOpaque() {
        return this.painting ? this.opaque : super.isOpaque();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        Painter<JXButton> bgPainter = this.getBackgroundPainter();
        Painter<JXButton> fgPainter = this.getForegroundPainter();
        if (this.painting || bgPainter == null && fgPainter == null) {
            super.paintComponent(g2);
        } else {
            this.invokePainter(g2, bgPainter);
            this.invokePainter(g2, fgPainter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePainter(Graphics g2, Painter<JXButton> ptr) {
        if (ptr == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g2.create();
        try {
            if (this.isPaintBorderInsets()) {
                ptr.paint(g2d, this, this.getWidth(), this.getHeight());
            } else {
                Insets ins = this.getInsets();
                g2d.translate(ins.left, ins.top);
                ptr.paint(g2d, this, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    protected void setPainting(boolean b2) {
        this.painting = b2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultForegroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultForegroundPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doPaint(Graphics2D g2, JXButton b2, int width, int height) {
            b2.setPainting(true);
            boolean t1 = b2.isBorderPainted();
            boolean t2 = b2.isContentAreaFilled();
            boolean op = b2.opaque;
            b2.borderPainted = false;
            b2.contentAreaFilled = false;
            b2.opaque = false;
            try {
                b2.paint(g2);
            }
            finally {
                b2.opaque = op;
                b2.borderPainted = t1;
                b2.contentAreaFilled = t2;
                b2.setPainting(false);
            }
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBackgroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultBackgroundPainter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doPaint(Graphics2D g2, JXButton b2, int width, int height) {
            boolean op = b2.opaque;
            b2.opaque = b2.isOpaque();
            b2.setPainting(true);
            String tmp = b2.text;
            Icon tmpIcon = b2.getIcon();
            b2.setIcon(null);
            b2.text = "";
            try {
                b2.paint(g2);
            }
            finally {
                b2.opaque = op;
                b2.text = tmp;
                b2.setIcon(tmpIcon);
                b2.setPainting(false);
            }
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }
}

