/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.swingx.JXPanel;

public class JXGlassBox
extends JXPanel {
    private static final int SHOW_DELAY = 30;
    private static final int TIMER_INCREMENT = 10;
    private float alphaStart = 0.01f;
    private float alphaEnd = 0.8f;
    private Timer animateTimer;
    private float alphaIncrement = 0.02f;
    private boolean dismissOnClick = false;
    private MouseAdapter dismissListener = null;

    public JXGlassBox() {
        this.setOpaque(false);
        this.setAlpha(this.alphaStart);
        this.setBackground(Color.white);
        this.setDismissOnClick(true);
        this.animateTimer = new Timer(10, new ActionListener(){

            public void actionPerformed(ActionEvent e2) {
                JXGlassBox.this.setAlpha(Math.min(JXGlassBox.this.alphaEnd, JXGlassBox.this.getAlpha() + JXGlassBox.this.alphaIncrement));
            }
        });
    }

    public JXGlassBox(float alpha) {
        this();
        this.setAlpha(alpha);
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.alphaIncrement = (this.alphaEnd - this.alphaStart) / 3.0f;
    }

    public void dismiss() {
        JComponent parent = (JComponent)this.getParent();
        if (parent != null) {
            Container toplevel = parent.getTopLevelAncestor();
            parent.remove(this);
            toplevel.validate();
            toplevel.repaint();
        }
    }

    public boolean isDismissOnClick() {
        return this.dismissOnClick;
    }

    public void setDismissOnClick(boolean dismissOnClick) {
        boolean oldDismissOnClick = this.dismissOnClick;
        this.dismissOnClick = dismissOnClick;
        this.firePropertyChange("dismissOnClick", oldDismissOnClick, this.isDismissOnClick());
        if (dismissOnClick && !oldDismissOnClick) {
            if (this.dismissListener == null) {
                this.dismissListener = new MouseAdapter(){

                    public void mouseClicked(MouseEvent e2) {
                        JXGlassBox.this.dismiss();
                    }
                };
            }
            this.addMouseListener(this.dismissListener);
        } else if (!dismissOnClick && oldDismissOnClick) {
            this.removeMouseListener(this.dismissListener);
        }
    }

    public void paint(Graphics g2) {
        super.paint(g2);
        if (!this.animateTimer.isRunning() && this.getAlpha() < this.alphaEnd) {
            this.animateTimer.start();
        }
        if (this.animateTimer.isRunning() && this.getAlpha() >= this.alphaEnd) {
            this.animateTimer.stop();
        }
    }

    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        this.setAlpha(this.alphaStart);
        super.setVisible(visible);
        this.firePropertyChange("visible", old, this.isVisible());
    }

    private Container getTopLevel() {
        Container p;
        for (p = this.getParent(); p != null && !(p instanceof Window) && !(p instanceof Applet); p = p.getParent()) {
        }
        return p;
    }

    public void showOnGlassPane(Container glassPane, Component origin, int offsetX, int offsetY, int positionHint) {
        Rectangle r = SwingUtilities.convertRectangle(origin, origin.getBounds(), glassPane);
        Dimension d2 = this.getPreferredSize();
        int originX = offsetX + r.x;
        int originY = offsetY + r.y;
        switch (positionHint) {
            case 1: {
                originX += (r.width - d2.width) / 2;
                originY -= d2.height;
                break;
            }
            case 3: {
                originX += (r.width - d2.width) / 2;
                originY += r.height;
                break;
            }
            case 2: {
                originX -= d2.width;
                originY += (r.height - d2.height) / 2;
                break;
            }
            case 4: {
                originX += r.width;
                originY += (r.height - d2.height) / 2;
                break;
            }
            case 0: {
                originX += (r.width - d2.width) / 2;
                originY += (r.height - d2.height) / 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("inavlid position hint");
            }
        }
        this.showOnGlassPane(glassPane, originX, originY);
    }

    public void showOnGlassPane(Container glassPane, int originX, int originY) {
        Dimension gd = glassPane.getSize();
        Dimension bd = this.getPreferredSize();
        int x = Math.min(originX, gd.width - bd.width);
        int y = Math.min(originY, gd.height - bd.height);
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        int width = x + bd.width < gd.width ? bd.width : gd.width;
        int height = y + bd.height < gd.height ? bd.height : gd.height;
        glassPane.setLayout(null);
        this.setBounds(x, y, width, height);
        glassPane.add(this);
        glassPane.setVisible(true);
        Container topLevel = this.getTopLevel();
        topLevel.validate();
        topLevel.repaint();
    }
}

