/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXImagePanel
extends JXPanel {
    private static final Logger LOG = Logger.getLogger(JXImagePanel.class.getName());
    private static final String TEXT = "<html><i><b>Click here<br>to set the image</b></i></html>";
    private SoftReference<Image> img = new SoftReference<Object>(null);
    private boolean editable = false;
    private MouseHandler mhandler = new MouseHandler();
    private Style style = Style.CENTERED;
    private Image defaultImage;
    private Callable<Image> imageLoader;
    private static final ExecutorService service = Executors.newFixedThreadPool(5);

    public JXImagePanel() {
    }

    public JXImagePanel(URL imageUrl) {
        try {
            this.setImage(ImageIO.read(imageUrl));
        }
        catch (Exception e2) {
            LOG.log(Level.WARNING, "", e2);
        }
    }

    public void setImage(Image image) {
        if (image != this.img.get()) {
            Image oldImage = this.img.get();
            this.img = new SoftReference<Image>(image);
            this.firePropertyChange("image", oldImage, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    public Image getImage() {
        Image image = this.img.get();
        if (image == null && this.imageLoader != null) {
            try {
                image = this.imageLoader.call();
                this.img = new SoftReference<Image>(image);
            }
            catch (Exception e2) {
                LOG.log(Level.WARNING, "", e2);
            }
        }
        return image;
    }

    public void setEditable(boolean editable) {
        if (editable != this.editable) {
            if (this.editable) {
                this.removeMouseListener(this.mhandler);
            }
            this.editable = editable;
            if (this.editable) {
                this.addMouseListener(this.mhandler);
            }
            this.setToolTipText(editable ? TEXT : "");
            this.firePropertyChange("editable", !editable, editable);
            this.repaint();
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setStyle(Style s) {
        if (this.style != s) {
            Style oldStyle = this.style;
            this.style = s;
            this.firePropertyChange("style", (Object)oldStyle, (Object)s);
            this.repaint();
        }
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    public Dimension getPreferredSize() {
        Image img;
        if (!this.isPreferredSizeSet() && this.img != null && (img = this.img.get()) != null) {
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            if (width == -1 || height == -1) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g22 = (Graphics2D)g2;
        Image img = this.img.get();
        if (img == null && this.imageLoader != null) {
            service.execute(new FutureTask<Image>(this.imageLoader){

                @Override
                protected void done() {
                    super.done();
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            try {
                                JXImagePanel.this.setImage((Image)this.get());
                            }
                            catch (InterruptedException e2) {
                            }
                            catch (ExecutionException e3) {
                                LOG.log(Level.WARNING, "", e3);
                            }
                        }
                    });
                }
            });
            img = this.defaultImage;
        }
        if (img != null) {
            int imgWidth = img.getWidth(null);
            int imgHeight = img.getHeight(null);
            if (imgWidth == -1 || imgHeight == -1) {
                return;
            }
            Insets insets = this.getInsets();
            int pw = this.getWidth() - insets.left - insets.right;
            int ph = this.getHeight() - insets.top - insets.bottom;
            switch (this.style) {
                case CENTERED: {
                    Rectangle clipRect = g22.getClipBounds();
                    int imageX = (pw - imgWidth) / 2 + insets.left;
                    int imageY = (ph - imgHeight) / 2 + insets.top;
                    Rectangle r = SwingUtilities.computeIntersection(imageX, imageY, imgWidth, imgHeight, clipRect);
                    if (r.x == 0 && r.y == 0 && (r.width == 0 || r.height == 0)) {
                        return;
                    }
                    clipRect = r;
                    int txClipX = clipRect.x - imageX;
                    int txClipY = clipRect.y - imageY;
                    int txClipW = clipRect.width;
                    int txClipH = clipRect.height;
                    g22.drawImage(img, clipRect.x, clipRect.y, clipRect.x + clipRect.width, clipRect.y + clipRect.height, txClipX, txClipY, txClipX + txClipW, txClipY + txClipH, null);
                    break;
                }
                case TILED: {
                    g22.translate(insets.left, insets.top);
                    Rectangle clip = g22.getClipBounds();
                    g22.setClip(0, 0, pw, ph);
                    for (int totalH = 0; totalH < ph; totalH += img.getHeight(null)) {
                        for (int totalW = 0; totalW < pw; totalW += img.getWidth(null)) {
                            g22.drawImage(img, totalW, totalH, null);
                        }
                    }
                    g22.setClip(clip);
                    g22.translate(-insets.left, -insets.top);
                    break;
                }
                case SCALED: {
                    g22.drawImage(img, insets.left, insets.top, pw, ph, null);
                    break;
                }
                case SCALED_KEEP_ASPECT_RATIO: {
                    int w = pw;
                    int h2 = ph;
                    float ratioW = (float)w / (float)imgWidth;
                    float ratioH = (float)h2 / (float)imgHeight;
                    if (ratioW < ratioH) {
                        h2 = (int)((float)imgHeight * ratioW);
                    } else {
                        w = (int)((float)imgWidth * ratioH);
                    }
                    int x = (pw - w) / 2 + insets.left;
                    int y = (ph - h2) / 2 + insets.top;
                    g22.drawImage(img, x, y, w, h2, null);
                    break;
                }
                default: {
                    LOG.fine("unimplemented");
                    g22.drawImage(img, insets.left, insets.top, this);
                }
            }
        }
    }

    public void setDefaultImage(Image def) {
        this.defaultImage = def;
    }

    public void setImageLoader(Callable<Image> loadImage) {
        this.imageLoader = loadImage;
    }

    private class MouseHandler
    extends MouseAdapter {
        private Cursor oldCursor;
        private JFileChooser chooser;

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            int retVal;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
            }
            if ((retVal = this.chooser.showOpenDialog(JXImagePanel.this)) == 0) {
                File file = this.chooser.getSelectedFile();
                try {
                    JXImagePanel.this.setImage(new ImageIcon(file.toURI().toURL()).getImage());
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }

        public void mouseEntered(MouseEvent evt) {
            if (this.oldCursor == null) {
                this.oldCursor = JXImagePanel.this.getCursor();
                JXImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseExited(MouseEvent evt) {
            if (this.oldCursor != null) {
                JXImagePanel.this.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        CENTERED,
        TILED,
        SCALED,
        SCALED_KEEP_ASPECT_RATIO;

    }
}

