/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.Timer;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.DaySelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.event.EventListenerMap;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.MonthViewAddon;
import org.jdesktop.swingx.plaf.MonthViewUI;
import org.jdesktop.swingx.util.Contract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXMonthView
extends JComponent {
    private static final Logger LOG = Logger.getLogger(JXMonthView.class.getName());
    public static final String COMMIT_KEY = "monthViewCommit";
    public static final String CANCEL_KEY = "monthViewCancel";
    public static final String BOX_PADDING_X = "boxPaddingX";
    public static final String BOX_PADDING_Y = "boxPaddingY";
    public static final String DAYS_OF_THE_WEEK = "daysOfTheWeek";
    public static final String SELECTION_MODEL = "selectionModel";
    public static final String TRAVERSABLE = "traversable";
    public static final String FLAGGED_DATES = "flaggedDates";
    public static final String uiClassID = "MonthViewUI";
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    private Date firstDisplayedDay;
    private Calendar cal;
    private Calendar anchor;
    private Date today;
    private Timer todayTimer;
    private int firstDayOfWeek;
    private DateSelectionModel model;
    private DateSelectionListener modelListener;
    private DaySelectionModel flaggedDates;
    private EventListenerMap listenerMap;
    private boolean traversable;
    private boolean leadingDays;
    private boolean trailingDays;
    private boolean showWeekNumber;
    private boolean componentInputMapEnabled;
    protected Date modifiedStartDate;
    protected Date modifiedEndDate;
    private String[] _daysOfTheWeek;
    protected Insets _monthStringInsets = new Insets(0, 0, 0, 0);
    private int boxPaddingX;
    private int boxPaddingY;
    private int minCalCols = 1;
    private int minCalRows = 1;
    private Color todayBackgroundColor;
    private Color monthStringBackground;
    private Color monthStringForeground;
    private Color daysOfTheWeekForeground;
    private Color selectedBackground;
    private Hashtable<Integer, Color> dayToColorTable = new Hashtable();
    private Color flaggedDayForeground;
    private Color selectedForeground;
    private boolean zoomable;

    public JXMonthView() {
        this(new Date(System.currentTimeMillis()), null, null);
    }

    public JXMonthView(Locale locale) {
        this(new Date(System.currentTimeMillis()), null, locale);
    }

    public JXMonthView(Date firstDisplayedDate) {
        this(firstDisplayedDate, null, null);
    }

    public JXMonthView(Date firstDisplayedDate, DateSelectionModel model) {
        this(firstDisplayedDate, model, null);
    }

    public JXMonthView(Date firstDisplayedDay, DateSelectionModel model, Locale locale) {
        this.listenerMap = new EventListenerMap();
        this.initModel(model, locale);
        this.superSetLocale(locale);
        this.setFirstDisplayedDay(firstDisplayedDay);
        this.updateTodayFromCurrentTime();
        this.updateUI();
        this.setFocusable(true);
        this.todayBackgroundColor = this.getForeground();
    }

    @Override
    public void setLocale(Locale locale) {
        this.model.setLocale(locale);
    }

    private void superSetLocale(Locale locale) {
        if (locale != null) {
            super.setLocale(locale);
            this.repaint();
        }
    }

    public Calendar getCalendar() {
        if (this.cal == null) {
            throw new IllegalStateException("must not be called before instantiation is complete");
        }
        Calendar calendar = (Calendar)this.cal.clone();
        calendar.setTime(this.firstDisplayedDay);
        return calendar;
    }

    public TimeZone getTimeZone() {
        return this.cal.getTimeZone();
    }

    public void setTimeZone(TimeZone tz) {
        this.model.setTimeZone(tz);
    }

    public int getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.getSelectionModel().setFirstDayOfWeek(firstDayOfWeek);
    }

    private void initModel(DateSelectionModel model, Locale locale) {
        if (locale == null) {
            locale = JComponent.getDefaultLocale();
        }
        if (model == null) {
            model = new DaySelectionModel(locale);
        }
        this.model = model;
        this.flaggedDates = new DaySelectionModel(locale);
        this.flaggedDates.setSelectionMode(DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL_SELECTION);
        this.installCalendar();
        model.addDateSelectionListener(this.getDateSelectionListener());
    }

    private DateSelectionListener getDateSelectionListener() {
        if (this.modelListener == null) {
            this.modelListener = new DateSelectionListener(){

                public void valueChanged(DateSelectionEvent ev) {
                    if (DateSelectionEvent.EventType.CALENDAR_CHANGED.equals((Object)ev.getEventType())) {
                        JXMonthView.this.updateCalendar();
                    }
                }
            };
        }
        return this.modelListener;
    }

    private void installCalendar() {
        this.cal = this.model.getCalendar();
        this.firstDayOfWeek = this.cal.getFirstDayOfWeek();
        this.anchor = (Calendar)this.cal.clone();
    }

    protected Date getAnchorDate() {
        return this.anchor.getTime();
    }

    private void updateCalendar() {
        if (!this.getLocale().equals(this.model.getLocale())) {
            this.installCalendar();
            this.superSetLocale(this.model.getLocale());
        } else {
            if (!this.model.getTimeZone().equals(this.getTimeZone())) {
                this.updateTimeZone();
            }
            if (this.cal.getMinimalDaysInFirstWeek() != this.model.getMinimalDaysInFirstWeek()) {
                this.updateMinimalDaysOfFirstWeek();
            }
            if (this.cal.getFirstDayOfWeek() != this.model.getFirstDayOfWeek()) {
                this.updateFirstDayOfWeek();
            }
        }
    }

    private void updateTimeZone() {
        TimeZone old = this.getTimeZone();
        TimeZone tz = this.model.getTimeZone();
        this.cal.setTimeZone(tz);
        this.anchor.setTimeZone(tz);
        this.setFirstDisplayedDay(this.anchor.getTime());
        this.updateTodayFromCurrentTime();
        this.updateDatesAfterTimeZoneChange(old);
        this.firePropertyChange("timeZone", old, this.getTimeZone());
    }

    protected void updateDatesAfterTimeZoneChange(TimeZone oldTimeZone) {
        SortedSet<Date> flagged = this.getFlaggedDates();
        this.flaggedDates.setTimeZone(this.getTimeZone());
        this.firePropertyChange(FLAGGED_DATES, flagged, this.getFlaggedDates());
    }

    private void updateFirstDayOfWeek() {
        int oldFirstDayOfWeek = this.firstDayOfWeek;
        this.firstDayOfWeek = this.getSelectionModel().getFirstDayOfWeek();
        this.cal.setFirstDayOfWeek(this.firstDayOfWeek);
        this.anchor.setFirstDayOfWeek(this.firstDayOfWeek);
        this.firePropertyChange("firstDayOfWeek", oldFirstDayOfWeek, this.firstDayOfWeek);
    }

    private void updateMinimalDaysOfFirstWeek() {
        this.cal.setMinimalDaysInFirstWeek(this.model.getMinimalDaysInFirstWeek());
        this.anchor.setMinimalDaysInFirstWeek(this.model.getMinimalDaysInFirstWeek());
    }

    public Date getLastDisplayedDay() {
        return this.getUI().getLastDisplayedDay();
    }

    public Date getFirstDisplayedDay() {
        return this.firstDisplayedDay;
    }

    public void setFirstDisplayedDay(Date date) {
        this.anchor.setTime(date);
        Date oldDate = this.getFirstDisplayedDay();
        this.cal.setTime(this.anchor.getTime());
        CalendarUtils.startOfMonth(this.cal);
        this.firstDisplayedDay = this.cal.getTime();
        this.firePropertyChange("firstDisplayedDay", oldDate, this.getFirstDisplayedDay());
    }

    public void ensureDateVisible(Date date) {
        if (date.before(this.firstDisplayedDay)) {
            this.setFirstDisplayedDay(date);
        } else {
            Date lastDisplayedDate = this.getLastDisplayedDay();
            if (date.after(lastDisplayedDate)) {
                this.cal.setTime(date);
                int month = this.cal.get(2);
                int year = this.cal.get(1);
                this.cal.setTime(lastDisplayedDate);
                int lastMonth = this.cal.get(2);
                int lastYear = this.cal.get(1);
                int diffMonths = month - lastMonth + (year - lastYear) * 12;
                this.cal.setTime(this.firstDisplayedDay);
                this.cal.add(2, diffMonths);
                this.setFirstDisplayedDay(this.cal.getTime());
            }
        }
    }

    public Date getDayAtLocation(int x, int y) {
        return this.getUI().getDayAtLocation(x, y);
    }

    protected void updateTodayFromCurrentTime() {
        this.setToday(new Date(System.currentTimeMillis()));
    }

    protected void incrementToday() {
        this.cal.setTime(this.getToday());
        this.cal.add(5, 1);
        this.setToday(this.cal.getTime());
    }

    protected void setToday(Date date) {
        Date oldToday = this.getToday();
        this.today = this.startOfDay(date);
        this.firePropertyChange("today", oldToday, this.getToday());
    }

    public Date getToday() {
        return this.today != null ? (Date)this.today.clone() : null;
    }

    private Date startOfDay(Date date) {
        return CalendarUtils.startOfDay(this.cal, date);
    }

    @Override
    public MonthViewUI getUI() {
        return (MonthViewUI)this.ui;
    }

    public void setUI(MonthViewUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.setUI((MonthViewUI)LookAndFeelAddons.getUI(this, MonthViewUI.class));
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public DateSelectionModel getSelectionModel() {
        return this.model;
    }

    public void setSelectionModel(DateSelectionModel model) {
        Contract.asNotNull(model, "date selection model must not be null");
        DateSelectionModel oldModel = this.getSelectionModel();
        model.removeDateSelectionListener(this.getDateSelectionListener());
        this.model = model;
        this.installCalendar();
        if (!model.getLocale().equals(this.getLocale())) {
            super.setLocale(model.getLocale());
        }
        model.addDateSelectionListener(this.getDateSelectionListener());
        this.firePropertyChange(SELECTION_MODEL, oldModel, this.getSelectionModel());
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public SortedSet<Date> getSelection() {
        return this.getSelectionModel().getSelection();
    }

    public void addSelectionInterval(Date startDate, Date endDate) {
        this.getSelectionModel().addSelectionInterval(startDate, endDate);
    }

    public void setSelectionInterval(Date startDate, Date endDate) {
        this.getSelectionModel().setSelectionInterval(startDate, endDate);
    }

    public void removeSelectionInterval(Date startDate, Date endDate) {
        this.getSelectionModel().removeSelectionInterval(startDate, endDate);
    }

    public DateSelectionModel.SelectionMode getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public Date getFirstSelectionDate() {
        return this.getSelectionModel().getFirstSelectionDate();
    }

    public Date getLastSelectionDate() {
        return this.getSelectionModel().getLastSelectionDate();
    }

    public Date getSelectionDate() {
        return this.getFirstSelectionDate();
    }

    public void setSelectionDate(Date newDate) {
        if (newDate == null) {
            this.clearSelection();
        } else {
            this.setSelectionInterval(newDate, newDate);
        }
    }

    public boolean isSelected(Date date) {
        return this.getSelectionModel().isSelected(date);
    }

    public void setLowerBound(Date lowerBound) {
        this.getSelectionModel().setLowerBound(lowerBound);
    }

    public void setUpperBound(Date upperBound) {
        this.getSelectionModel().setUpperBound(upperBound);
    }

    public Date getLowerBound() {
        return this.getSelectionModel().getLowerBound();
    }

    public Date getUpperBound() {
        return this.getSelectionModel().getUpperBound();
    }

    public boolean isUnselectableDate(Date date) {
        return this.getSelectionModel().isUnselectableDate(date);
    }

    public void setUnselectableDates(Date ... unselectableDates) {
        Contract.asNotNull(unselectableDates, "unselectable dates must not be null");
        TreeSet<Date> unselectableSet = new TreeSet<Date>();
        for (Date unselectableDate : unselectableDates) {
            unselectableSet.add(unselectableDate);
        }
        this.getSelectionModel().setUnselectableDates(unselectableSet);
        this.repaint();
    }

    public boolean isFlaggedDate(Date date) {
        if (date == null) {
            return false;
        }
        return this.flaggedDates.isSelected(date);
    }

    public void setFlaggedDates(Date ... flagged) {
        SortedSet<Date> oldFlagged = this.getFlaggedDates();
        this.flaggedDates.clearSelection();
        if (flagged != null) {
            for (Date date : flagged) {
                this.flaggedDates.addSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, oldFlagged, this.getFlaggedDates());
    }

    public void addFlaggedDates(Date ... flagged) {
        SortedSet<Date> oldFlagged = this.flaggedDates.getSelection();
        if (flagged != null) {
            for (Date date : flagged) {
                this.flaggedDates.addSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, oldFlagged, this.flaggedDates.getSelection());
    }

    public void removeFlaggedDates(Date ... flagged) {
        SortedSet<Date> oldFlagged = this.flaggedDates.getSelection();
        if (flagged != null) {
            for (Date date : flagged) {
                this.flaggedDates.removeSelectionInterval(date, date);
            }
        }
        this.firePropertyChange(FLAGGED_DATES, oldFlagged, this.flaggedDates.getSelection());
    }

    public void clearFlaggedDates() {
        SortedSet<Date> oldFlagged = this.flaggedDates.getSelection();
        this.flaggedDates.clearSelection();
        this.firePropertyChange(FLAGGED_DATES, oldFlagged, this.flaggedDates.getSelection());
    }

    public SortedSet<Date> getFlaggedDates() {
        return this.flaggedDates.getSelection();
    }

    public boolean hasFlaggedDates() {
        return !this.flaggedDates.isSelectionEmpty();
    }

    public void setShowingLeadingDays(boolean value) {
        boolean old = this.isShowingLeadingDays();
        this.leadingDays = value;
        this.firePropertyChange("showingLeadingDays", old, this.isShowingLeadingDays());
    }

    public boolean isShowingLeadingDays() {
        return this.leadingDays;
    }

    public void setShowingTrailingDays(boolean value) {
        boolean old = this.isShowingTrailingDays();
        this.trailingDays = value;
        this.firePropertyChange("showingTrailingDays", old, this.isShowingTrailingDays());
    }

    public boolean isShowingTrailingDays() {
        return this.trailingDays;
    }

    public boolean isTraversable() {
        if (this.isZoomable()) {
            return true;
        }
        return this.traversable;
    }

    public void setTraversable(boolean traversable) {
        boolean old = this.isTraversable();
        this.traversable = traversable;
        this.firePropertyChange(TRAVERSABLE, old, this.isTraversable());
    }

    public boolean isZoomable() {
        return this.zoomable;
    }

    public void setZoomable(boolean zoomable) {
        boolean old = this.isZoomable();
        this.zoomable = zoomable;
        this.firePropertyChange("zoomable", old, this.isZoomable());
    }

    public boolean isShowingWeekNumber() {
        return this.showWeekNumber;
    }

    public void setShowingWeekNumber(boolean showWeekNumber) {
        boolean old = this.isShowingWeekNumber();
        this.showWeekNumber = showWeekNumber;
        this.firePropertyChange("showingWeekNumber", old, this.isShowingWeekNumber());
    }

    public void setDaysOfTheWeek(String[] days) {
        if (days != null && days.length != 7) {
            throw new IllegalArgumentException("Array of days is not of length 7 as expected.");
        }
        String[] oldValue = this.getDaysOfTheWeek();
        this._daysOfTheWeek = days;
        this.firePropertyChange(DAYS_OF_THE_WEEK, oldValue, days);
    }

    public String[] getDaysOfTheWeek() {
        if (this._daysOfTheWeek != null) {
            String[] days = new String[7];
            System.arraycopy(this._daysOfTheWeek, 0, days, 0, 7);
            return days;
        }
        return this.getUI().getDaysOfTheWeek();
    }

    public String getDayOfTheWeek(int dayOfWeek) {
        return this.getDaysOfTheWeek()[dayOfWeek - 1];
    }

    public int getBoxPaddingX() {
        return this.boxPaddingX;
    }

    public void setBoxPaddingX(int boxPaddingX) {
        int oldBoxPadding = this.getBoxPaddingX();
        this.boxPaddingX = boxPaddingX;
        this.firePropertyChange(BOX_PADDING_X, oldBoxPadding, this.getBoxPaddingX());
    }

    public int getBoxPaddingY() {
        return this.boxPaddingY;
    }

    public void setBoxPaddingY(int boxPaddingY) {
        int oldBoxPadding = this.getBoxPaddingY();
        this.boxPaddingY = boxPaddingY;
        this.firePropertyChange(BOX_PADDING_Y, oldBoxPadding, this.getBoxPaddingY());
    }

    public Color getSelectionBackground() {
        return this.selectedBackground;
    }

    public void setSelectionBackground(Color c2) {
        Color old = this.getSelectionBackground();
        this.selectedBackground = c2;
        this.firePropertyChange("selectionBackground", old, this.getSelectionBackground());
    }

    public Color getSelectionForeground() {
        return this.selectedForeground;
    }

    public void setSelectionForeground(Color c2) {
        Color old = this.getSelectionForeground();
        this.selectedForeground = c2;
        this.firePropertyChange("selectionForeground", old, this.getSelectionForeground());
    }

    public Color getTodayBackground() {
        return this.todayBackgroundColor;
    }

    public void setTodayBackground(Color c2) {
        Color oldValue = this.getTodayBackground();
        this.todayBackgroundColor = c2;
        this.firePropertyChange("todayBackground", oldValue, this.getTodayBackground());
        this.repaint();
    }

    public Color getMonthStringBackground() {
        return this.monthStringBackground;
    }

    public void setMonthStringBackground(Color c2) {
        Color old = this.getMonthStringBackground();
        this.monthStringBackground = c2;
        this.firePropertyChange("monthStringBackground", old, this.getMonthStringBackground());
        this.repaint();
    }

    public Color getMonthStringForeground() {
        return this.monthStringForeground;
    }

    public void setMonthStringForeground(Color c2) {
        Color old = this.getMonthStringForeground();
        this.monthStringForeground = c2;
        this.firePropertyChange("monthStringForeground", old, this.getMonthStringForeground());
        this.repaint();
    }

    public void setDaysOfTheWeekForeground(Color c2) {
        Color old = this.getDaysOfTheWeekForeground();
        this.daysOfTheWeekForeground = c2;
        this.firePropertyChange("daysOfTheWeekForeground", old, this.getDaysOfTheWeekForeground());
    }

    public Color getDaysOfTheWeekForeground() {
        return this.daysOfTheWeekForeground;
    }

    public void setDayForeground(int dayOfWeek, Color c2) {
        if (dayOfWeek < 1 || dayOfWeek > 7) {
            throw new IllegalArgumentException("dayOfWeek must be in [Calendar.SUNDAY ... Calendar.SATURDAY] but was " + dayOfWeek);
        }
        this.dayToColorTable.put(dayOfWeek, c2);
        this.repaint();
    }

    public Color getDayForeground(int dayOfWeek) {
        Color c2 = this.dayToColorTable.get(dayOfWeek);
        if (c2 == null) {
            c2 = this.getForeground();
        }
        return c2;
    }

    public Color getPerDayOfWeekForeground(int dayOfWeek) {
        return this.dayToColorTable.get(dayOfWeek);
    }

    public void setFlaggedDayForeground(Color c2) {
        Color old = this.getFlaggedDayForeground();
        this.flaggedDayForeground = c2;
        this.firePropertyChange("flaggedDayForeground", old, this.getFlaggedDayForeground());
    }

    public Color getFlaggedDayForeground() {
        return this.flaggedDayForeground;
    }

    public Insets getMonthStringInsets() {
        return (Insets)this._monthStringInsets.clone();
    }

    public void setMonthStringInsets(Insets insets) {
        Insets old = this.getMonthStringInsets();
        if (insets == null) {
            this._monthStringInsets.top = 0;
            this._monthStringInsets.left = 0;
            this._monthStringInsets.bottom = 0;
            this._monthStringInsets.right = 0;
        } else {
            this._monthStringInsets.top = insets.top;
            this._monthStringInsets.left = insets.left;
            this._monthStringInsets.bottom = insets.bottom;
            this._monthStringInsets.right = insets.right;
        }
        this.firePropertyChange("monthStringInsets", old, this.getMonthStringInsets());
        this.repaint();
    }

    public int getPreferredColumnCount() {
        return this.minCalCols;
    }

    public void setPreferredColumnCount(int cols) {
        if (cols <= 0) {
            return;
        }
        int old = this.getPreferredColumnCount();
        this.minCalCols = cols;
        this.firePropertyChange("preferredColumnCount", old, this.getPreferredColumnCount());
        this.revalidate();
        this.repaint();
    }

    public int getPreferredRowCount() {
        return this.minCalRows;
    }

    public void setPreferredRowCount(int rows) {
        if (rows <= 0) {
            return;
        }
        int old = this.getPreferredRowCount();
        this.minCalRows = rows;
        this.firePropertyChange("preferredRowCount", old, this.getPreferredRowCount());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void removeNotify() {
        this.todayTimer.stop();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        int secondsTillTomorrow = 86400;
        if (this.todayTimer == null) {
            this.todayTimer = new Timer(secondsTillTomorrow * 1000, new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    JXMonthView.this.incrementToday();
                }
            });
        }
        this.cal.setTimeInMillis(System.currentTimeMillis());
        secondsTillTomorrow = secondsTillTomorrow - this.cal.get(11) * 3600 - this.cal.get(12) * 60 - this.cal.get(13);
        this.todayTimer.setInitialDelay(secondsTillTomorrow * 1000);
        this.todayTimer.start();
    }

    public void commitSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(COMMIT_KEY);
    }

    public void cancelSelection() {
        this.getSelectionModel().setAdjusting(false);
        this.fireActionPerformed(CANCEL_KEY);
    }

    public void setComponentInputMapEnabled(boolean enabled) {
        boolean old = this.isComponentInputMapEnabled();
        this.componentInputMapEnabled = enabled;
        this.firePropertyChange("componentInputMapEnabled", old, this.isComponentInputMapEnabled());
    }

    public boolean isComponentInputMapEnabled() {
        return this.componentInputMapEnabled;
    }

    public void addActionListener(ActionListener l2) {
        this.listenerMap.add(ActionListener.class, l2);
    }

    public void removeActionListener(ActionListener l2) {
        this.listenerMap.remove(ActionListener.class, l2);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result;
        List<EventListener> listeners = this.listenerMap.getListeners(listenerType);
        if (!listeners.isEmpty()) {
            result = (EventListener[])Array.newInstance(listenerType, listeners.size());
            result = listeners.toArray(result);
        } else {
            result = super.getListeners(listenerType);
        }
        return result;
    }

    protected void fireActionPerformed(String actionCommand) {
        ActionListener[] listeners = (ActionListener[])this.getListeners(ActionListener.class);
        ActionEvent e2 = null;
        for (ActionListener listener : listeners) {
            if (e2 == null) {
                e2 = new ActionEvent(this, 1001, actionCommand);
            }
            listener.actionPerformed(e2);
        }
    }

    @Deprecated
    protected void cleanupWeekSelectionDates(Date startDate, Date endDate) {
        int count = 1;
        this.cal.setTime(startDate);
        while (this.cal.getTimeInMillis() < endDate.getTime()) {
            this.cal.add(5, 1);
            ++count;
        }
        if (count > 7) {
            int daysTillEnd;
            this.cal.setTime(startDate);
            int dayOfWeek = this.cal.get(7);
            int firstDayOfWeek = this.getFirstDayOfWeek();
            int daysFromStart = dayOfWeek - firstDayOfWeek;
            if (daysFromStart < 0) {
                daysFromStart += 7;
            }
            this.cal.add(5, -daysFromStart);
            this.modifiedStartDate = this.cal.getTime();
            this.cal.setTime(endDate);
            dayOfWeek = this.cal.get(7);
            int lastDayOfWeek = firstDayOfWeek - 1;
            if (lastDayOfWeek == 0) {
                lastDayOfWeek = 7;
            }
            if ((daysTillEnd = lastDayOfWeek - dayOfWeek) < 0) {
                daysTillEnd += 7;
            }
            this.cal.add(5, daysTillEnd);
            this.modifiedEndDate = this.cal.getTime();
        }
    }

    static {
        LookAndFeelAddons.contribute(new MonthViewAddon());
    }
}

