/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Locale;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.ForwardingRepaintManager;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SwingXUtilities {
    private static String STYLESHEET = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: %s; font-size: %dpt;  }";

    private SwingXUtilities() {
    }

    public static void updateMnemonicBinding(JComponent c2, String pressed) {
        SwingXUtilities.updateMnemonicBinding(c2, pressed, null);
    }

    public static void updateMnemonicBinding(JComponent c2, String pressed, String released) {
        Class<?> clazz = c2.getClass();
        int m2 = -1;
        try {
            Method mtd = clazz.getMethod("getMnemonic", new Class[0]);
            m2 = (Integer)mtd.invoke((Object)c2, new Object[0]);
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("unable to access mnemonic", e3);
        }
        InputMap map = SwingUtilities.getUIInputMap(c2, 2);
        if (m2 != 0) {
            if (map == null) {
                map = new ComponentInputMapUIResource(c2);
                SwingUtilities.replaceUIInputMap(c2, 2, map);
            }
            map.clear();
            map.put(KeyStroke.getKeyStroke(m2, 8, false), pressed);
            map.put(KeyStroke.getKeyStroke(m2, 8, true), released);
            map.put(KeyStroke.getKeyStroke(m2, 0, true), released);
        } else if (map != null) {
            map.clear();
        }
    }

    private static Component[] getChildren(Component c2) {
        Component[] children = null;
        if (c2 instanceof MenuElement) {
            MenuElement[] elements = ((MenuElement)((Object)c2)).getSubElements();
            children = new Component[elements.length];
            for (int i2 = 0; i2 < elements.length; ++i2) {
                children[i2] = elements[i2].getComponent();
            }
        } else if (c2 instanceof Container) {
            children = ((Container)c2).getComponents();
        }
        return children;
    }

    public static void setComponentTreeEnabled(Component c2, boolean enabled) {
        c2.setEnabled(enabled);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeEnabled(children[i2], enabled);
            }
        }
    }

    public static void setComponentTreeLocale(Component c2, Locale locale) {
        c2.setLocale(locale);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeLocale(children[i2], locale);
            }
        }
    }

    public static void setComponentTreeBackground(Component c2, Color color) {
        c2.setBackground(color);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeBackground(children[i2], color);
            }
        }
    }

    public static void setComponentTreeForeground(Component c2, Color color) {
        c2.setForeground(color);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeForeground(children[i2], color);
            }
        }
    }

    public static void setComponentTreeFont(Component c2, Font font) {
        c2.setFont(font);
        Component[] children = SwingXUtilities.getChildren(c2);
        if (children != null) {
            for (int i2 = 0; i2 < children.length; ++i2) {
                SwingXUtilities.setComponentTreeFont(children[i2], font);
            }
        }
    }

    public static void setHtmlFont(HTMLDocument doc, Font font) {
        String stylesheet = String.format(STYLESHEET, font.getName(), font.getSize(), font.getName(), font.getSize());
        try {
            doc.getStyleSheet().loadRules(new StringReader(stylesheet), null);
        }
        catch (IOException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static void updateAllComponentTreeUIs() {
        for (Frame frame : Frame.getFrames()) {
            SwingXUtilities.updateAllComponentTreeUIs(frame);
        }
    }

    public static void updateAllComponentTreeUIs(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        for (Window owned : window.getOwnedWindows()) {
            SwingXUtilities.updateAllComponentTreeUIs(owned);
        }
    }

    public static <T> T getAncestor(Class<T> clazz, Component c2) {
        if (clazz == null || c2 == null) {
            return null;
        }
        Container parent = c2.getParent();
        while (parent != null && !clazz.isInstance(parent)) {
            parent = c2 instanceof JPopupMenu ? ((JPopupMenu)c2).getInvoker() : c2.getParent();
        }
        return (T)parent;
    }

    public static boolean isDescendingFrom(Component focusOwner, Component parent) {
        while (focusOwner != null) {
            if (focusOwner instanceof JPopupMenu && (focusOwner = ((JPopupMenu)focusOwner).getInvoker()) == null) {
                return false;
            }
            if (focusOwner == parent) {
                return true;
            }
            focusOwner = focusOwner.getParent();
        }
        return false;
    }

    static RepaintManager getTranslucentRepaintManager(RepaintManager delegate) {
        RepaintManager manager = delegate;
        while (manager != null && !manager.getClass().isAnnotationPresent(TranslucentRepaintManager.class)) {
            if (manager instanceof ForwardingRepaintManager) {
                manager = ((ForwardingRepaintManager)manager).getDelegateManager();
                continue;
            }
            manager = null;
        }
        return manager == null ? new RepaintManagerX(delegate) : delegate;
    }

    public static boolean isUIInstallable(Object property) {
        return property == null || property instanceof UIResource;
    }
}

