/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.util.Comparator;
import org.jdesktop.swingx.decorator.Sorter;

public class ShuttleSorter
extends Sorter {
    private int[] toPrevious;

    public ShuttleSorter() {
        this(0, true);
    }

    public ShuttleSorter(int col, boolean ascending) {
        super(col, ascending);
    }

    public ShuttleSorter(int col, boolean ascending, Comparator comparator) {
        super(col, ascending, comparator);
    }

    protected void init() {
        this.toPrevious = new int[0];
    }

    protected void reset() {
        int inputSize = this.getInputSize();
        this.toPrevious = new int[inputSize];
        this.fromPrevious = new int[inputSize];
        for (int i2 = 0; i2 < inputSize; ++i2) {
            this.toPrevious[i2] = i2;
        }
    }

    protected void filter() {
        if (this.canFilter()) {
            this.sort((int[])this.toPrevious.clone(), this.toPrevious, 0, this.toPrevious.length);
        }
        for (int i2 = 0; i2 < this.toPrevious.length; ++i2) {
            this.fromPrevious[this.toPrevious[i2]] = i2;
        }
    }

    protected boolean canFilter() {
        return this.adapter != null && this.getColumnIndex() < this.adapter.getColumnCount();
    }

    public int getSize() {
        return this.toPrevious.length;
    }

    protected int mapTowardModel(int row) {
        return this.toPrevious[row];
    }

    protected void sort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = low + high >> 1;
        this.sort(to, from, low, middle);
        this.sort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i2 = low; i2 < high; ++i2) {
                to[i2] = from[i2];
            }
            return;
        }
        for (int i3 = low; i3 < high; ++i3) {
            to[i3] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }
}

