/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.linux.LinuxLookAndFeelAddons;
import org.jdesktop.swingx.plaf.macosx.MacOSXLookAndFeelAddons;
import org.jdesktop.swingx.plaf.metal.MetalLookAndFeelAddons;
import org.jdesktop.swingx.plaf.motif.MotifLookAndFeelAddons;
import org.jdesktop.swingx.plaf.nimbus.NimbusLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsClassicLookAndFeelAddons;
import org.jdesktop.swingx.plaf.windows.WindowsLookAndFeelAddons;
import org.jdesktop.swingx.util.OS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookAndFeelAddons {
    private static List<ComponentAddon> contributedComponents = new ArrayList<ComponentAddon>();
    private static final Object APPCONTEXT_INITIALIZED = new Object();
    private static boolean trackingChanges = false;
    private static PropertyChangeListener changeListener;
    private static LookAndFeelAddons currentAddon;

    public void initialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.initialize(this);
        }
    }

    public void uninitialize() {
        for (ComponentAddon addon : contributedComponents) {
            addon.uninitialize(this);
        }
    }

    public void loadDefaults(Object[] keysAndValues) {
        for (int i2 = keysAndValues.length - 2; i2 >= 0; i2 -= 2) {
            if (UIManager.getLookAndFeelDefaults().get(keysAndValues[i2]) != null) continue;
            UIManager.getLookAndFeelDefaults().put(keysAndValues[i2], keysAndValues[i2 + 1]);
        }
    }

    public void unloadDefaults(Object[] keysAndValues) {
    }

    public static void setAddon(String addonClassName) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        LookAndFeelAddons.setAddon(Class.forName(addonClassName));
    }

    public static void setAddon(Class<?> addonClass) throws InstantiationException, IllegalAccessException {
        LookAndFeelAddons addon = (LookAndFeelAddons)addonClass.newInstance();
        LookAndFeelAddons.setAddon(addon);
    }

    public static void setAddon(LookAndFeelAddons addon) {
        if (currentAddon != null) {
            currentAddon.uninitialize();
        }
        addon.initialize();
        currentAddon = addon;
        UIManager.put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
        UIManager.getLookAndFeelDefaults().put(APPCONTEXT_INITIALIZED, Boolean.TRUE);
    }

    public static LookAndFeelAddons getAddon() {
        return currentAddon;
    }

    public static String getBestMatchAddonClassName() {
        String lnf = UIManager.getLookAndFeel().getClass().getName();
        String addon = UIManager.getCrossPlatformLookAndFeelClassName().equals(lnf) ? MetalLookAndFeelAddons.class.getName() : (UIManager.getSystemLookAndFeelClassName().equals(lnf) ? LookAndFeelAddons.getSystemAddonClassName() : ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lnf) || "com.jgoodies.looks.windows.WindowsLookAndFeel".equals(lnf) ? (OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName()) : ("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel".equals(lnf) ? WindowsClassicLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel().getID().equals("Motif") ? MotifLookAndFeelAddons.class.getName() : (UIManager.getLookAndFeel().getID().equals("Nimbus") ? NimbusLookAndFeelAddons.class.getName() : LookAndFeelAddons.getSystemAddonClassName())))));
        return addon;
    }

    public static String getSystemAddonClassName() {
        String addon = WindowsClassicLookAndFeelAddons.class.getName();
        if (OS.isMacOSX()) {
            addon = MacOSXLookAndFeelAddons.class.getName();
        } else if (OS.isWindows()) {
            addon = OS.isUsingWindowsVisualStyles() ? WindowsLookAndFeelAddons.class.getName() : WindowsClassicLookAndFeelAddons.class.getName();
        } else if (OS.isLinux()) {
            addon = LinuxLookAndFeelAddons.class.getName();
        }
        return addon;
    }

    public static void contribute(ComponentAddon component) {
        contributedComponents.add(component);
        if (currentAddon != null) {
            component.initialize(currentAddon);
        }
    }

    public static void uncontribute(ComponentAddon component) {
        contributedComponents.remove(component);
        if (currentAddon != null) {
            component.uninitialize(currentAddon);
        }
    }

    public static ComponentUI getUI(JComponent component, Class<?> expectedUIClass) {
        Class<?> realUIClass;
        LookAndFeelAddons.maybeInitialize();
        String uiClassname = (String)UIManager.get(component.getUIClassID());
        if (uiClassname == null) {
            Logger logger = Logger.getLogger("LookAndFeelAddons");
            logger.warning("Failed to retrieve UI for " + component.getClass().getName() + " with UIClassID " + component.getUIClassID());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Existing UI defaults keys: " + new ArrayList(UIManager.getDefaults().keySet()));
            }
            uiClassname = "org.jdesktop.swingx.plaf.basic.Basic" + expectedUIClass.getSimpleName();
        }
        try {
            Class<?> uiClass = Class.forName(uiClassname);
            UIManager.put(uiClassname, uiClass);
        }
        catch (ClassNotFoundException e2) {
            // empty catch block
        }
        ComponentUI ui = UIManager.getUI(component);
        if (expectedUIClass.isInstance(ui)) {
            return ui;
        }
        String realUI = ui.getClass().getName();
        try {
            realUIClass = expectedUIClass.getClassLoader().loadClass(realUI);
        }
        catch (ClassNotFoundException e3) {
            throw new RuntimeException("Failed to load class " + realUI, e3);
        }
        Method createUIMethod = null;
        try {
            createUIMethod = realUIClass.getMethod("createUI", JComponent.class);
        }
        catch (NoSuchMethodException e1) {
            throw new RuntimeException("Class " + realUI + " has no method createUI(JComponent)");
        }
        try {
            return (ComponentUI)createUIMethod.invoke(null, component);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to invoke " + realUI + "#createUI(JComponent)");
        }
    }

    private static synchronized void maybeInitialize() {
        UIDefaults defaults;
        if (currentAddon != null && !(defaults = UIManager.getLookAndFeelDefaults()).getBoolean(APPCONTEXT_INITIALIZED)) {
            LookAndFeelAddons.setAddon(currentAddon);
        }
    }

    public static synchronized void setTrackingLookAndFeelChanges(boolean tracking) {
        if (trackingChanges != tracking) {
            if (tracking) {
                if (changeListener == null) {
                    changeListener = new UpdateAddon();
                }
                UIManager.addPropertyChangeListener(changeListener);
            } else {
                if (changeListener != null) {
                    UIManager.removePropertyChangeListener(changeListener);
                }
                changeListener = null;
            }
            trackingChanges = tracking;
        }
    }

    public static synchronized boolean isTrackingLookAndFeelChanges() {
        return trackingChanges;
    }

    public static void installBackgroundPainter(JComponent c2, String painter) {
        Class<?> clazz = c2.getClass();
        try {
            Method getter = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method setter = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter p = (Painter)getter.invoke((Object)c2, new Object[0]);
            if (p == null || p instanceof UIResource) {
                setter.invoke((Object)c2, UIManagerExt.getPainter(painter));
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("cannot set painter on " + c2.getClass());
        }
    }

    public static void uninstallBackgroundPainter(JComponent c2) {
        Class<?> clazz = c2.getClass();
        try {
            Method getter = clazz.getMethod("getBackgroundPainter", new Class[0]);
            Method setter = clazz.getMethod("setBackgroundPainter", Painter.class);
            Painter p = (Painter)getter.invoke((Object)c2, new Object[0]);
            if (p == null || p instanceof UIResource) {
                setter.invoke((Object)c2, new Object[]{null});
            }
        }
        catch (RuntimeException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new IllegalArgumentException("cannot set painter on " + c2.getClass());
        }
    }

    static {
        String addonClassname = LookAndFeelAddons.getBestMatchAddonClassName();
        try {
            addonClassname = System.getProperty("swing.addon", addonClassname);
        }
        catch (SecurityException e2) {
            // empty catch block
        }
        try {
            LookAndFeelAddons.setAddon(addonClassname);
        }
        catch (Exception e3) {
            throw new ExceptionInInitializerError(e3);
        }
        LookAndFeelAddons.setTrackingLookAndFeelChanges(true);
    }

    private static class UpdateAddon
    implements PropertyChangeListener {
        private UpdateAddon() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                LookAndFeelAddons.setAddon(LookAndFeelAddons.getBestMatchAddonClassName());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }
}

