/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.rollover;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public abstract class RolloverProducer
implements MouseListener,
MouseMotionListener {
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    protected Point rollover = new Point(-1, -1);

    public void mouseReleased(MouseEvent e2) {
        this.updateRollover(e2, CLICKED_KEY, true);
    }

    public void mouseEntered(MouseEvent e2) {
        this.updateRollover(e2, ROLLOVER_KEY, false);
    }

    public void mouseExited(MouseEvent e2) {
        ((JComponent)e2.getSource()).putClientProperty(ROLLOVER_KEY, null);
        ((JComponent)e2.getSource()).putClientProperty(CLICKED_KEY, null);
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
    }

    public void mouseDragged(MouseEvent e2) {
    }

    public void mouseMoved(MouseEvent e2) {
        this.updateRollover(e2, ROLLOVER_KEY, false);
    }

    protected void updateRollover(MouseEvent e2, String property, boolean fireAlways) {
        this.updateRolloverPoint((JComponent)e2.getComponent(), e2.getPoint());
        this.updateClientProperty((JComponent)e2.getSource(), property, fireAlways);
    }

    protected void updateClientProperty(JComponent component, String property, boolean fireAlways) {
        if (fireAlways) {
            component.putClientProperty(property, null);
            component.putClientProperty(property, new Point(this.rollover));
        } else {
            Point p = (Point)component.getClientProperty(property);
            if (p == null || this.rollover.x != p.x || this.rollover.y != p.y) {
                component.putClientProperty(property, new Point(this.rollover));
            }
        }
    }

    protected abstract void updateRolloverPoint(JComponent var1, Point var2);
}

