/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.function.Consumer;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.ApiResponse;
import org.openapitools.client.model.BuyLicenseRequest;
import org.openapitools.client.model.CertificateResponse;
import org.openapitools.client.model.CustomerResponse;
import org.openapitools.client.model.CustomerUpdateRequest;
import org.openapitools.client.model.CustomsInformationRequest;
import org.openapitools.client.model.GetStateInfoRequest;
import org.openapitools.client.model.GuidRequest;
import org.openapitools.client.model.NewCustomerRequest;
import org.openapitools.client.model.PollStatusDto;
import org.openapitools.client.model.PollStatusRequest;
import org.openapitools.client.model.StateResponse;
import org.openapitools.client.model.TransactionReportRequest;

public class CustomerControllerApi {
    private final HttpClient memberVarHttpClient;
    private final ObjectMapper memberVarObjectMapper;
    private final String memberVarBaseUri;
    private final Consumer<HttpRequest.Builder> memberVarInterceptor;
    private final Duration memberVarReadTimeout;
    private final Consumer<HttpResponse<InputStream>> memberVarResponseInterceptor;
    private final Consumer<HttpResponse<String>> memberVarAsyncResponseInterceptor;

    public CustomerControllerApi() {
        this(new ApiClient());
    }

    public CustomerControllerApi(ApiClient apiClient) {
        this.memberVarHttpClient = apiClient.getHttpClient();
        this.memberVarObjectMapper = apiClient.getObjectMapper();
        this.memberVarBaseUri = apiClient.getBaseUri();
        this.memberVarInterceptor = apiClient.getRequestInterceptor();
        this.memberVarReadTimeout = apiClient.getReadTimeout();
        this.memberVarResponseInterceptor = apiClient.getResponseInterceptor();
        this.memberVarAsyncResponseInterceptor = apiClient.getAsyncResponseInterceptor();
    }

    protected ApiException getApiException(String operationId, HttpResponse<InputStream> response) throws IOException {
        String body = response.body() == null ? null : new String(response.body().readAllBytes());
        String message = this.formatExceptionMessage(operationId, response.statusCode(), body);
        return new ApiException(response.statusCode(), message, response.headers(), body);
    }

    private String formatExceptionMessage(String operationId, int statusCode, String body) {
        if (body == null || body.isEmpty()) {
            body = "[no body]";
        }
        return operationId + " call failed with: " + statusCode + " - " + body;
    }

    public void buyLicenseEdecExport(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        this.buyLicenseEdecExportWithHttpInfo(buyLicenseRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> buyLicenseEdecExportWithHttpInfo(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.buyLicenseEdecExportRequestBuilder(buyLicenseRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("buyLicenseEdecExport", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ApiException(e2);
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ApiException(e3);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder buyLicenseEdecExportRequestBuilder(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        if (buyLicenseRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'buyLicenseRequest' when calling buyLicenseEdecExport");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/license-edec-export";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(buyLicenseRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void buyLicenseEvvExport(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        this.buyLicenseEvvExportWithHttpInfo(buyLicenseRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> buyLicenseEvvExportWithHttpInfo(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.buyLicenseEvvExportRequestBuilder(buyLicenseRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("buyLicenseEvvExport", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ApiException(e2);
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ApiException(e3);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder buyLicenseEvvExportRequestBuilder(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        if (buyLicenseRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'buyLicenseRequest' when calling buyLicenseEvvExport");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/license-evv-export";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(buyLicenseRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void buyLicenseImport(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        this.buyLicenseImportWithHttpInfo(buyLicenseRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> buyLicenseImportWithHttpInfo(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.buyLicenseImportRequestBuilder(buyLicenseRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("buyLicenseImport", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ApiException(e2);
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ApiException(e3);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder buyLicenseImportRequestBuilder(BuyLicenseRequest buyLicenseRequest) throws ApiException {
        if (buyLicenseRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'buyLicenseRequest' when calling buyLicenseImport");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/license-edec-import";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(buyLicenseRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CertificateResponse getCertificate(GuidRequest guidRequest) throws ApiException {
        ApiResponse<CertificateResponse> localVarResponse = this.getCertificateWithHttpInfo(guidRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<CertificateResponse> getCertificateWithHttpInfo(GuidRequest guidRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getCertificateRequestBuilder(guidRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getCertificate", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<CertificateResponse>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder getCertificateRequestBuilder(GuidRequest guidRequest) throws ApiException {
        if (guidRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'guidRequest' when calling getCertificate");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/get-certificate";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(guidRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public StateResponse getStateInfo(GetStateInfoRequest getStateInfoRequest) throws ApiException {
        ApiResponse<StateResponse> localVarResponse = this.getStateInfoWithHttpInfo(getStateInfoRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<StateResponse> getStateInfoWithHttpInfo(GetStateInfoRequest getStateInfoRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStateInfoRequestBuilder(getStateInfoRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStateInfo", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<StateResponse>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder getStateInfoRequestBuilder(GetStateInfoRequest getStateInfoRequest) throws ApiException {
        if (getStateInfoRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'getStateInfoRequest' when calling getStateInfo");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/get-state-info";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(getStateInfoRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public List<String> getStatusEmailList(GuidRequest guidRequest) throws ApiException {
        ApiResponse<List<String>> localVarResponse = this.getStatusEmailListWithHttpInfo(guidRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<List<String>> getStatusEmailListWithHttpInfo(GuidRequest guidRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.getStatusEmailListRequestBuilder(guidRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("getStatusEmailList", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<List<String>>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder getStatusEmailListRequestBuilder(GuidRequest guidRequest) throws ApiException {
        if (guidRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'guidRequest' when calling getStatusEmailList");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/get-status-email";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(guidRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public PollStatusDto pollStatusEmail(PollStatusRequest pollStatusRequest) throws ApiException {
        ApiResponse<PollStatusDto> localVarResponse = this.pollStatusEmailWithHttpInfo(pollStatusRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<PollStatusDto> pollStatusEmailWithHttpInfo(PollStatusRequest pollStatusRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.pollStatusEmailRequestBuilder(pollStatusRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("pollStatusEmail", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<PollStatusDto>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder pollStatusEmailRequestBuilder(PollStatusRequest pollStatusRequest) throws ApiException {
        if (pollStatusRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'pollStatusRequest' when calling pollStatusEmail");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/poll-status-email";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(pollStatusRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CustomerResponse registerNewCustomer(NewCustomerRequest newCustomerRequest) throws ApiException {
        ApiResponse<CustomerResponse> localVarResponse = this.registerNewCustomerWithHttpInfo(newCustomerRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomerResponse> registerNewCustomerWithHttpInfo(NewCustomerRequest newCustomerRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.registerNewCustomerRequestBuilder(newCustomerRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("registerNewCustomer", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<CustomerResponse>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder registerNewCustomerRequestBuilder(NewCustomerRequest newCustomerRequest) throws ApiException {
        if (newCustomerRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'newCustomerRequest' when calling registerNewCustomer");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/register";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(newCustomerRequest);
            localVarRequestBuilder.method("POST", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void reportTransactionExport(TransactionReportRequest transactionReportRequest) throws ApiException {
        this.reportTransactionExportWithHttpInfo(transactionReportRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> reportTransactionExportWithHttpInfo(TransactionReportRequest transactionReportRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.reportTransactionExportRequestBuilder(transactionReportRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("reportTransactionExport", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ApiException(e2);
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ApiException(e3);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder reportTransactionExportRequestBuilder(TransactionReportRequest transactionReportRequest) throws ApiException {
        if (transactionReportRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'transactionReportRequest' when calling reportTransactionExport");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/report-transaction";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(transactionReportRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public void setCustomsInformation(CustomsInformationRequest customsInformationRequest) throws ApiException {
        this.setCustomsInformationWithHttpInfo(customsInformationRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResponse<Void> setCustomsInformationWithHttpInfo(CustomsInformationRequest customsInformationRequest) throws ApiException {
        ApiResponse<Object> apiResponse;
        HttpRequest.Builder localVarRequestBuilder = this.setCustomsInformationRequestBuilder(customsInformationRequest);
        HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        if (this.memberVarResponseInterceptor != null) {
            this.memberVarResponseInterceptor.accept(localVarResponse);
        }
        try {
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("setCustomsInformation", localVarResponse);
            }
            apiResponse = new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), null);
        }
        catch (Throwable throwable) {
            try {
                while (localVarResponse.body().read() != -1) {
                }
                localVarResponse.body().close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new ApiException(e2);
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new ApiException(e3);
            }
        }
        while (localVarResponse.body().read() != -1) {
        }
        localVarResponse.body().close();
        return apiResponse;
    }

    private HttpRequest.Builder setCustomsInformationRequestBuilder(CustomsInformationRequest customsInformationRequest) throws ApiException {
        if (customsInformationRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'customsInformationRequest' when calling setCustomsInformation");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/set-customs-information";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(customsInformationRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }

    public CustomerResponse updateCustomer(CustomerUpdateRequest customerUpdateRequest) throws ApiException {
        ApiResponse<CustomerResponse> localVarResponse = this.updateCustomerWithHttpInfo(customerUpdateRequest);
        return localVarResponse.getData();
    }

    public ApiResponse<CustomerResponse> updateCustomerWithHttpInfo(CustomerUpdateRequest customerUpdateRequest) throws ApiException {
        HttpRequest.Builder localVarRequestBuilder = this.updateCustomerRequestBuilder(customerUpdateRequest);
        try {
            HttpResponse<InputStream> localVarResponse = this.memberVarHttpClient.send(localVarRequestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            if (this.memberVarResponseInterceptor != null) {
                this.memberVarResponseInterceptor.accept(localVarResponse);
            }
            if (localVarResponse.statusCode() / 100 != 2) {
                throw this.getApiException("updateCustomer", localVarResponse);
            }
            return new ApiResponse<Object>(localVarResponse.statusCode(), localVarResponse.headers().map(), (localVarResponse.body() == null ? null : this.memberVarObjectMapper.readValue(localVarResponse.body(), new TypeReference<CustomerResponse>(){})));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        catch (InterruptedException e3) {
            Thread.currentThread().interrupt();
            throw new ApiException(e3);
        }
    }

    private HttpRequest.Builder updateCustomerRequestBuilder(CustomerUpdateRequest customerUpdateRequest) throws ApiException {
        if (customerUpdateRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'customerUpdateRequest' when calling updateCustomer");
        }
        HttpRequest.Builder localVarRequestBuilder = HttpRequest.newBuilder();
        String localVarPath = "/rest/client/customer/update";
        localVarRequestBuilder.uri(URI.create(this.memberVarBaseUri + localVarPath));
        localVarRequestBuilder.header("Content-Type", "application/json");
        localVarRequestBuilder.header("Accept", "*/*");
        try {
            byte[] localVarPostBody = this.memberVarObjectMapper.writeValueAsBytes(customerUpdateRequest);
            localVarRequestBuilder.method("PUT", HttpRequest.BodyPublishers.ofByteArray(localVarPostBody));
        }
        catch (IOException e2) {
            throw new ApiException(e2);
        }
        if (this.memberVarReadTimeout != null) {
            localVarRequestBuilder.timeout(this.memberVarReadTimeout);
        }
        if (this.memberVarInterceptor != null) {
            this.memberVarInterceptor.accept(localVarRequestBuilder);
        }
        return localVarRequestBuilder;
    }
}

