/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.model.AddressDto;
import org.openapitools.client.model.BillingDto;
import org.openapitools.client.model.ContactDto;

@JsonPropertyOrder(value={"language", "address", "contact", "billingData", "rootFolder", "userName"})
public class NewCustomerRequest {
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private LanguageEnum language;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private AddressDto address;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private ContactDto contact;
    public static final String JSON_PROPERTY_BILLING_DATA = "billingData";
    private BillingDto billingData;
    public static final String JSON_PROPERTY_ROOT_FOLDER = "rootFolder";
    private String rootFolder;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    public NewCustomerRequest language(LanguageEnum language) {
        this.language = language;
        return this;
    }

    @Nullable
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LanguageEnum getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(LanguageEnum language) {
        this.language = language;
    }

    public NewCustomerRequest address(AddressDto address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AddressDto getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(AddressDto address) {
        this.address = address;
    }

    public NewCustomerRequest contact(ContactDto contact) {
        this.contact = contact;
        return this;
    }

    @Nonnull
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ContactDto getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContact(ContactDto contact) {
        this.contact = contact;
    }

    public NewCustomerRequest billingData(BillingDto billingData) {
        this.billingData = billingData;
        return this;
    }

    @Nullable
    @JsonProperty(value="billingData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BillingDto getBillingData() {
        return this.billingData;
    }

    @JsonProperty(value="billingData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBillingData(BillingDto billingData) {
        this.billingData = billingData;
    }

    public NewCustomerRequest rootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    @Nonnull
    @JsonProperty(value="rootFolder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRootFolder() {
        return this.rootFolder;
    }

    @JsonProperty(value="rootFolder")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public NewCustomerRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewCustomerRequest newCustomerRequest = (NewCustomerRequest)o;
        return Objects.equals((Object)this.language, (Object)newCustomerRequest.language) && Objects.equals(this.address, newCustomerRequest.address) && Objects.equals(this.contact, newCustomerRequest.contact) && Objects.equals(this.billingData, newCustomerRequest.billingData) && Objects.equals(this.rootFolder, newCustomerRequest.rootFolder) && Objects.equals(this.userName, newCustomerRequest.userName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.address, this.contact, this.billingData, this.rootFolder, this.userName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewCustomerRequest {\n");
        sb.append("    language: ").append(this.toIndentedString((Object)this.language)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    billingData: ").append(this.toIndentedString(this.billingData)).append("\n");
        sb.append("    rootFolder: ").append(this.toIndentedString(this.rootFolder)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getLanguage() != null) {
            joiner.add(String.format("%slanguage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getLanguage()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAddress() != null) {
            joiner.add(this.getAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_ADDRESS + suffix));
        }
        if (this.getContact() != null) {
            joiner.add(this.getContact().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTACT + suffix));
        }
        if (this.getBillingData() != null) {
            joiner.add(this.getBillingData().toUrlQueryString((String)prefix + JSON_PROPERTY_BILLING_DATA + suffix));
        }
        if (this.getRootFolder() != null) {
            joiner.add(String.format("%srootFolder%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRootFolder()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getUserName() != null) {
            joiner.add(String.format("%suserName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getUserName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum LanguageEnum {
        DE("de"),
        FR("fr");

        private String value;

        private LanguageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LanguageEnum fromValue(String value) {
            for (LanguageEnum b2 : LanguageEnum.values()) {
                if (!b2.value.equals(value)) continue;
                return b2;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

