/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.PageElementPosition;
import org.xhtmlrenderer.css.newmatch.PageInfo;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.EmptyStyle;
import org.xhtmlrenderer.layout.BlockFormattingContext;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.BoxRangeHelper;
import org.xhtmlrenderer.layout.BoxRangeLists;
import org.xhtmlrenderer.layout.CollapsedBorderSide;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.LayoutState;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.BoxDimensions;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.render.ViewportBox;

public class Layer {
    public static final short PAGED_MODE_SCREEN = 1;
    public static final short PAGED_MODE_PRINT = 2;
    private Layer _parent;
    private boolean _stackingContext;
    private List _children;
    private Box _master;
    private Box _end;
    private List _floats;
    private boolean _fixedBackground;
    private boolean _inline;
    private boolean _requiresLayout;
    private List _pages;
    private PageBox _lastRequestedPage = null;
    private Set _pageSequences;
    private List _sortedPageSequences;
    private Map _runningBlocks;
    private Box _selectionStart;
    private Box _selectionEnd;
    private int _selectionStartX;
    private int _selectionStartY;
    private int _selectionEndX;
    private int _selectionEndY;
    private static final int POSITIVE = 1;
    private static final int ZERO = 2;
    private static final int NEGATIVE = 3;
    private static final int AUTO = 4;

    public Layer(Box master) {
        this(null, master);
        this.setStackingContext(true);
    }

    public Layer(Layer parent, Box master) {
        this._parent = parent;
        this._master = master;
        this.setStackingContext(master.getStyle().isPositioned() && !master.getStyle().isAutoZIndex());
        master.setLayer(this);
        master.setContainingLayer(this);
    }

    public Layer getParent() {
        return this._parent;
    }

    public boolean isStackingContext() {
        return this._stackingContext;
    }

    public void setStackingContext(boolean stackingContext) {
        this._stackingContext = stackingContext;
    }

    public int getZIndex() {
        return (int)this._master.getStyle().asFloat(CSSName.Z_INDEX);
    }

    public Box getMaster() {
        return this._master;
    }

    public synchronized void addChild(Layer layer) {
        if (this._children == null) {
            this._children = new ArrayList();
        }
        this._children.add(layer);
    }

    public void addFloat(BlockBox floater, BlockFormattingContext bfc) {
        if (this._floats == null) {
            this._floats = new ArrayList();
        }
        this._floats.add(floater);
        floater.getFloatedBoxData().setDrawingLayer(this);
    }

    public void removeFloat(BlockBox floater) {
        if (this._floats != null) {
            this._floats.remove(floater);
        }
    }

    private void paintFloats(RenderingContext c2) {
        if (this._floats != null) {
            for (int i2 = this._floats.size() - 1; i2 >= 0; --i2) {
                BlockBox floater = (BlockBox)this._floats.get(i2);
                this.paintAsLayer(c2, floater);
            }
        }
    }

    private void paintLayers(RenderingContext c2, List layers) {
        for (int i2 = 0; i2 < layers.size(); ++i2) {
            Layer layer = (Layer)layers.get(i2);
            layer.paint(c2);
        }
    }

    private List collectLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        if (which != 4) {
            result.addAll(this.getStackingContextLayers(which));
        }
        List children = this.getChildren();
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Layer child = (Layer)children.get(i2);
            if (child.isStackingContext()) continue;
            if (which == 4) {
                result.add(child);
            }
            result.addAll(child.collectLayers(which));
        }
        return result;
    }

    private List getStackingContextLayers(int which) {
        ArrayList<Layer> result = new ArrayList<Layer>();
        List children = this.getChildren();
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Layer target = (Layer)children.get(i2);
            if (!target.isStackingContext()) continue;
            int zIndex = target.getZIndex();
            if (which == 3 && zIndex < 0) {
                result.add(target);
                continue;
            }
            if (which == 1 && zIndex > 0) {
                result.add(target);
                continue;
            }
            if (which != 2 || zIndex != 0) continue;
            result.add(target);
        }
        return result;
    }

    private List getSortedLayers(int which) {
        List result = this.collectLayers(which);
        Collections.sort(result, new ZIndexComparator());
        return result;
    }

    private void paintBackgroundsAndBorders(RenderingContext c2, List blocks, Map collapsedTableBorders, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c2.getOutputDevice(), rangeLists.getBlock());
        for (int i2 = 0; i2 < blocks.size(); ++i2) {
            List borders;
            TableCellBox cell;
            helper.popClipRegions(c2, i2);
            BlockBox box = (BlockBox)blocks.get(i2);
            box.paintBackground(c2);
            box.paintBorder(c2);
            if (c2.debugDrawBoxes()) {
                box.paintDebugOutline(c2);
            }
            if (collapsedTableBorders != null && box instanceof TableCellBox && (cell = (TableCellBox)box).hasCollapsedPaintingBorder() && (borders = (List)collapsedTableBorders.get(cell)) != null) {
                this.paintCollapsedTableBorders(c2, borders);
            }
            helper.pushClipRegion(c2, i2);
        }
        helper.popClipRegions(c2, blocks.size());
    }

    private void paintInlineContent(RenderingContext c2, List lines, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c2.getOutputDevice(), rangeLists.getInline());
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            helper.popClipRegions(c2, i2);
            helper.pushClipRegion(c2, i2);
            InlinePaintable paintable = (InlinePaintable)lines.get(i2);
            paintable.paintInline(c2);
        }
        helper.popClipRegions(c2, lines.size());
    }

    private void paintSelection(RenderingContext c2, List lines) {
        if (c2.getOutputDevice().isSupportsSelection()) {
            Iterator i2 = lines.iterator();
            while (i2.hasNext()) {
                InlinePaintable paintable = (InlinePaintable)i2.next();
                if (!(paintable instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)paintable).paintSelection(c2);
            }
        }
    }

    public Dimension getPaintingDimension(LayoutContext c2) {
        return this.calcPaintingDimension(c2).getOuterMarginCorner();
    }

    public void paint(RenderingContext c2) {
        if (this.getMaster().getStyle().isFixed()) {
            this.positionFixedLayer(c2);
        }
        if (this.isRootLayer()) {
            this.getMaster().paintRootElementBackground(c2);
        }
        if (!this.isInline() && ((BlockBox)this.getMaster()).isReplaced()) {
            this.paintLayerBackgroundAndBorder(c2);
            this.paintReplacedElement(c2, (BlockBox)this.getMaster());
        } else {
            BoxRangeLists rangeLists = new BoxRangeLists();
            ArrayList blocks = new ArrayList();
            ArrayList lines = new ArrayList();
            BoxCollector collector = new BoxCollector();
            collector.collect(c2, c2.getOutputDevice().getClip(), this, blocks, lines, rangeLists);
            if (!this.isInline()) {
                this.paintLayerBackgroundAndBorder(c2);
                if (c2.debugDrawBoxes()) {
                    ((BlockBox)this.getMaster()).paintDebugOutline(c2);
                }
            }
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c2, this.getSortedLayers(3));
            }
            Map collapsedTableBorders = this.collectCollapsedTableBorders(c2, blocks);
            this.paintBackgroundsAndBorders(c2, blocks, collapsedTableBorders, rangeLists);
            this.paintFloats(c2);
            this.paintListMarkers(c2, blocks, rangeLists);
            this.paintInlineContent(c2, lines, rangeLists);
            this.paintReplacedElements(c2, blocks, rangeLists);
            this.paintSelection(c2, lines);
            if (this.isRootLayer() || this.isStackingContext()) {
                this.paintLayers(c2, this.collectLayers(4));
                this.paintLayers(c2, this.getSortedLayers(2));
                this.paintLayers(c2, this.getSortedLayers(1));
            }
        }
    }

    private List getFloats() {
        return this._floats == null ? Collections.EMPTY_LIST : this._floats;
    }

    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result = null;
        if (this.isRootLayer() || this.isStackingContext()) {
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(1), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.getSortedLayers(2), findAnonymous);
            if (result != null) {
                return result;
            }
            result = this.find(cssCtx, absX, absY, this.collectLayers(4), findAnonymous);
            if (result != null) {
                return result;
            }
        }
        for (int i2 = 0; i2 < this.getFloats().size(); ++i2) {
            Box floater = (Box)this.getFloats().get(i2);
            result = floater.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        result = this.getMaster().find(cssCtx, absX, absY, findAnonymous);
        if (result != null) {
            return result;
        }
        if ((this.isRootLayer() || this.isStackingContext()) && (result = this.find(cssCtx, absX, absY, this.getSortedLayers(3), findAnonymous)) != null) {
            return result;
        }
        return null;
    }

    private Box find(CssContext cssCtx, int absX, int absY, List layers, boolean findAnonymous) {
        Box result = null;
        for (int i2 = layers.size() - 1; i2 >= 0; --i2) {
            Layer l2 = (Layer)layers.get(i2);
            result = l2.find(cssCtx, absX, absY, findAnonymous);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    private Map collectCollapsedTableBorders(RenderingContext c2, List blocks) {
        ArrayList borders;
        TableCellBox cell;
        HashMap cellBordersByTable = new HashMap();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet all = new HashSet();
        Iterator i2 = blocks.iterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            if (!(b2 instanceof TableCellBox) || !(cell = (TableCellBox)b2).hasCollapsedPaintingBorder()) continue;
            borders = (ArrayList)cellBordersByTable.get(cell.getTable());
            if (borders == null) {
                borders = new ArrayList();
                cellBordersByTable.put(cell.getTable(), borders);
            }
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.size() == 0) {
            return null;
        }
        HashMap result = new HashMap();
        Iterator i3 = triggerCellsByTable.values().iterator();
        while (i3.hasNext()) {
            cell = (TableCellBox)i3.next();
            borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    private void paintCollapsedTableBorders(RenderingContext c2, List borders) {
        Iterator i2 = borders.iterator();
        while (i2.hasNext()) {
            CollapsedBorderSide border = (CollapsedBorderSide)i2.next();
            border.getCell().paintCollapsedBorder(c2, border.getSide());
        }
    }

    public void paintAsLayer(RenderingContext c2, BlockBox startingPoint) {
        BoxRangeLists rangeLists = new BoxRangeLists();
        ArrayList blocks = new ArrayList();
        ArrayList lines = new ArrayList();
        BoxCollector collector = new BoxCollector();
        collector.collect(c2, c2.getOutputDevice().getClip(), this, startingPoint, blocks, lines, rangeLists);
        Map collapsedTableBorders = this.collectCollapsedTableBorders(c2, blocks);
        this.paintBackgroundsAndBorders(c2, blocks, collapsedTableBorders, rangeLists);
        this.paintListMarkers(c2, blocks, rangeLists);
        this.paintInlineContent(c2, lines, rangeLists);
        this.paintSelection(c2, lines);
        this.paintReplacedElements(c2, blocks, rangeLists);
    }

    private void paintListMarkers(RenderingContext c2, List blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c2.getOutputDevice(), rangeLists.getBlock());
        for (int i2 = 0; i2 < blocks.size(); ++i2) {
            helper.popClipRegions(c2, i2);
            BlockBox box = (BlockBox)blocks.get(i2);
            box.paintListMarker(c2);
            helper.pushClipRegion(c2, i2);
        }
        helper.popClipRegions(c2, blocks.size());
    }

    private void paintReplacedElements(RenderingContext c2, List blocks, BoxRangeLists rangeLists) {
        BoxRangeHelper helper = new BoxRangeHelper(c2.getOutputDevice(), rangeLists.getBlock());
        for (int i2 = 0; i2 < blocks.size(); ++i2) {
            helper.popClipRegions(c2, i2);
            BlockBox box = (BlockBox)blocks.get(i2);
            if (box.isReplaced()) {
                this.paintReplacedElement(c2, box);
            }
            helper.pushClipRegion(c2, i2);
        }
        helper.popClipRegions(c2, blocks.size());
    }

    private void positionFixedLayer(RenderingContext c2) {
        Rectangle rect = c2.getFixedRectangle();
        Box fixed = this.getMaster();
        fixed.setX(0);
        fixed.setY(0);
        fixed.setAbsX(0);
        fixed.setAbsY(0);
        fixed.setContainingBlock(new ViewportBox(rect));
        ((BlockBox)fixed).positionAbsolute(c2, 3);
        fixed.calcPaintingInfo(c2, false);
    }

    private void paintLayerBackgroundAndBorder(RenderingContext c2) {
        if (this.getMaster() instanceof BlockBox) {
            BlockBox box = (BlockBox)this.getMaster();
            box.paintBackground(c2);
            box.paintBorder(c2);
        }
    }

    private void paintReplacedElement(RenderingContext c2, BlockBox replaced) {
        Rectangle contentBounds = replaced.getContentAreaEdge(replaced.getAbsX(), replaced.getAbsY(), c2);
        Point loc = replaced.getReplacedElement().getLocation();
        if (contentBounds.x != loc.x || contentBounds.y != loc.y) {
            replaced.getReplacedElement().setLocation(contentBounds.x, contentBounds.y);
        }
        if (!c2.isInteractive() || replaced.getReplacedElement().isRequiresInteractivePaint()) {
            c2.getOutputDevice().paintReplacedElement(c2, replaced);
        }
    }

    public boolean isRootLayer() {
        return this.getParent() == null && this.isStackingContext();
    }

    private void moveIfGreater(Dimension result, Dimension test) {
        if (test.width > result.width) {
            result.width = test.width;
        }
        if (test.height > result.height) {
            result.height = test.height;
        }
    }

    private PaintingInfo calcPaintingDimension(LayoutContext c2) {
        this.getMaster().calcPaintingInfo(c2, true);
        PaintingInfo result = this.getMaster().getPaintingInfo().copyOf();
        List children = this.getChildren();
        for (int i2 = 0; i2 < children.size(); ++i2) {
            Layer child = (Layer)children.get(i2);
            if (child.getMaster().getStyle().isFixed() || !child.getMaster().getStyle().isAbsolute()) continue;
            PaintingInfo info = child.calcPaintingDimension(c2);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
        }
        return result;
    }

    public void positionChildren(LayoutContext c2) {
        Iterator i2 = this.getChildren().iterator();
        while (i2.hasNext()) {
            Layer child = (Layer)i2.next();
            child.position(c2);
        }
    }

    private void position(LayoutContext c2) {
        if (this.getMaster().getStyle().isAbsolute() && !c2.isPrint()) {
            ((BlockBox)this.getMaster()).positionAbsolute(c2, 3);
        } else if (this.getMaster().getStyle().isRelative() && (this.isInline() || ((BlockBox)this.getMaster()).isInline())) {
            this.getMaster().positionRelative(c2);
            if (!this.isInline()) {
                this.getMaster().calcCanvasLocation();
                this.getMaster().calcChildLocations();
            }
        }
    }

    private boolean containsFixedLayer() {
        Iterator i2 = this.getChildren().iterator();
        while (i2.hasNext()) {
            Layer child = (Layer)i2.next();
            if (!child.getMaster().getStyle().isFixed() && !child.containsFixedLayer()) continue;
            return true;
        }
        return false;
    }

    public boolean containsFixedContent() {
        return this._fixedBackground || this.containsFixedLayer();
    }

    public void setFixedBackground(boolean b2) {
        this._fixedBackground = b2;
    }

    public synchronized List getChildren() {
        return this._children == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this._children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Layer layer) {
        boolean removed = false;
        Layer layer2 = this;
        synchronized (layer2) {
            if (this._children != null) {
                Iterator i2 = this._children.iterator();
                while (i2.hasNext()) {
                    Layer child = (Layer)i2.next();
                    if (child != layer) continue;
                    removed = true;
                    i2.remove();
                    break;
                }
            }
        }
        if (!removed) {
            throw new RuntimeException("Could not find layer to remove");
        }
    }

    public void detach() {
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    public boolean isInline() {
        return this._inline;
    }

    public void setInline(boolean inline) {
        this._inline = inline;
    }

    public Box getEnd() {
        return this._end;
    }

    public void setEnd(Box end) {
        this._end = end;
    }

    public boolean isRequiresLayout() {
        return this._requiresLayout;
    }

    public void setRequiresLayout(boolean requiresLayout) {
        this._requiresLayout = requiresLayout;
    }

    public void finish(LayoutContext c2) {
        if (c2.isPrint()) {
            this.layoutAbsoluteChildren(c2);
        }
        if (!this.isInline()) {
            this.positionChildren(c2);
        }
    }

    private void layoutAbsoluteChildren(LayoutContext c2) {
        List children = this.getChildren();
        if (children.size() > 0) {
            LayoutState state = c2.captureLayoutState();
            for (int i2 = 0; i2 < children.size(); ++i2) {
                Layer child = (Layer)children.get(i2);
                if (!child.isRequiresLayout()) continue;
                this.layoutAbsoluteChild(c2, child);
                if (child.getMaster().getStyle().isAvoidPageBreakInside() && child.getMaster().crossesPageBreak(c2)) {
                    child.getMaster().reset(c2);
                    ((BlockBox)child.getMaster()).setNeedPageClear(true);
                    this.layoutAbsoluteChild(c2, child);
                    if (child.getMaster().crossesPageBreak(c2)) {
                        child.getMaster().reset(c2);
                        this.layoutAbsoluteChild(c2, child);
                    }
                }
                child.setRequiresLayout(false);
                child.finish(c2);
                c2.getRootLayer().ensureHasPage(c2, child.getMaster());
            }
            c2.restoreLayoutState(state);
        }
    }

    private void layoutAbsoluteChild(LayoutContext c2, Layer child) {
        BlockBox master = (BlockBox)child.getMaster();
        if (child.getMaster().getStyle().isBottomAuto()) {
            master.positionAbsolute(c2, 3);
            master.positionAbsoluteOnPage(c2);
            c2.reInit(true);
            ((BlockBox)child.getMaster()).layout(c2);
            master.positionAbsolute(c2, 2);
        } else {
            c2.reInit(true);
            master.layout(c2);
            BoxDimensions before = master.getBoxDimensions();
            master.reset(c2);
            BoxDimensions after = master.getBoxDimensions();
            master.setBoxDimensions(before);
            master.positionAbsolute(c2, 3);
            master.positionAbsoluteOnPage(c2);
            master.setBoxDimensions(after);
            c2.reInit(true);
            ((BlockBox)child.getMaster()).layout(c2);
        }
    }

    public List getPages() {
        return this._pages == null ? Collections.EMPTY_LIST : this._pages;
    }

    public void setPages(List pages) {
        this._pages = pages;
    }

    public boolean isLastPage(PageBox pageBox) {
        return this._pages.get(this._pages.size() - 1) == pageBox;
    }

    public void addPage(CssContext c2) {
        List pages;
        String pseudoPage = null;
        if (this._pages == null) {
            this._pages = new ArrayList();
        }
        pseudoPage = (pages = this.getPages()).size() == 0 ? "first" : (pages.size() % 2 == 0 ? "left" : "right");
        PageBox pageBox = Layer.createPageBox(c2, pseudoPage);
        if (pages.size() == 0) {
            pageBox.setTopAndBottom(c2, 0);
        } else {
            PageBox previous = (PageBox)pages.get(pages.size() - 1);
            pageBox.setTopAndBottom(c2, previous.getBottom());
        }
        pageBox.setPageNo(pages.size());
        pages.add(pageBox);
    }

    public void removeLastPage() {
        PageBox pageBox = (PageBox)this._pages.remove(this._pages.size() - 1);
        if (pageBox == this.getLastRequestedPage()) {
            this.setLastRequestedPage(null);
        }
    }

    public static PageBox createPageBox(CssContext c2, String pseudoPage) {
        PageBox result = new PageBox();
        String pageName = null;
        if (c2 instanceof LayoutContext) {
            pageName = ((LayoutContext)c2).getPageName();
        }
        PageInfo pageInfo = c2.getCss().getPageStyle(pageName, pseudoPage);
        result.setPageInfo(pageInfo);
        CalculatedStyle cs = new EmptyStyle().deriveStyle(pageInfo.getPageStyle());
        result.setStyle(cs);
        result.setOuterPageWidth(result.getWidth(c2));
        return result;
    }

    public PageBox getFirstPage(CssContext c2, Box box) {
        return this.getPage(c2, box.getAbsY());
    }

    public PageBox getLastPage(CssContext c2, Box box) {
        return this.getPage(c2, box.getAbsY() + box.getHeight() - 1);
    }

    public void ensureHasPage(CssContext c2, Box box) {
        this.getLastPage(c2, box);
    }

    public PageBox getPage(CssContext c2, int yOffset) {
        List pages = this.getPages();
        if (yOffset < 0) {
            return null;
        }
        PageBox lastRequested = this.getLastRequestedPage();
        if (lastRequested != null && yOffset >= lastRequested.getTop() && yOffset < lastRequested.getBottom()) {
            return lastRequested;
        }
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        if (yOffset < last.getBottom()) {
            int count = pages.size();
            for (int i2 = count - 1; i2 >= 0 && i2 >= count - 5; --i2) {
                PageBox pageBox = (PageBox)pages.get(i2);
                if (yOffset < pageBox.getTop() || yOffset >= pageBox.getBottom()) continue;
                this.setLastRequestedPage(pageBox);
                return pageBox;
            }
            int low = 0;
            int high = count - 6;
            while (low <= high) {
                int mid = low + high >> 1;
                PageBox pageBox = (PageBox)pages.get(mid);
                if (yOffset >= pageBox.getTop() && yOffset < pageBox.getBottom()) {
                    this.setLastRequestedPage(pageBox);
                    return pageBox;
                }
                if (pageBox.getTop() < yOffset) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
        } else {
            this.addPagesUntilPosition(c2, yOffset);
            PageBox result = (PageBox)pages.get(pages.size() - 1);
            this.setLastRequestedPage(result);
            return result;
        }
        throw new RuntimeException("internal error");
    }

    private void addPagesUntilPosition(CssContext c2, int position) {
        List pages = this.getPages();
        PageBox last = (PageBox)pages.get(pages.size() - 1);
        while (position >= last.getBottom()) {
            this.addPage(c2);
            last = (PageBox)pages.get(pages.size() - 1);
        }
    }

    public void trimEmptyPages(CssContext c2, int maxYHeight) {
        PageBox page;
        List pages = this.getPages();
        for (int i2 = pages.size() - 1; i2 > 0 && (page = (PageBox)pages.get(i2)).getTop() >= maxYHeight; --i2) {
            if (page == this.getLastRequestedPage()) {
                this.setLastRequestedPage(null);
            }
            pages.remove(i2);
        }
    }

    public void trimPageCount(int newPageCount) {
        while (this._pages.size() > newPageCount) {
            PageBox pageBox = (PageBox)this._pages.remove(this._pages.size() - 1);
            if (pageBox != this.getLastRequestedPage()) continue;
            this.setLastRequestedPage(null);
        }
    }

    public void assignPagePaintingPositions(CssContext cssCtx, short mode) {
        this.assignPagePaintingPositions(cssCtx, mode, 0);
    }

    public void assignPagePaintingPositions(CssContext cssCtx, int mode, int additionalClearance) {
        List pages = this.getPages();
        int paintingTop = additionalClearance;
        Iterator i2 = pages.iterator();
        while (i2.hasNext()) {
            PageBox page = (PageBox)i2.next();
            page.setPaintingTop(paintingTop);
            if (mode == 1) {
                page.setPaintingBottom(paintingTop + page.getHeight(cssCtx));
            } else if (mode == 2) {
                page.setPaintingBottom(paintingTop + page.getContentHeight(cssCtx));
            } else {
                throw new IllegalArgumentException("Illegal mode");
            }
            paintingTop = page.getPaintingBottom() + additionalClearance;
        }
    }

    public int getMaxPageWidth(CssContext cssCtx, int additionalClearance) {
        List pages = this.getPages();
        int maxWidth = 0;
        Iterator i2 = pages.iterator();
        while (i2.hasNext()) {
            PageBox page = (PageBox)i2.next();
            int pageWidth = page.getWidth(cssCtx) + additionalClearance * 2;
            if (pageWidth <= maxWidth) continue;
            maxWidth = pageWidth;
        }
        return maxWidth;
    }

    public PageBox getLastPage() {
        List pages = this.getPages();
        return pages.size() == 0 ? null : (PageBox)pages.get(pages.size() - 1);
    }

    public boolean crossesPageBreak(LayoutContext c2, int top, int bottom) {
        if (top < 0) {
            return false;
        }
        PageBox page = this.getPage(c2, top);
        return bottom >= page.getBottom() - c2.getExtraSpaceBottom();
    }

    public Layer findRoot() {
        if (this.isRootLayer()) {
            return this;
        }
        return this.getParent().findRoot();
    }

    public void addRunningBlock(BlockBox block) {
        String identifier;
        ArrayList<BlockBox> blocks;
        if (this._runningBlocks == null) {
            this._runningBlocks = new HashMap();
        }
        if ((blocks = (ArrayList<BlockBox>)this._runningBlocks.get(identifier = block.getStyle().getRunningName())) == null) {
            blocks = new ArrayList<BlockBox>();
            this._runningBlocks.put(identifier, blocks);
        }
        blocks.add(block);
        Collections.sort(blocks, new Comparator(){

            public int compare(Object o1, Object o2) {
                BlockBox b1 = (BlockBox)o1;
                BlockBox b2 = (BlockBox)o2;
                return b1.getAbsY() - b2.getAbsY();
            }
        });
    }

    public void removeRunningBlock(BlockBox block) {
        if (this._runningBlocks == null) {
            return;
        }
        String identifier = block.getStyle().getRunningName();
        List blocks = (List)this._runningBlocks.get(identifier);
        if (blocks == null) {
            return;
        }
        blocks.remove(block);
    }

    public BlockBox getRunningBlock(String identifer, PageBox page, PageElementPosition which) {
        if (this._runningBlocks == null) {
            return null;
        }
        List blocks = (List)this._runningBlocks.get(identifer);
        if (blocks == null) {
            return null;
        }
        if (which == PageElementPosition.START) {
            BlockBox b2;
            BlockBox prev = null;
            Iterator i2 = blocks.iterator();
            while (i2.hasNext() && (b2 = (BlockBox)i2.next()).getStaticEquivalent().getAbsY() < page.getTop()) {
                prev = b2;
            }
            return prev;
        }
        if (which == PageElementPosition.FIRST) {
            Iterator i3 = blocks.iterator();
            while (i3.hasNext()) {
                BlockBox b3 = (BlockBox)i3.next();
                int absY = b3.getStaticEquivalent().getAbsY();
                if (absY < page.getTop() || absY >= page.getBottom()) continue;
                return b3;
            }
            return this.getRunningBlock(identifer, page, PageElementPosition.START);
        }
        if (which == PageElementPosition.LAST) {
            BlockBox b4;
            BlockBox prev = null;
            Iterator i4 = blocks.iterator();
            while (i4.hasNext() && (b4 = (BlockBox)i4.next()).getStaticEquivalent().getAbsY() <= page.getBottom()) {
                prev = b4;
            }
            return prev;
        }
        if (which == PageElementPosition.LAST_EXCEPT) {
            BlockBox prev = null;
            Iterator i5 = blocks.iterator();
            while (i5.hasNext()) {
                BlockBox b5 = (BlockBox)i5.next();
                int absY = b5.getStaticEquivalent().getAbsY();
                if (absY >= page.getTop() && absY < page.getBottom()) {
                    return null;
                }
                if (absY > page.getBottom()) break;
                prev = b5;
            }
            return prev;
        }
        throw new RuntimeException("bug: internal error");
    }

    public void layoutPages(LayoutContext c2) {
        c2.setRootDocumentLayer(c2.getRootLayer());
        Iterator i2 = this._pages.iterator();
        while (i2.hasNext()) {
            PageBox pageBox = (PageBox)i2.next();
            pageBox.layout(c2);
        }
    }

    public void addPageSequence(BlockBox start) {
        if (this._pageSequences == null) {
            this._pageSequences = new HashSet();
        }
        this._pageSequences.add(start);
    }

    private List getSortedPageSequences() {
        if (this._pageSequences == null) {
            return null;
        }
        if (this._sortedPageSequences == null) {
            ArrayList result = new ArrayList(this._pageSequences);
            Collections.sort(result, new Comparator(){

                public int compare(Object o1, Object o2) {
                    BlockBox b1 = (BlockBox)o1;
                    BlockBox b2 = (BlockBox)o2;
                    return b1.getAbsY() - b2.getAbsY();
                }
            });
            this._sortedPageSequences = result;
        }
        return this._sortedPageSequences;
    }

    public int getRelativePageNo(RenderingContext c2) {
        List sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c2.getInitialPageNo() > 0) {
            initial = c2.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c2.getPageNo();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c2, sequences, c2.getPage());
        if (sequenceStartIndex == -1) {
            return initial + c2.getPageNo();
        }
        BlockBox block = (BlockBox)sequences.get(sequenceStartIndex);
        return c2.getPageNo() - this.getFirstPage(c2, block).getPageNo();
    }

    public int getRelativePageCount(RenderingContext c2) {
        int lastPage;
        BlockBox block;
        int firstPage;
        List sequences = this.getSortedPageSequences();
        int initial = 0;
        if (c2.getInitialPageNo() > 0) {
            initial = c2.getInitialPageNo() - 1;
        }
        if (sequences == null) {
            return initial + c2.getPageCount();
        }
        int sequenceStartIndex = this.getPageSequenceStart(c2, sequences, c2.getPage());
        if (sequenceStartIndex == -1) {
            firstPage = 0;
        } else {
            block = (BlockBox)sequences.get(sequenceStartIndex);
            firstPage = this.getFirstPage(c2, block).getPageNo();
        }
        if (sequenceStartIndex < sequences.size() - 1) {
            block = (BlockBox)sequences.get(sequenceStartIndex + 1);
            lastPage = this.getFirstPage(c2, block).getPageNo();
        } else {
            lastPage = c2.getPageCount();
        }
        int sequenceLength = lastPage - firstPage;
        if (sequenceStartIndex == -1) {
            sequenceLength += initial;
        }
        return sequenceLength;
    }

    private int getPageSequenceStart(RenderingContext c2, List sequences, PageBox page) {
        for (int i2 = sequences.size() - 1; i2 >= 0; --i2) {
            BlockBox start = (BlockBox)sequences.get(i2);
            if (start.getAbsY() >= page.getBottom() - 1) continue;
            return i2;
        }
        return -1;
    }

    public Box getSelectionEnd() {
        return this._selectionEnd;
    }

    public void setSelectionEnd(Box selectionEnd) {
        this._selectionEnd = selectionEnd;
    }

    public Box getSelectionStart() {
        return this._selectionStart;
    }

    public void setSelectionStart(Box selectionStart) {
        this._selectionStart = selectionStart;
    }

    public int getSelectionEndX() {
        return this._selectionEndX;
    }

    public void setSelectionEndX(int selectionEndX) {
        this._selectionEndX = selectionEndX;
    }

    public int getSelectionEndY() {
        return this._selectionEndY;
    }

    public void setSelectionEndY(int selectionEndY) {
        this._selectionEndY = selectionEndY;
    }

    public int getSelectionStartX() {
        return this._selectionStartX;
    }

    public void setSelectionStartX(int selectionStartX) {
        this._selectionStartX = selectionStartX;
    }

    public int getSelectionStartY() {
        return this._selectionStartY;
    }

    public void setSelectionStartY(int selectionStartY) {
        this._selectionStartY = selectionStartY;
    }

    private PageBox getLastRequestedPage() {
        return this._lastRequestedPage;
    }

    private void setLastRequestedPage(PageBox lastRequestedPage) {
        this._lastRequestedPage = lastRequestedPage;
    }

    private static class ZIndexComparator
    implements Comparator {
        private ZIndexComparator() {
        }

        public int compare(Object o1, Object o2) {
            Layer l1 = (Layer)o1;
            Layer l2 = (Layer)o2;
            return l1.getZIndex() - l2.getZIndex();
        }
    }
}

