/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.layout;

import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.layout.FloatLayoutResult;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.LineBox;
import org.xhtmlrenderer.render.MarkerData;

public class LayoutUtil {
    public static void layoutAbsolute(LayoutContext c2, LineBox currentLine, BlockBox box) {
        MarkerData markerData = c2.getCurrentMarkerData();
        c2.setCurrentMarkerData(null);
        if (box.getStyle().isFixed()) {
            box.setContainingBlock(c2.getRootLayer().getMaster().getContainingBlock());
        } else {
            box.setContainingBlock(c2.getLayer().getMaster());
        }
        box.setStaticEquivalent(currentLine);
        if (!c2.isPrint()) {
            box.layout(c2);
        } else {
            c2.pushLayer(box);
            c2.getLayer().setRequiresLayout(true);
            c2.popLayer();
        }
        c2.setCurrentMarkerData(markerData);
    }

    public static FloatLayoutResult layoutFloated(LayoutContext c2, LineBox currentLine, BlockBox block, int avail, List pendingFloats) {
        FloatLayoutResult result = new FloatLayoutResult();
        MarkerData markerData = c2.getCurrentMarkerData();
        c2.setCurrentMarkerData(null);
        block.setContainingBlock(currentLine.getParent());
        block.setContainingLayer(currentLine.getContainingLayer());
        block.setStaticEquivalent(currentLine);
        if (pendingFloats != null) {
            block.setY(currentLine.getY() + block.getFloatedBoxData().getMarginFromSibling());
        } else {
            block.setY(currentLine.getY() + currentLine.getHeight());
        }
        block.calcInitialFloatedCanvasLocation(c2);
        int initialY = block.getY();
        block.layout(c2);
        c2.getBlockFormattingContext().floatBox(c2, block);
        if (pendingFloats != null && (pendingFloats.size() > 0 || block.getWidth() > avail) && currentLine.isContainsContent()) {
            block.reset(c2);
            result.setPending(true);
        } else if (c2.isPrint()) {
            LayoutUtil.positionFloatOnPage(c2, currentLine, block, initialY != block.getY());
            c2.getRootLayer().ensureHasPage(c2, block);
        }
        result.setBlock(block);
        c2.setCurrentMarkerData(markerData);
        return result;
    }

    private static void positionFloatOnPage(LayoutContext c2, LineBox currentLine, BlockBox block, boolean movedVertically) {
        boolean clearedPage = false;
        int clearDelta = 0;
        if (block.getStyle().isForcePageBreakBefore() || block.getStyle().isAvoidPageBreakInside() && block.crossesPageBreak(c2)) {
            clearDelta = block.forcePageBreakBefore(c2, block.getStyle().getIdent(CSSName.PAGE_BREAK_BEFORE), false);
            clearedPage = true;
            block.calcCanvasLocation();
            block.reset(c2);
            block.setContainingLayer(currentLine.getContainingLayer());
            block.layout(c2);
            c2.getBlockFormattingContext().floatBox(c2, block);
        }
        if ((movedVertically || block.getStyle().isAvoidPageBreakInside() && block.crossesPageBreak(c2)) && !block.getStyle().isForcePageBreakBefore()) {
            if (clearedPage) {
                block.setY(block.getY() - clearDelta);
                block.calcCanvasLocation();
            }
            block.reset(c2);
            block.setContainingLayer(currentLine.getContainingLayer());
            block.layout(c2);
            c2.getBlockFormattingContext().floatBox(c2, block);
        }
    }
}

