/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.newtable;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.css.style.derived.BorderPropertySet;
import org.xhtmlrenderer.css.style.derived.RectPropertySet;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.newtable.RowData;
import org.xhtmlrenderer.newtable.TableBox;
import org.xhtmlrenderer.newtable.TableCellBox;
import org.xhtmlrenderer.newtable.TableSectionBox;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.ContentLimitContainer;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;

public class TableRowBox
extends BlockBox {
    private int _baseline;
    private boolean _haveBaseline = false;
    private int _heightOverride;
    private ContentLimitContainer _contentLimitContainer;
    private int _extraSpaceTop;
    private int _extraSpaceBottom;

    public BlockBox copyOf() {
        TableRowBox result = new TableRowBox();
        result.setStyle(this.getStyle());
        result.setElement(this.getElement());
        return result;
    }

    public boolean isAutoHeight() {
        return this.getStyle().isAutoHeight() || !this.getStyle().hasAbsoluteUnit(CSSName.HEIGHT);
    }

    private TableBox getTable() {
        return (TableBox)this.getParent().getParent();
    }

    private TableSectionBox getSection() {
        return (TableSectionBox)this.getParent();
    }

    public void layout(LayoutContext c2, int contentStart) {
        boolean running = c2.isPrint() && this.getTable().getStyle().isPaginateTable();
        int prevExtraTop = 0;
        int prevExtraBottom = 0;
        if (running) {
            prevExtraTop = c2.getExtraSpaceTop();
            prevExtraBottom = c2.getExtraSpaceBottom();
            this.calcExtraSpaceTop(c2);
            this.calcExtraSpaceBottom(c2);
            c2.setExtraSpaceTop(c2.getExtraSpaceTop() + this.getExtraSpaceTop());
            c2.setExtraSpaceBottom(c2.getExtraSpaceBottom() + this.getExtraSpaceBottom());
        }
        super.layout(c2, contentStart);
        if (running) {
            if (this.isShouldMoveToNextPage(c2)) {
                if (this.getTable().getFirstBodyRow() == this) {
                    this.getTable().setNeedPageClear(true);
                } else {
                    this.setNeedPageClear(true);
                }
            }
            c2.setExtraSpaceTop(prevExtraTop);
            c2.setExtraSpaceBottom(prevExtraBottom);
        }
    }

    private boolean isShouldMoveToNextPage(LayoutContext c2) {
        PageBox page = c2.getRootLayer().getFirstPage(c2, this);
        if (this.getAbsY() + this.getHeight() < page.getBottom()) {
            return false;
        }
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            TableCellBox cell = (TableCellBox)i2.next();
            int baseline = cell.calcBlockBaseline(c2);
            if (baseline == Integer.MIN_VALUE || baseline >= page.getBottom()) continue;
            return false;
        }
        return true;
    }

    public void analyzePageBreaks(LayoutContext c2, ContentLimitContainer container) {
        if (this.getTable().getStyle().isPaginateTable()) {
            this._contentLimitContainer = new ContentLimitContainer(c2, this.getAbsY());
            this._contentLimitContainer.setParent(container);
            if (container != null) {
                container.updateTop(c2, this.getAbsY());
                container.updateBottom(c2, this.getAbsY() + this.getHeight());
            }
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                Box b2 = (Box)i2.next();
                b2.analyzePageBreaks(c2, this._contentLimitContainer);
            }
            if (container != null && this._contentLimitContainer.isContainsMultiplePages()) {
                this.propagateExtraSpace(c2, container, this._contentLimitContainer, this.getExtraSpaceTop(), this.getExtraSpaceBottom());
            }
        } else {
            super.analyzePageBreaks(c2, container);
        }
    }

    private void calcExtraSpaceTop(LayoutContext c2) {
        int maxBorderAndPadding = 0;
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            TableCellBox cell = (TableCellBox)i2.next();
            int borderAndPadding = (int)cell.getPadding(c2).top() + (int)cell.getBorder(c2).top();
            if (borderAndPadding <= maxBorderAndPadding) continue;
            maxBorderAndPadding = borderAndPadding;
        }
        this._extraSpaceTop = maxBorderAndPadding;
    }

    private void calcExtraSpaceBottom(LayoutContext c2) {
        int maxBorderAndPadding = 0;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List grid = this.getSection().getGrid();
        if (cRow < grid.size()) {
            List row = ((RowData)grid.get(cRow)).getRow();
            for (int cCol = 0; cCol < row.size(); ++cCol) {
                int borderAndPadding;
                TableCellBox cell = (TableCellBox)row.get(cCol);
                if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell || (borderAndPadding = (int)cell.getPadding(c2).bottom() + (int)cell.getBorder(c2).bottom()) <= maxBorderAndPadding) continue;
                maxBorderAndPadding = borderAndPadding;
            }
        }
        this._extraSpaceBottom = maxBorderAndPadding;
    }

    protected void layoutChildren(LayoutContext c2, int contentStart) {
        this.setState(2);
        this.ensureChildren(c2);
        TableSectionBox section = this.getSection();
        if (section.isNeedCellWidthCalc()) {
            section.setCellWidths(c2);
            section.setNeedCellWidthCalc(false);
        }
        if (this.getChildrenContentType() != 4) {
            int cCol = 0;
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                TableCellBox cell = (TableCellBox)i2.next();
                this.layoutCell(c2, cell, 0);
                ++cCol;
            }
        }
        this.setState(3);
    }

    private void alignBaselineAlignedCells(LayoutContext c2) {
        TableCellBox cell;
        int i2;
        int[] baselines = new int[this.getChildCount()];
        int lowest = Integer.MIN_VALUE;
        boolean found = false;
        for (i2 = 0; i2 < this.getChildCount(); ++i2) {
            int baseline;
            cell = (TableCellBox)this.getChild(i2);
            if (cell.getVerticalAlign() != IdentValue.BASELINE) continue;
            baselines[i2] = baseline = cell.calcBaseline(c2);
            if (baseline > lowest) {
                lowest = baseline;
            }
            found = true;
        }
        if (found) {
            for (i2 = 0; i2 < this.getChildCount(); ++i2) {
                int deltaY;
                cell = (TableCellBox)this.getChild(i2);
                if (cell.getVerticalAlign() != IdentValue.BASELINE || (deltaY = lowest - baselines[i2]) == 0) continue;
                if (c2.isPrint() && cell.isPageBreaksChange(c2, deltaY)) {
                    this.relayoutCell(c2, cell, deltaY);
                    continue;
                }
                cell.moveContent(c2, deltaY);
                cell.setHeight(cell.getHeight() + deltaY);
            }
            this.setBaseline(lowest - this.getAbsY());
            this.setHaveBaseline(true);
        }
    }

    private boolean alignMiddleAndBottomAlignedCells(LayoutContext c2) {
        boolean needRowHeightRecalc = false;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List grid = this.getSection().getGrid();
        if (cRow < grid.size()) {
            List row = ((RowData)grid.get(cRow)).getRow();
            for (int cCol = 0; cCol < row.size(); ++cCol) {
                int deltaY;
                IdentValue val;
                TableCellBox cell = (TableCellBox)row.get(cCol);
                if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell || (val = cell.getVerticalAlign()) != IdentValue.MIDDLE && val != IdentValue.BOTTOM || (deltaY = this.calcMiddleBottomDeltaY(cell, val)) <= 0) continue;
                if (c2.isPrint() && cell.isPageBreaksChange(c2, deltaY)) {
                    int oldCellHeight = cell.getHeight();
                    this.relayoutCell(c2, cell, deltaY);
                    if (oldCellHeight + deltaY == cell.getHeight()) continue;
                    needRowHeightRecalc = true;
                    continue;
                }
                cell.moveContent(c2, deltaY);
                cell.setHeight(cell.getHeight() + deltaY);
            }
        }
        return needRowHeightRecalc;
    }

    private int calcMiddleBottomDeltaY(TableCellBox cell, IdentValue verticalAlign) {
        int result = cell.getStyle().getRowSpan() == 1 ? this.getHeight() - cell.getChildrenHeight() : this.getAbsY() + this.getHeight() - (cell.getAbsY() + cell.getChildrenHeight());
        if (verticalAlign == IdentValue.MIDDLE) {
            return result / 2;
        }
        return result;
    }

    protected void calcLayoutHeight(LayoutContext c2, BorderPropertySet border, RectPropertySet margin, RectPropertySet padding) {
        if (this.getHeightOverride() > 0) {
            this.setHeight(this.getHeightOverride());
        }
        this.alignBaselineAlignedCells(c2);
        this.calcRowHeight(c2);
        boolean recalcRowHeight = this.alignMiddleAndBottomAlignedCells(c2);
        if (recalcRowHeight) {
            this.calcRowHeight(c2);
        }
        if (!this.isHaveBaseline()) {
            this.calcDefaultBaseline(c2);
        }
        this.setCellHeights(c2);
    }

    private void calcRowHeight(CssContext c2) {
        int bottom;
        int y1 = this.getAbsY();
        int y2 = this.getHeight() != 0 ? y1 + this.getHeight() : y1;
        if (this.isLastRow() && (bottom = this.getTable().calcFixedHeightRowBottom(c2)) > 0 && bottom > y2) {
            y2 = bottom;
        }
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List grid = this.getSection().getGrid();
        if (cRow < grid.size()) {
            List row = ((RowData)grid.get(cRow)).getRow();
            for (int cCol = 0; cCol < row.size(); ++cCol) {
                int bottomCellEdge;
                TableCellBox cell = (TableCellBox)row.get(cCol);
                if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell || (bottomCellEdge = cell.getAbsY() + cell.getHeight()) <= y2) continue;
                y2 = bottomCellEdge;
            }
        }
        this.setHeight(y2 - y1);
    }

    private boolean isLastRow() {
        TableSectionBox section;
        TableBox table = this.getTable();
        if (table.sectionBelow(section = this.getSection(), true) == null) {
            return section.getChild(section.getChildCount() - 1) == this;
        }
        return false;
    }

    private void calcDefaultBaseline(LayoutContext c2) {
        int lowestCellEdge = 0;
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List grid = this.getSection().getGrid();
        if (cRow < grid.size()) {
            List row = ((RowData)grid.get(cRow)).getRow();
            for (int cCol = 0; cCol < row.size(); ++cCol) {
                TableCellBox cell = (TableCellBox)row.get(cCol);
                if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell) continue;
                Rectangle contentArea = cell.getContentAreaEdge(cell.getAbsX(), cell.getAbsY(), c2);
                int bottomCellEdge = contentArea.y + contentArea.height;
                if (bottomCellEdge <= lowestCellEdge) continue;
                lowestCellEdge = bottomCellEdge;
            }
        }
        if (lowestCellEdge > 0) {
            this.setBaseline(lowestCellEdge - this.getAbsY());
        }
        this.setHaveBaseline(true);
    }

    private void setCellHeights(LayoutContext c2) {
        int cRow = this.getIndex();
        int totalRows = this.getSection().getChildCount();
        List grid = this.getSection().getGrid();
        if (cRow < grid.size()) {
            List row = ((RowData)grid.get(cRow)).getRow();
            for (int cCol = 0; cCol < row.size(); ++cCol) {
                TableCellBox cell = (TableCellBox)row.get(cCol);
                if (cell == null || cell == TableCellBox.SPANNING_CELL || cRow < totalRows - 1 && this.getSection().cellAt(cRow + 1, cCol) == cell) continue;
                if (cell.getStyle().getRowSpan() == 1) {
                    cell.setHeight(this.getHeight());
                    continue;
                }
                cell.setHeight(this.getAbsY() + this.getHeight() - cell.getAbsY());
            }
        }
    }

    private void relayoutCell(LayoutContext c2, TableCellBox cell, int contentStart) {
        int width = cell.getWidth();
        cell.reset(c2);
        cell.setLayoutWidth(c2, width);
        this.layoutCell(c2, cell, contentStart);
    }

    private void layoutCell(LayoutContext c2, TableCellBox cell, int contentStart) {
        cell.initContainingLayer(c2);
        cell.calcCanvasLocation();
        cell.layout(c2, contentStart);
    }

    public void initStaticPos(LayoutContext c2, BlockBox parent, int childOffset) {
        this.setX(0);
        TableBox table = this.getTable();
        this.setY(parent.getHeight() + table.getStyle().getBorderVSpacing(c2));
        c2.translate(0, this.getY() - childOffset);
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    protected boolean isSkipWhenCollapsingMargins() {
        return true;
    }

    public void paintBorder(RenderingContext c2) {
    }

    public void paintBackground(RenderingContext c2) {
    }

    public void reset(LayoutContext c2) {
        super.reset(c2);
        this.setHaveBaseline(false);
        this.getSection().setNeedCellWidthCalc(true);
        this.setContentLimitContainer(null);
    }

    public boolean isHaveBaseline() {
        return this._haveBaseline;
    }

    public void setHaveBaseline(boolean haveBaseline) {
        this._haveBaseline = haveBaseline;
    }

    protected String getExtraBoxDescription() {
        if (this.isHaveBaseline()) {
            return "(baseline=" + this.getBaseline() + ") ";
        }
        return "";
    }

    public int getHeightOverride() {
        return this._heightOverride;
    }

    public void setHeightOverride(int heightOverride) {
        this._heightOverride = heightOverride;
    }

    public void exportText(RenderingContext c2, Writer writer) throws IOException {
        if (this.getTable().isMarginAreaRoot()) {
            super.exportText(c2, writer);
        } else {
            int yPos = this.getAbsY();
            if (yPos >= c2.getPage().getBottom() && this.isInDocumentFlow()) {
                this.exportPageBoxText(c2, writer, yPos);
            }
            Iterator i2 = this.getChildIterator();
            while (i2.hasNext()) {
                TableCellBox cell = (TableCellBox)i2.next();
                StringBuffer buffer = new StringBuffer();
                cell.collectText(c2, buffer);
                writer.write(buffer.toString().trim());
                int cSpan = cell.getStyle().getColSpan();
                for (int j2 = 0; j2 < cSpan; ++j2) {
                    writer.write(9);
                }
            }
            writer.write(LINE_SEPARATOR);
        }
    }

    public ContentLimitContainer getContentLimitContainer() {
        return this._contentLimitContainer;
    }

    public void setContentLimitContainer(ContentLimitContainer contentLimitContainer) {
        this._contentLimitContainer = contentLimitContainer;
    }

    public int getExtraSpaceTop() {
        return this._extraSpaceTop;
    }

    public void setExtraSpaceTop(int extraSpaceTop) {
        this._extraSpaceTop = extraSpaceTop;
    }

    public int getExtraSpaceBottom() {
        return this._extraSpaceBottom;
    }

    public void setExtraSpaceBottom(int extraSpaceBottom) {
        this._extraSpaceBottom = extraSpaceBottom;
    }
}

