/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.extend.ContentFunction;
import org.xhtmlrenderer.css.parser.FSFunction;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.layout.TextUtil;

public class InlineBox
implements Styleable {
    private Element _element;
    private String _originalText;
    private String _text;
    private boolean _removableWhitespace;
    private boolean _startsHere;
    private boolean _endsHere;
    private CalculatedStyle _style;
    private ContentFunction _contentFunction;
    private FSFunction _function;
    private boolean _minMaxCalculated;
    private int _maxWidth;
    private int _minWidth;
    private int _firstLineWidth;
    private String _pseudoElementOrClass;
    private final Text _textNode;

    public InlineBox(String text, Text textNode) {
        this._text = text;
        this._originalText = text;
        this._textNode = textNode;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String text) {
        this._text = text;
        this._originalText = text;
    }

    public void applyTextTransform() {
        this._text = this._originalText;
        this._text = TextUtil.transformText(this._text, this.getStyle());
    }

    public boolean isRemovableWhitespace() {
        return this._removableWhitespace;
    }

    public void setRemovableWhitespace(boolean removeableWhitespace) {
        this._removableWhitespace = removeableWhitespace;
    }

    public boolean isEndsHere() {
        return this._endsHere;
    }

    public void setEndsHere(boolean endsHere) {
        this._endsHere = endsHere;
    }

    public boolean isStartsHere() {
        return this._startsHere;
    }

    public void setStartsHere(boolean startsHere) {
        this._startsHere = startsHere;
    }

    public CalculatedStyle getStyle() {
        return this._style;
    }

    public void setStyle(CalculatedStyle style) {
        this._style = style;
    }

    public Element getElement() {
        return this._element;
    }

    public void setElement(Element element) {
        this._element = element;
    }

    public ContentFunction getContentFunction() {
        return this._contentFunction;
    }

    public void setContentFunction(ContentFunction contentFunction) {
        this._contentFunction = contentFunction;
    }

    public boolean isDynamicFunction() {
        return this._contentFunction != null;
    }

    private int getTextWidth(LayoutContext c2, String s) {
        return c2.getTextRenderer().getWidth(c2.getFontContext(), c2.getFont(this.getStyle().getFont(c2)), s);
    }

    private void calcMaxWidthFromLineLength(LayoutContext c2, int cbWidth, boolean trim) {
        int length;
        String target;
        int last = 0;
        int current = 0;
        while ((current = this._text.indexOf("\n", last)) != -1) {
            target = this._text.substring(last, current);
            if (trim) {
                target = target.trim();
            }
            length = this.getTextWidth(c2, target);
            if (last == 0) {
                length += this.getStyle().getMarginBorderPadding(c2, cbWidth, 1);
            }
            if (length > this._maxWidth) {
                this._maxWidth = length;
            }
            if (last == 0) {
                this._firstLineWidth = length;
            }
            last = current + 1;
        }
        target = this._text.substring(last);
        if (trim) {
            target = target.trim();
        }
        length = this.getTextWidth(c2, target);
        if ((length += this.getStyle().getMarginBorderPadding(c2, cbWidth, 2)) > this._maxWidth) {
            this._maxWidth = length;
        }
        if (last == 0) {
            this._firstLineWidth = length;
        }
    }

    public int getSpaceWidth(LayoutContext c2) {
        return c2.getTextRenderer().getWidth(c2.getFontContext(), this.getStyle().getFSFont(c2), " ");
    }

    public int getTrailingSpaceWidth(LayoutContext c2) {
        if (this._text.length() > 0 && this._text.charAt(this._text.length() - 1) == ' ') {
            return this.getSpaceWidth(c2);
        }
        return 0;
    }

    private int calcMinWidthFromWordLength(LayoutContext c2, int cbWidth, boolean trimLeadingSpace, boolean includeWS) {
        int i2;
        int length;
        int spaceWidth = this.getSpaceWidth(c2);
        int last = 0;
        int current = 0;
        int maxWidth = 0;
        int spaceCount = 0;
        boolean haveFirstWord = false;
        int firstWord = 0;
        int lastWord = 0;
        String text = this.getText(trimLeadingSpace);
        while ((current = text.indexOf(" ", last)) != -1) {
            length = this.getTextWidth(c2, text.substring(last, current));
            if (spaceCount > 0) {
                if (includeWS) {
                    for (i2 = 0; i2 < spaceCount; ++i2) {
                        length += spaceWidth;
                    }
                }
                spaceCount = 0;
            }
            if (length > 0) {
                if (!haveFirstWord) {
                    firstWord = length;
                }
                lastWord = length;
            }
            if (length > this._minWidth) {
                this._minWidth = length;
            }
            maxWidth += length;
            if (!includeWS) {
                maxWidth += spaceWidth;
            }
            last = current;
            for (i2 = current; i2 < text.length() && text.charAt(i2) == ' '; ++i2) {
                ++spaceCount;
                ++last;
            }
        }
        length = this.getTextWidth(c2, text.substring(last));
        if (spaceCount > 0) {
            if (includeWS) {
                for (i2 = 0; i2 < spaceCount; ++i2) {
                    length += spaceWidth;
                }
            }
            spaceCount = 0;
        }
        if (length > 0) {
            if (!haveFirstWord) {
                firstWord = length;
            }
            lastWord = length;
        }
        if (length > this._minWidth) {
            this._minWidth = length;
        }
        maxWidth += length;
        if (this.isStartsHere()) {
            int leftMBP = this.getStyle().getMarginBorderPadding(c2, cbWidth, 1);
            if (firstWord + leftMBP > this._minWidth) {
                this._minWidth = firstWord + leftMBP;
            }
            maxWidth += leftMBP;
        }
        if (this.isEndsHere()) {
            int rightMBP = this.getStyle().getMarginBorderPadding(c2, cbWidth, 2);
            if (lastWord + rightMBP > this._minWidth) {
                this._minWidth = lastWord + rightMBP;
            }
            maxWidth += rightMBP;
        }
        return maxWidth;
    }

    private String getText(boolean trimLeadingSpace) {
        if (!trimLeadingSpace) {
            return this.getText();
        }
        if (this._text.length() > 0 && this._text.charAt(0) == ' ') {
            return this._text.substring(1);
        }
        return this._text;
    }

    private int getInlineMBP(LayoutContext c2, int cbWidth) {
        return this.getStyle().getMarginBorderPadding(c2, cbWidth, 1) + this.getStyle().getMarginBorderPadding(c2, cbWidth, 2);
    }

    public void calcMinMaxWidth(LayoutContext c2, int cbWidth, boolean trimLeadingSpace) {
        if (!this._minMaxCalculated) {
            IdentValue whitespace = this.getStyle().getWhitespace();
            if (whitespace == IdentValue.NOWRAP) {
                this._minWidth = this._maxWidth = this.getInlineMBP(c2, cbWidth) + this.getTextWidth(c2, this.getText(trimLeadingSpace));
            } else if (whitespace == IdentValue.PRE) {
                this.calcMaxWidthFromLineLength(c2, cbWidth, false);
                this._minWidth = this._maxWidth;
            } else if (whitespace == IdentValue.PRE_WRAP) {
                this.calcMinWidthFromWordLength(c2, cbWidth, false, true);
                this.calcMaxWidthFromLineLength(c2, cbWidth, false);
            } else if (whitespace == IdentValue.PRE_LINE) {
                this.calcMinWidthFromWordLength(c2, cbWidth, trimLeadingSpace, false);
                this.calcMaxWidthFromLineLength(c2, cbWidth, true);
            } else {
                this._maxWidth = this.calcMinWidthFromWordLength(c2, cbWidth, trimLeadingSpace, false);
            }
            this._minWidth = Math.min(this._maxWidth, this._minWidth);
            this._minMaxCalculated = true;
        }
    }

    public int getMaxWidth() {
        return this._maxWidth;
    }

    public int getMinWidth() {
        return this._minWidth;
    }

    public int getFirstLineWidth() {
        return this._firstLineWidth;
    }

    public String getPseudoElementOrClass() {
        return this._pseudoElementOrClass;
    }

    public void setPseudoElementOrClass(String pseudoElementOrClass) {
        this._pseudoElementOrClass = pseudoElementOrClass;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("InlineBox: ");
        if (this.getElement() != null) {
            result.append("<");
            result.append(this.getElement().getNodeName());
            result.append("> ");
        } else {
            result.append("(anonymous) ");
        }
        if (this.getPseudoElementOrClass() != null) {
            result.append(':');
            result.append(this.getPseudoElementOrClass());
            result.append(' ');
        }
        if (this.isStartsHere() || this.isEndsHere()) {
            result.append("(");
            if (this.isStartsHere()) {
                result.append("S");
            }
            if (this.isEndsHere()) {
                result.append("E");
            }
            result.append(") ");
        }
        this.appendPositioningInfo(result);
        result.append("(");
        result.append(this.shortText());
        result.append(") ");
        return result.toString();
    }

    protected void appendPositioningInfo(StringBuffer result) {
        if (this.getStyle().isRelative()) {
            result.append("(relative) ");
        }
        if (this.getStyle().isFixed()) {
            result.append("(fixed) ");
        }
        if (this.getStyle().isAbsolute()) {
            result.append("(absolute) ");
        }
        if (this.getStyle().isFloated()) {
            result.append("(floated) ");
        }
    }

    private String shortText() {
        if (this._text == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i2 = 0; i2 < this._text.length() && i2 < 40; ++i2) {
            char c2 = this._text.charAt(i2);
            if (c2 == '\n') {
                result.append(' ');
                continue;
            }
            result.append(c2);
        }
        if (result.length() == 40) {
            result.append("...");
        }
        return result.toString();
    }

    public FSFunction getFunction() {
        return this._function;
    }

    public void setFunction(FSFunction function) {
        this._function = function;
    }

    public void truncateText() {
        this._text = "";
        this._originalText = "";
    }

    public Text getTextNode() {
        return this._textNode;
    }
}

