/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xhtmlrenderer.css.extend.StylesheetFactory;
import org.xhtmlrenderer.css.sheet.StylesheetInfo;
import org.xhtmlrenderer.extend.NamespaceHandler;

public class NoNamespaceHandler
implements NamespaceHandler {
    static final String _namespace = "http://www.w3.org/XML/1998/namespace";
    private Pattern _typePattern = Pattern.compile("type\\s?=\\s?");
    private Pattern _hrefPattern = Pattern.compile("href\\s?=\\s?");
    private Pattern _titlePattern = Pattern.compile("title\\s?=\\s?");
    private Pattern _alternatePattern = Pattern.compile("alternate\\s?=\\s?");
    private Pattern _mediaPattern = Pattern.compile("media\\s?=\\s?");

    public String getNamespace() {
        return _namespace;
    }

    public String getAttributeValue(Element e2, String attrName) {
        return e2.getAttribute(attrName);
    }

    public String getAttributeValue(Element e2, String namespaceURI, String attrName) {
        if (namespaceURI == "") {
            return e2.getAttribute(attrName);
        }
        if (namespaceURI == null) {
            if (e2.getLocalName() == null) {
                return e2.getAttribute(attrName);
            }
            NamedNodeMap attrs = e2.getAttributes();
            int l2 = attrs.getLength();
            for (int i2 = 0; i2 < l2; ++i2) {
                Attr attr = (Attr)attrs.item(i2);
                if (!attrName.equals(attr.getLocalName())) continue;
                return attr.getValue();
            }
            return "";
        }
        return e2.getAttributeNS(namespaceURI, attrName);
    }

    public String getClass(Element e2) {
        return null;
    }

    public String getID(Element e2) {
        return null;
    }

    public String getLang(Element e2) {
        return e2.getAttribute("lang");
    }

    public String getElementStyling(Element e2) {
        return null;
    }

    public String getNonCssStyling(Element e2) {
        return null;
    }

    public String getLinkUri(Element e2) {
        return null;
    }

    public String getDocumentTitle(Document doc) {
        return null;
    }

    public String getAnchorName(Element e2) {
        return null;
    }

    public boolean isImageElement(Element e2) {
        return false;
    }

    public String getImageSourceURI(Element e2) {
        return null;
    }

    public boolean isFormElement(Element e2) {
        return false;
    }

    public StylesheetInfo[] getStylesheets(Document doc) {
        ArrayList<StylesheetInfo> list = new ArrayList<StylesheetInfo>();
        NodeList nl = doc.getChildNodes();
        int len = nl.getLength();
        for (int i2 = 0; i2 < len; ++i2) {
            int start;
            String alternate;
            ProcessingInstruction piNode;
            Node node = nl.item(i2);
            if (node.getNodeType() != 7 || !(piNode = (ProcessingInstruction)node).getTarget().equals("xml-stylesheet")) continue;
            StylesheetInfo info = new StylesheetInfo();
            info.setOrigin(2);
            String pi = piNode.getData();
            Matcher m2 = this._alternatePattern.matcher(pi);
            if (m2.matches() && (alternate = pi.substring((start = m2.end()) + 1, pi.indexOf(pi.charAt(start), start + 1))).equals("yes")) continue;
            m2 = this._typePattern.matcher(pi);
            if (m2.find()) {
                start = m2.end();
                String type = pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
                if (!type.equals("text/css")) continue;
                info.setType(type);
            }
            if ((m2 = this._hrefPattern.matcher(pi)).find()) {
                start = m2.end();
                String href = pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
                info.setUri(href);
            }
            if ((m2 = this._titlePattern.matcher(pi)).find()) {
                start = m2.end();
                String title = pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
                info.setTitle(title);
            }
            if ((m2 = this._mediaPattern.matcher(pi)).find()) {
                start = m2.end();
                String media = pi.substring(start + 1, pi.indexOf(pi.charAt(start), start + 1));
                info.setMedia(media);
            } else {
                info.addMedium("screen");
            }
            list.add(info);
        }
        return list.toArray(new StylesheetInfo[list.size()]);
    }

    public StylesheetInfo getDefaultStylesheet(StylesheetFactory factory) {
        return null;
    }
}

