/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.extend;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.simple.extend.XhtmlCssOnlyNamespaceHandler;

public class XhtmlNamespaceHandler
extends XhtmlCssOnlyNamespaceHandler {
    public boolean isImageElement(Element e2) {
        return e2 != null && e2.getNodeName().equalsIgnoreCase("img");
    }

    public boolean isFormElement(Element e2) {
        return e2 != null && e2.getNodeName().equalsIgnoreCase("form");
    }

    public String getImageSourceURI(Element e2) {
        String uri = null;
        if (e2 != null) {
            uri = e2.getAttribute("src");
        }
        return uri;
    }

    public String getNonCssStyling(Element e2) {
        if (e2.getNodeName().equals("table")) {
            return this.applyTableStyles(e2);
        }
        if (e2.getNodeName().equals("td") || e2.getNodeName().equals("th")) {
            return this.applyTableCellStyles(e2);
        }
        if (e2.getNodeName().equals("tr")) {
            return this.applyTableRowStyles(e2);
        }
        if (e2.getNodeName().equals("img")) {
            return this.applyImgStyles(e2);
        }
        if (e2.getNodeName().equals("p") || e2.getNodeName().equals("div")) {
            return this.applyBlockAlign(e2);
        }
        return "";
    }

    private String applyBlockAlign(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyTextAlign(e2, style);
        return style.toString();
    }

    private String applyImgStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyFloatingAlign(e2, style);
        return style.toString();
    }

    private String applyTableCellStyles(Element e2) {
        String s;
        StringBuffer style = new StringBuffer();
        Element table = this.findTable(e2);
        if (table != null) {
            s = this.getAttribute(table, "cellpadding");
            if (s != null) {
                style.append("padding: ");
                style.append(this.convertToLength(s));
                style.append(";");
            }
            if ((s = this.getAttribute(table, "border")) != null && !s.equals("0")) {
                style.append("border: 1px outset black;");
            }
        }
        if ((s = this.getAttribute(e2, "width")) != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e2, "height")) != null) {
            style.append("height: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        this.applyTableContentAlign(e2, style);
        s = this.getAttribute(e2, "bgcolor");
        if (s != null) {
            s = s.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e2, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        return style.toString();
    }

    private String applyTableStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        String s = this.getAttribute(e2, "width");
        if (s != null) {
            style.append("width: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e2, "border")) != null) {
            style.append("border: ");
            style.append(this.convertToLength(s));
            style.append(" inset black;");
        }
        if ((s = this.getAttribute(e2, "cellspacing")) != null) {
            style.append("border-collapse: separate; border-spacing: ");
            style.append(this.convertToLength(s));
            style.append(";");
        }
        if ((s = this.getAttribute(e2, "bgcolor")) != null) {
            s = s.toLowerCase();
            style.append("background-color: ");
            if (this.looksLikeAMangledColor(s)) {
                style.append('#');
                style.append(s);
            } else {
                style.append(s);
            }
            style.append(';');
        }
        if ((s = this.getAttribute(e2, "background")) != null) {
            style.append("background-image: url(");
            style.append(s);
            style.append(");");
        }
        this.applyFloatingAlign(e2, style);
        return style.toString();
    }

    private String applyTableRowStyles(Element e2) {
        StringBuffer style = new StringBuffer();
        this.applyTableContentAlign(e2, style);
        return style.toString();
    }

    private void applyFloatingAlign(Element e2, StringBuffer style) {
        String s = this.getAttribute(e2, "align");
        if (s != null) {
            if ((s = s.toLowerCase().trim()).equals("left")) {
                style.append("float: left;");
            } else if (s.equals("right")) {
                style.append("float: right;");
            } else if (s.equals("center")) {
                style.append("margin-left: auto; margin-right: auto;");
            }
        }
    }

    private void applyTextAlign(Element e2, StringBuffer style) {
        String s = this.getAttribute(e2, "align");
        if (s != null && ((s = s.toLowerCase().trim()).equals("left") || s.equals("right") || s.equals("center") || s.equals("justify"))) {
            style.append("text-align: ");
            style.append(s);
            style.append(";");
        }
    }

    private void applyTableContentAlign(Element e2, StringBuffer style) {
        String s = this.getAttribute(e2, "align");
        if (s != null) {
            style.append("text-align: ");
            style.append(s.toLowerCase());
            style.append(";");
        }
        if ((s = this.getAttribute(e2, "valign")) != null) {
            style.append("vertical-align: ");
            style.append(s.toLowerCase());
            style.append(";");
        }
    }

    private boolean looksLikeAMangledColor(String s) {
        if (s.length() != 6) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            boolean valid;
            char c2 = s.charAt(i2);
            boolean bl = valid = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private Element findTable(Element cell) {
        Element next;
        Node n = cell.getParentNode();
        if (n.getNodeType() == 1 && (next = (Element)n).getNodeName().equals("tr") && (n = next.getParentNode()).getNodeType() == 1) {
            next = (Element)n;
            String name = next.getNodeName();
            if (name.equals("table")) {
                return next;
            }
            if ((name.equals("tbody") || name.equals("tfoot") || name.equals("thead")) && (n = next.getParentNode()).getNodeType() == 1 && (next = (Element)n).getNodeName().equals("table")) {
                return next;
            }
        }
        return null;
    }
}

