/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.controls;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormControlListener;
import org.xhtmlrenderer.simple.xhtml.FormListener;
import org.xhtmlrenderer.simple.xhtml.XhtmlForm;

public abstract class AbstractControl
implements FormControl {
    private XhtmlForm _form;
    private Element _element;
    private String _name;
    private String _initialValue;
    private String _value;
    private boolean _successful;
    private boolean _enabled;
    private List _listeners = new ArrayList();

    public AbstractControl(XhtmlForm form, Element e2) {
        this._form = form;
        this._element = e2;
        this._name = e2.getAttribute("name");
        if (this._name.length() == 0) {
            this._name = e2.getAttribute("id");
        }
        this._value = this._initialValue = e2.getAttribute("value");
        this._successful = this._enabled = e2.getAttribute("disabled").length() == 0;
        if (form != null) {
            form.addFormListener(new FormListener(){

                public void submitted(XhtmlForm form) {
                }

                public void resetted(XhtmlForm form) {
                    AbstractControl.this.reset();
                }
            });
        }
    }

    protected void fireChanged() {
        Iterator iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ((FormControlListener)iter.next()).changed(this);
        }
    }

    protected void fireSuccessful() {
        Iterator iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ((FormControlListener)iter.next()).successful(this);
        }
    }

    protected void fireEnabled() {
        Iterator iter = this._listeners.iterator();
        while (iter.hasNext()) {
            ((FormControlListener)iter.next()).enabled(this);
        }
    }

    public void addFormControlListener(FormControlListener listener) {
        this._listeners.add(listener);
    }

    public void removeFormControlListener(FormControlListener listener) {
        this._listeners.remove(listener);
    }

    public Element getElement() {
        return this._element;
    }

    public XhtmlForm getForm() {
        return this._form;
    }

    public String getName() {
        return this._name;
    }

    public String getInitialValue() {
        return this._initialValue;
    }

    protected void setInitialValue(String value) {
        this._initialValue = value;
        this._value = value;
    }

    public String getValue() {
        if (this.isMultiple()) {
            return null;
        }
        return this._value;
    }

    public void setValue(String value) {
        if (!this.isMultiple()) {
            this._value = value;
            this.fireChanged();
        }
    }

    public String[] getMultipleValues() {
        return null;
    }

    public void setMultipleValues(String[] values) {
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isSuccessful() {
        return this._successful && this._enabled;
    }

    public boolean isMultiple() {
        return false;
    }

    public void setSuccessful(boolean successful) {
        this._successful = successful;
        this.fireSuccessful();
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        this.fireEnabled();
    }

    public void reset() {
        this.setValue(this._initialValue);
    }

    public static String collectText(Element e2) {
        StringBuffer result = new StringBuffer();
        Node node = e2.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 3) continue;
                Text text = (Text)node;
                result.append(text.getData());
            } while ((node = node.getNextSibling()) != null);
        }
        return result.toString().trim();
    }

    public static int getIntAttribute(Element e2, String attribute, int def) {
        int result = def;
        String str = e2.getAttribute(attribute);
        if (str.length() > 0) {
            try {
                result = Integer.parseInt(str);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return result;
    }
}

