/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.simple.xhtml.swt;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.simple.xhtml.FormControl;
import org.xhtmlrenderer.simple.xhtml.FormControlAdapter;
import org.xhtmlrenderer.simple.xhtml.controls.TextControl;
import org.xhtmlrenderer.simple.xhtml.swt.SWTXhtmlControl;
import org.xhtmlrenderer.swt.BasicRenderer;

public class SWTTextControl
extends SWTXhtmlControl {
    private String _sizeText;
    private boolean _noChangeText = false;

    public SWTTextControl(FormControl control, BasicRenderer parent, LayoutContext c2, CalculatedStyle style, UserAgentCallback uac) {
        super(control, parent, c2, style, uac);
    }

    protected Control createSWTControl(FormControl control, BasicRenderer parent, LayoutContext c2, CalculatedStyle style, UserAgentCallback uac) {
        int i2;
        final TextControl tc = (TextControl)control;
        int sty = 2048;
        if (tc.isMultiLine()) {
            sty |= 2;
        }
        if (tc.isReadOnly()) {
            sty |= 8;
        }
        if (tc.isPassword()) {
            sty |= 0x400000;
        }
        final Text text = new Text((Composite)parent, sty);
        text.setText(SWTTextControl.encodeDelimiter(control.getInitialValue()));
        StringBuffer str = new StringBuffer(tc.getSize());
        for (i2 = 0; i2 < tc.getSize(); ++i2) {
            str.append('M');
        }
        if (tc.isMultiLine()) {
            for (i2 = 1; i2 < tc.getRows(); ++i2) {
                str.append(Text.DELIMITER);
            }
        }
        this._sizeText = str.toString();
        if (tc.getMaxLength() >= 0) {
            text.setTextLimit(tc.getMaxLength());
        }
        tc.addFormControlListener(new FormControlAdapter(){

            public void changed(FormControl control) {
                if (!SWTTextControl.this._noChangeText) {
                    text.setText(SWTTextControl.encodeDelimiter(control.getValue()));
                }
                SWTTextControl.this._noChangeText = false;
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e2) {
                SWTTextControl.this._noChangeText = true;
                tc.setValue(SWTTextControl.decodeDelimiter(text.getText()));
            }
        });
        return text;
    }

    public int getIdealWidth() {
        Text text = (Text)this.getSWTControl();
        String old = text.getText();
        text.setText(this._sizeText);
        text.pack();
        int width = text.getSize().x;
        text.setText(old);
        return width;
    }

    public int getIdealHeight() {
        Text text = (Text)this.getSWTControl();
        String old = text.getText();
        text.setText(this._sizeText);
        text.pack();
        int height = text.getSize().y;
        text.setText(old);
        return height;
    }

    private static String encodeDelimiter(String text) {
        return text.replaceAll("\n", Text.DELIMITER);
    }

    private static String decodeDelimiter(String text) {
        return text.replaceAll(Text.DELIMITER, "\n");
    }
}

