/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.style.FSDerivedValue;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.swt.BasicRenderer;

public class CursorListener
implements MouseMoveListener {
    private final BasicRenderer _parent;

    public CursorListener(BasicRenderer parent) {
        this._parent = parent;
        parent.addMouseMoveListener(this);
    }

    public void mouseMove(MouseEvent e2) {
        Box box = this._parent.find(e2.x, e2.y);
        if (box == null) {
            return;
        }
        FSDerivedValue value = box.getStyle().valueByName(CSSName.CURSOR);
        int cursor = 0;
        if (value == IdentValue.AUTO || value == IdentValue.DEFAULT) {
            cursor = 0;
        } else if (value == IdentValue.CROSSHAIR) {
            cursor = 2;
        } else if (value == IdentValue.POINTER) {
            cursor = 21;
        } else if (value == IdentValue.MOVE) {
            cursor = 5;
        } else if (value == IdentValue.E_RESIZE) {
            cursor = 12;
        } else if (value == IdentValue.NE_RESIZE) {
            cursor = 14;
        } else if (value == IdentValue.NW_RESIZE) {
            cursor = 17;
        } else if (value == IdentValue.N_RESIZE) {
            cursor = 10;
        } else if (value == IdentValue.SE_RESIZE) {
            cursor = 15;
        } else if (value == IdentValue.SW_RESIZE) {
            cursor = 16;
        } else if (value == IdentValue.S_RESIZE) {
            cursor = 11;
        } else if (value == IdentValue.W_RESIZE) {
            cursor = 13;
        } else if (value == IdentValue.TEXT) {
            cursor = 19;
        } else if (value == IdentValue.WAIT) {
            cursor = 1;
        } else if (value == IdentValue.HELP) {
            cursor = 4;
        } else if (value == IdentValue.PROGRESS) {
            cursor = 3;
        }
        Cursor c2 = null;
        if (cursor != 0) {
            c2 = this._parent.getDisplay().getSystemCursor(cursor);
        }
        this._parent.setCursor(c2);
    }
}

