/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.resource.CSSResource;
import org.xhtmlrenderer.resource.ImageResource;
import org.xhtmlrenderer.resource.XMLResource;
import org.xhtmlrenderer.swt.SWTFSImage;
import org.xhtmlrenderer.util.XRLog;

public class NaiveUserAgent
implements UserAgentCallback {
    private int _imageCacheCapacity = 16;
    private LinkedHashMap _imageCache = new LinkedHashMap(this._imageCacheCapacity, 0.75f, true);
    private String _baseURL;
    private final Device _device;

    public NaiveUserAgent(Device device) {
        this._device = device;
    }

    protected InputStream getInputStream(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            is = new URL(uri).openStream();
        }
        catch (MalformedURLException e2) {
            XRLog.exception("bad URL given: " + uri, e2);
        }
        catch (FileNotFoundException e3) {
            XRLog.exception("item at URI " + uri + " not found");
        }
        catch (IOException e4) {
            XRLog.exception("IO problem for " + uri, e4);
        }
        return is;
    }

    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.getInputStream(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageResource getImageResource(String uri) {
        InputStream is;
        ImageResource ir = null;
        ir = (ImageResource)this._imageCache.get(uri = this.resolveURI(uri));
        if (ir == null && (is = this.getInputStream(uri)) != null) {
            try {
                ir = new ImageResource(uri, new SWTFSImage(new Image(this._device, is), this, uri));
                if (this._imageCache.size() >= this._imageCacheCapacity) {
                    ImageResource old = (ImageResource)this._imageCache.remove(this._imageCache.keySet().iterator().next());
                    ((SWTFSImage)old.getImage()).getImage().dispose();
                }
                this._imageCache.put(uri, ir);
            }
            catch (SWTException e2) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e2);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e3) {}
            }
        }
        if (ir == null) {
            ir = new ImageResource(uri, null);
        }
        return ir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        if (uri == null) {
            XRLog.exception("null uri requested");
            return null;
        }
        InputStream inputStream = this.getInputStream(uri);
        if (inputStream == null) {
            XRLog.exception("couldn't get InputStream for " + uri);
            return null;
        }
        try {
            xmlResource = XMLResource.load(inputStream);
        }
        catch (Exception e2) {
            XRLog.exception("unable to load xml resource: " + uri, e2);
            XMLResource xMLResource = null;
            return xMLResource;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e3) {}
            }
        }
        return xmlResource;
    }

    public boolean isVisited(String uri) {
        return false;
    }

    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    public String resolveURI(String uri) {
        URL result;
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this._baseURL == null) {
            try {
                result = new URL(uri);
                this.setBaseURL(result.toExternalForm());
            }
            catch (MalformedURLException e2) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri);
                    return null;
                }
            }
        }
        try {
            result = new URL(new URL(this._baseURL), uri);
            ret = result.toString();
        }
        catch (MalformedURLException e1) {
            XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL);
        }
        return ret;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public void disposeCache() {
        Iterator iter = this._imageCache.values().iterator();
        while (iter.hasNext()) {
            ImageResource ir = (ImageResource)iter.next();
            ((SWTFSImage)ir.getImage()).getImage().dispose();
        }
        this._imageCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBinaryResource(String uri) {
        InputStream is = this.getInputStream(uri);
        try {
            int i2;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i2 = is.read(buf)) != -1) {
                result.write(buf, 0, i2);
            }
            is.close();
            is = null;
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e2) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e3) {}
            }
        }
    }
}

