/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.config.conf.printer;

import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PrintNameCorrection
extends ModelNode<PrintNameCorrection> {
    private StringNode regEx;

    public static PrintNameCorrection create(String regEx) {
        PrintNameCorrection result = new PrintNameCorrection();
        result.regEx = new StringNode(regEx);
        return result;
    }

    public String getCorrectedName(String value) {
        return PrintNameCorrection.getCorrectedName(this.regEx.getStringValue(), value);
    }

    public static String getCorrectedName(String testRegEx, String value) {
        try {
            Pattern regExPattern = Pattern.compile(testRegEx);
            Matcher matcher = regExPattern.matcher(value);
            return matcher.replaceAll("");
        }
        catch (Exception e2) {
            return value;
        }
    }

    public StringNode getRegEx() {
        return this.regEx;
    }
}

