/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.bordereau;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauZazFetchInfo;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.DateUtil;
import java.util.Date;

public final class BordereauFetchInfo
extends ModelNode<BordereauFetchInfo>
implements RootNode<BordereauFetchInfo> {
    @listType(value=BordereauZazFetchInfo.class)
    private ListNode<BordereauZazFetchInfo> bordereauZazFetchInfoList;

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public void updateLastFetchDate(String accountNumber, EdecDateNode date) {
        BordereauZazFetchInfo zazFetchInfo = this.findZazFetchInfo(accountNumber);
        if (zazFetchInfo == null) {
            zazFetchInfo = NodeFactory.create(BordereauZazFetchInfo.class);
            this.bordereauZazFetchInfoList.add(zazFetchInfo);
            zazFetchInfo.getAccountNumber().setValue(accountNumber);
            zazFetchInfo.getLastFetchDate().apply(date);
        } else {
            zazFetchInfo.updateLastFetchDate(date);
        }
    }

    private BordereauZazFetchInfo findZazFetchInfo(String accountNumber) {
        for (BordereauZazFetchInfo current : this.getBordereauZazFetchInfoList()) {
            if (!current.getAccountNumber().getValue().equals(accountNumber)) continue;
            return current;
        }
        return null;
    }

    public ListNode<BordereauZazFetchInfo> getBordereauZazFetchInfoList() {
        return this.bordereauZazFetchInfoList;
    }

    public Date getlastFetchDate(String accountNumber) {
        BordereauZazFetchInfo fetchInfo = this.findZazFetchInfo(accountNumber);
        if (fetchInfo == null) {
            return null;
        }
        return fetchInfo.getLastFetchDate().isInitialized() ? DateUtil.toDate(fetchInfo.getFixedLastFetchDate()) : null;
    }
}

