/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.receipt;

import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.node.BinaryNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import java.util.Arrays;

public final class ReceiptDocument
extends ModelNode<ReceiptDocument> {
    @mandatory
    @defaultValue(value="0")
    private IntegralNode state;
    @mandatory
    private BinaryNode data;
    @mandatory
    private BinaryNode validationProtocol;

    public IntegralNode getState() {
        return this.state;
    }

    public BinaryNode getData() {
        return this.data;
    }

    public BinaryNode getValidationProtocol() {
        return this.validationProtocol;
    }

    public boolean hasDocumentOrError() {
        return !State.DOC_NOT_RECEIVED.equalsNode(this.getState());
    }

    public boolean hasDocument() {
        return this.hasDocumentOrError() && !this.hasError();
    }

    public boolean hasError() {
        return State.DOC_ERROR.equalsNode(this.getState());
    }

    public static enum State {
        DOC_NOT_RECEIVED(0),
        DOC_RECEIVED(1),
        DOC_VALID(2),
        DOC_INVALID(3),
        DOC_ERROR(4);

        private final int value;

        public static State fromIntValue(Long value) {
            if (value == null) {
                return DOC_NOT_RECEIVED;
            }
            return State.fromIntValue((long)value);
        }

        public static State fromIntValue(long value) {
            return Arrays.stream(State.values()).filter(it -> (long)it.value == value).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid document state " + value));
        }

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public long getValueAsLong() {
            return this.value;
        }

        public IntegralNode asIntegralNode() {
            return new IntegralNode(this.getValueAsLong());
        }

        public boolean equalsNode(IntegralNode state) {
            return State.fromIntValue(state.getValue()) == this;
        }
    }
}

