/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.evvimport.receipt;

import ch.transsoft.edec.model.evvimport.receipt.ImportSending;
import ch.transsoft.edec.model.evvimport.receipt.ImportSendingKey;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptDocument;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.indexhandling.IndexEntryBase;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.ConstBooleanNode;
import ch.transsoft.edec.model.infra.node.ConstStringNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.EdecDateNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.service.ezv.ReceiptDocumentType;
import ch.transsoft.edec.ui.gui.Design;
import ch.transsoft.edec.util.Check;
import java.awt.Color;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ReceiptEntry
extends IndexEntryBase<ReceiptEntry> {
    private String date;
    private Long vvz;
    private Long vvm;
    private Long rbz;
    private Long rbm;
    private Long declarationType;
    private Double totalDuty;
    private Double totalVAT;
    private String customsReferenceNumber;
    private String consignorName;
    private String consignorCity;
    private String consignorCountry;
    private String bordereauNumber;
    private String receiptSource = ImportSending.ReceiptSource.bordereau.name();
    private String orderNumber;
    private String customsOffice;
    private String declarant;
    private String consignee;
    private String consigneeCity;
    private String consigneeCountry;
    private String importer;
    private String importerReference;
    private String consignorReference;
    private String consigneeReference;
    private String traderReference;
    private boolean star;
    private String consigneeUid;
    private String importerUid;
    private Long preference;
    private String permitNumber;
    private String permitAuthority;
    private Double monopol;
    private Long customsClearanceType;

    @Override
    public void setParent(ModelNode<?> parent) {
    }

    @Override
    public void completeCopy(NodeBase<?> result, ModelNode<?> parent) {
        super.completeCopy(result, null);
    }

    @Override
    public ImportSendingKey getId() {
        return new ImportSendingKey(this.customsReferenceNumber, this.date);
    }

    @Override
    public ReceiptEntry getCopy(ModelNode<?> parent) {
        ReceiptEntry result = new ReceiptEntry();
        result.date = this.date;
        result.vvz = this.vvz;
        result.vvm = this.vvm;
        result.rbz = this.rbz;
        result.rbm = this.rbm;
        result.declarationType = this.declarationType;
        result.totalDuty = this.totalDuty;
        result.totalVAT = this.totalVAT;
        result.customsReferenceNumber = this.customsReferenceNumber;
        result.customsOffice = this.customsOffice;
        result.declarant = this.declarant;
        result.consignee = this.consignee;
        result.consigneeCity = this.consigneeCity;
        result.consigneeCountry = this.consigneeCountry;
        result.importer = this.importer;
        result.consignorName = this.consignorName;
        result.consignorCity = this.consignorCity;
        result.consignorCountry = this.consignorCountry;
        result.bordereauNumber = this.bordereauNumber;
        result.receiptSource = this.receiptSource;
        result.orderNumber = this.orderNumber;
        result.preference = this.preference;
        result.permitNumber = this.permitNumber;
        result.permitAuthority = this.permitAuthority;
        result.importerReference = this.importerReference;
        result.consignorReference = this.consignorReference;
        result.consigneeReference = this.consigneeReference;
        result.traderReference = this.traderReference;
        result.star = this.star;
        result.consigneeUid = this.consigneeUid;
        result.importerUid = this.importerUid;
        result.monopol = this.monopol;
        result.customsClearanceType = this.customsClearanceType;
        this.completeCopy(result, parent);
        return result;
    }

    @Override
    public void apply(ReceiptEntry other) {
        this.date = other.date;
        this.vvz = other.vvz;
        this.vvm = other.vvm;
        this.rbz = other.rbz;
        this.rbm = other.rbm;
        this.declarationType = other.declarationType;
        this.totalVAT = other.totalVAT;
        this.totalDuty = other.totalDuty;
        this.customsReferenceNumber = other.customsReferenceNumber;
        this.customsOffice = other.customsOffice;
        this.declarant = other.declarant;
        this.consignee = other.consignee;
        this.consigneeCity = other.consigneeCity;
        this.consigneeCountry = other.consigneeCountry;
        this.importer = other.importer;
        this.consignorName = other.consignorName;
        this.consignorCity = other.consignorCity;
        this.consignorCountry = other.consignorCountry;
        this.bordereauNumber = other.bordereauNumber;
        this.receiptSource = other.receiptSource;
        this.orderNumber = other.orderNumber;
        this.preference = other.preference;
        this.permitNumber = other.permitNumber;
        this.permitAuthority = other.permitAuthority;
        this.importerReference = other.importerReference;
        this.consignorReference = other.consignorReference;
        this.consigneeReference = other.consigneeReference;
        this.traderReference = other.traderReference;
        this.star = other.star;
        this.consigneeUid = other.consigneeUid;
        this.importerUid = other.importerUid;
        this.monopol = other.monopol;
        this.customsClearanceType = other.customsClearanceType;
    }

    @Override
    public void printField(Node parent, IXMLWriter writer, String tagName) throws Exception {
        Element element = writer.printModelNode(parent, this, tagName);
        writer.printPrimitive((Node)element, this.date, "date");
        writer.printPrimitive((Node)element, this.vvz, "vvz");
        writer.printPrimitive((Node)element, this.vvm, "vvm");
        writer.printPrimitive((Node)element, this.rbz, "rbz");
        writer.printPrimitive((Node)element, this.rbm, "rbm");
        writer.printPrimitive((Node)element, this.declarationType, "declarationType");
        writer.printPrimitive((Node)element, this.totalVAT, "totalVAT");
        writer.printPrimitive((Node)element, this.totalDuty, "totalDuty");
        writer.printPrimitive((Node)element, this.customsReferenceNumber, "customsReferenceNumber");
        writer.printPrimitive((Node)element, this.customsOffice, "customsOffice");
        writer.printPrimitive((Node)element, this.declarant, "declarant");
        writer.printPrimitive((Node)element, this.consignee, "consignee");
        writer.printPrimitive((Node)element, this.consigneeCity, "consigneeCity");
        writer.printPrimitive((Node)element, this.consigneeCountry, "consigneeCountry");
        writer.printPrimitive((Node)element, this.importer, "importer");
        writer.printPrimitive((Node)element, this.consignorName, "consignorName");
        writer.printPrimitive((Node)element, this.consignorCity, "consignorCity");
        writer.printPrimitive((Node)element, this.consignorCountry, "consignorCountry");
        writer.printPrimitive((Node)element, this.bordereauNumber, "bordereauNumber");
        writer.printPrimitive((Node)element, this.receiptSource, "receiptSource");
        writer.printPrimitive((Node)element, this.orderNumber, "orderNumber");
        writer.printPrimitive((Node)element, this.preference, "preference");
        writer.printPrimitive((Node)element, this.permitNumber, "permitNumber");
        writer.printPrimitive((Node)element, this.permitAuthority, "permitAuthority");
        writer.printPrimitive((Node)element, this.importerReference, "importerReference");
        writer.printPrimitive((Node)element, this.consignorReference, "consignorReference");
        writer.printPrimitive((Node)element, this.consigneeReference, "consigneeReference");
        writer.printPrimitive((Node)element, this.traderReference, "traderReference");
        writer.printPrimitive((Node)element, this.star, "star");
        writer.printPrimitive((Node)element, this.consigneeUid, "consigneeUid");
        writer.printPrimitive((Node)element, this.importerUid, "importerUid");
        writer.printPrimitive((Node)element, this.monopol, "monopol");
        writer.printPrimitive((Node)element, this.customsClearanceType, "customsClearanceType");
    }

    public IntegralNode getVvz() {
        return this.createIntegralNode(this.vvz);
    }

    public void setVvz(IntegralNode value) {
        this.vvz = ReceiptEntry.valueOf(value);
    }

    public IntegralNode getVvm() {
        return this.createIntegralNode(this.vvm);
    }

    public void setVvm(IntegralNode value) {
        this.vvm = ReceiptEntry.valueOf(value);
    }

    public IntegralNode getRbz() {
        return this.createIntegralNode(this.rbz);
    }

    public void setRbz(IntegralNode value) {
        this.rbz = ReceiptEntry.valueOf(value);
    }

    public IntegralNode getRbm() {
        return this.createIntegralNode(this.rbm);
    }

    public void setRbm(IntegralNode value) {
        this.rbm = ReceiptEntry.valueOf(value);
    }

    public IntegralNode getDeclarationType() {
        return this.createIntegralNode(this.declarationType);
    }

    public void setDeclarationType(IntegralNode value) {
        this.declarationType = ReceiptEntry.valueOf(value);
    }

    public StringNode getPreference() {
        String s;
        if (this.preference == null) {
            s = "";
        } else if (this.preference == 0L) {
            s = "0";
        } else if (this.preference == 1L) {
            s = "1";
        } else if (this.preference == 2L) {
            s = "MIX";
        } else if (this.preference == -2L) {
            s = "";
        } else {
            throw new IllegalStateException("Unexpected preference: " + this.preference);
        }
        return new StringNode(s);
    }

    public void setPreference(IntegralNode value) {
        this.preference = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getPermitNumber() {
        return new ConstStringNode(this.permitNumber);
    }

    public void setPermitNumber(StringNode value) {
        this.permitNumber = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getPermitAuthority() {
        return new ConstStringNode(this.permitAuthority);
    }

    public void setPermitAuthority(StringNode value) {
        this.permitAuthority = ReceiptEntry.valueOf(value);
    }

    public DecimalNode getTotalVAT() {
        return new DecimalNode(this.totalVAT, 12, 2);
    }

    public void setTotalVAT(DecimalNode value) {
        this.totalVAT = this.valueOf(value);
    }

    public DecimalNode getTotalDuty() {
        return new DecimalNode(this.totalDuty, 12, 2);
    }

    public void setTotalDuty(DecimalNode value) {
        this.totalDuty = this.valueOf(value);
    }

    public ConstStringNode getCustomsReferenceNumber() {
        return new ConstStringNode(this.customsReferenceNumber);
    }

    public void setCustomsReferenceNumber(StringNode value) {
        this.customsReferenceNumber = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getCustomsOffice() {
        return new ConstStringNode(this.customsOffice);
    }

    public void setCustomsOffice(StringNode value) {
        this.customsOffice = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsignee() {
        return new ConstStringNode(this.consignee);
    }

    public void setConsignee(StringNode value) {
        this.consignee = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsigneeCity() {
        return new ConstStringNode(this.consigneeCity);
    }

    public void setConsigneeCity(StringNode value) {
        this.consigneeCity = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsigneeCountry() {
        return new ConstStringNode(this.consigneeCountry);
    }

    public void setConsigneeCountry(StringNode value) {
        this.consigneeCountry = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getImporter() {
        return new ConstStringNode(this.importer);
    }

    public void setImporter(StringNode value) {
        this.importer = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getImporterReference() {
        return new ConstStringNode(this.importerReference);
    }

    public void setImporterReference(StringNode value) {
        this.importerReference = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsignorReference() {
        return new ConstStringNode(this.consignorReference);
    }

    public void setConsignorReference(StringNode value) {
        this.consignorReference = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsigneeReference() {
        return new ConstStringNode(this.consigneeReference);
    }

    public void setConsigneeReference(StringNode value) {
        this.consigneeReference = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getTraderReference() {
        return new ConstStringNode(this.traderReference);
    }

    public void setTraderReference(StringNode value) {
        this.traderReference = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsigneeUid() {
        return new ConstStringNode(this.consigneeUid);
    }

    public void setConsigneeUid(StringNode value) {
        this.consigneeUid = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getImporterUid() {
        return new ConstStringNode(this.importerUid);
    }

    public void setImporterUid(StringNode value) {
        this.importerUid = ReceiptEntry.valueOf(value);
    }

    public DecimalNode getMonopol() {
        return new DecimalNode(this.monopol, 12, 2);
    }

    public void setMonopol(DecimalNode value) {
        this.monopol = this.valueOf(value);
    }

    public StringNode getCustomsClearanceType() {
        String s = this.customsClearanceType == null ? "" : (this.customsClearanceType == -1L ? "MIX" : (this.customsClearanceType == -2L ? "" : Integer.toString(this.customsClearanceType.intValue())));
        return new StringNode(s);
    }

    public void setCustomsClearanceType(IntegralNode value) {
        this.customsClearanceType = ReceiptEntry.valueOf(value);
    }

    public BooleanNode getStar() {
        return new ConstBooleanNode(this.star);
    }

    public void setStar(BooleanNode value) {
        this.star = value.getValue();
    }

    public ConstStringNode getDeclarant() {
        return new ConstStringNode(this.declarant);
    }

    public void setDeclarant(StringNode value) {
        this.declarant = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsignorName() {
        return new ConstStringNode(this.consignorName);
    }

    public void setConsignorName(StringNode value) {
        this.consignorName = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsignorCity() {
        return new ConstStringNode(this.consignorCity);
    }

    public void setConsignorCity(StringNode value) {
        this.consignorCity = ReceiptEntry.valueOf(value);
    }

    public ConstStringNode getConsignorCountry() {
        return new ConstStringNode(this.consignorCountry);
    }

    public void setConsignorCountry(StringNode value) {
        this.consignorCountry = ReceiptEntry.valueOf(value);
    }

    public EdecDateNode getDate() {
        return new EdecDateNode(this.date);
    }

    public void setDate(EdecDateNode value) {
        this.date = this.valueOf(value);
    }

    public ConstStringNode getBordereauNumberWithSourceInfo() {
        return ImportSending.getBordereauNumberWithSourceInfo(this.bordereauNumber, ImportSending.ReceiptSource.valueOf(this.receiptSource));
    }

    public ConstStringNode getBordereauNumber() {
        return new ConstStringNode(this.bordereauNumber);
    }

    public void setBordereauNumber(StringNode value) {
        this.bordereauNumber = ReceiptEntry.valueOf(value);
    }

    public ImportSending.ReceiptSource getReceiptSource() {
        return ImportSending.ReceiptSource.valueOf(this.receiptSource);
    }

    public void setReceiptSource(ImportSending.ReceiptSource value) {
        this.receiptSource = value.name();
    }

    public ConstStringNode getOrderNumber() {
        return new ConstStringNode(this.orderNumber);
    }

    public void setOrderNumber(StringNode value) {
        this.orderNumber = ReceiptEntry.valueOf(value);
    }

    public boolean containsReceiptDocumentOrError(ReceiptDocumentType value) {
        return this.containsReceiptDocument(value) || this.hasError(value);
    }

    public boolean containsReceiptDocument(ReceiptDocumentType value) {
        return this.hasDocument(this.getDocState(value));
    }

    private boolean hasError(ReceiptDocumentType value) {
        return this.getDocState(value) == ReceiptDocument.State.DOC_ERROR;
    }

    public ReceiptDocument.State getDocState(ReceiptDocumentType value) {
        switch (value) {
            case vvz: {
                return ReceiptDocument.State.fromIntValue(this.vvz);
            }
            case vvm: {
                return ReceiptDocument.State.fromIntValue(this.vvm);
            }
            case rbz: {
                return ReceiptDocument.State.fromIntValue(this.rbz);
            }
            case rbm: {
                return ReceiptDocument.State.fromIntValue(this.rbm);
            }
        }
        throw Check.fail("Unexpected ReceiptDocumentType " + String.valueOf((Object)value));
    }

    public int getYear() {
        return this.getDate().getYear();
    }

    public boolean hasVvzInfo() {
        return this.hasInfo(this.getVvz().getValue());
    }

    public boolean hasVvmInfo() {
        return this.hasInfo(this.getVvm().getValue());
    }

    public boolean hasRbzInfo() {
        return this.hasInfo(this.getRbz().getValue());
    }

    public boolean hasRbmInfo() {
        return this.hasInfo(this.getRbm().getValue());
    }

    private boolean hasInfo(Long value) {
        return ReceiptDocument.State.fromIntValue(value) != ReceiptDocument.State.DOC_NOT_RECEIVED;
    }

    public boolean hasVvz() {
        return this.hasDocument(ReceiptDocument.State.fromIntValue(this.getVvz().getValue()));
    }

    public boolean hasVvm() {
        return this.hasDocument(this.getVvm().getValue());
    }

    public boolean hasRbz() {
        return this.hasDocument(this.getRbz().getValue());
    }

    public boolean hasRbm() {
        return this.hasDocument(this.getRbm().getValue());
    }

    private boolean hasDocument(Long value) {
        ReceiptDocument.State state = ReceiptDocument.State.fromIntValue(value);
        return this.hasDocument(state);
    }

    private boolean hasDocument(ReceiptDocument.State state) {
        return state == ReceiptDocument.State.DOC_RECEIVED || state == ReceiptDocument.State.DOC_VALID || state == ReceiptDocument.State.DOC_INVALID;
    }

    public String getCustomsReferenceNumberStr() {
        return this.customsReferenceNumber;
    }

    public ImportSendingKey getKey() {
        return new ImportSendingKey(this.customsReferenceNumber, this.date);
    }

    public Color getSpecialColor(ReceiptDocumentType type, boolean isSelected) {
        switch (type) {
            case vvz: {
                return this.getVvzColor(isSelected);
            }
            case vvm: {
                return this.getVvmColor(isSelected);
            }
            case rbz: 
            case rbm: {
                return null;
            }
        }
        throw Check.fail("Unexpected ReceiptDocumentType " + String.valueOf((Object)type));
    }

    private Color getVvzColor(boolean isSelected) {
        if (this.isProvisional()) {
            return isSelected ? Design.IMPORTSENDING_PROV_COLOR_SELECTED : Design.IMPORTSENDING_PROV_COLOR;
        }
        if (this.isTotalDutyGreaterThan5()) {
            return isSelected ? Design.VVZ_COLOR_SELECTED : Design.VVZ_COLOR;
        }
        return null;
    }

    private boolean isTotalDutyGreaterThan5() {
        if (!this.getTotalDuty().isInitialized()) {
            return false;
        }
        return this.getTotalDuty().getValue() >= 5.0;
    }

    private Color getVvmColor(boolean isSelected) {
        if (this.isProvisional()) {
            return isSelected ? Design.IMPORTSENDING_PROV_COLOR_SELECTED : Design.IMPORTSENDING_PROV_COLOR;
        }
        return null;
    }

    private boolean isProvisional() {
        if (!this.getDeclarationType().isInitialized()) {
            return false;
        }
        return this.getDeclarationType().getValue() == 2L;
    }
}

