/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra;

import ch.transsoft.edec.model.infra.INodeFactory;
import ch.transsoft.edec.model.infra.IObjectReader;
import ch.transsoft.edec.model.infra.LoggingContext;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.infra.nodetypes.NodeTypes;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.ReflectionUtil;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReader
extends DefaultHandler {
    private Stack<State> states = new Stack();
    private INodeFactory factory = new NodeFactory();
    private LoggingContext context;

    public <T extends ModelNode<T>> T read(InputStream input, Class<T> type) throws Exception {
        return this.read(input, type, new LoggingContext());
    }

    public <T extends ModelNode<T>> T read(InputStream input, Class<T> type, LoggingContext context) throws Exception {
        this.context = context;
        try {
            ModelNode result = (ModelNode)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result.setMandatory(true);
            this.states.push(new InitialState(result));
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(input, (DefaultHandler)this);
            ModelNode modelNode = result;
            return (T)modelNode;
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not read file data type '" + type.getSimpleName() + "': " + String.valueOf(e2));
        }
        finally {
            FileUtil.close(input);
            this.states = null;
            this.factory = null;
            this.context = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String data = new String(ch, start, length);
        this.getState().characters(data);
    }

    private State getState() {
        return this.states.peek();
    }

    @Override
    public void endElement(String uri, String localName, String name) {
        this.getState().endElement(name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) {
        this.getState().startElement(name, attributes);
    }

    private void safeAddMissingElements(ModelNode<?> obj) {
        try {
            this.addMissingElements(obj);
        }
        catch (Exception e2) {
            Check.fail(e2);
        }
    }

    private void addMissingElements(ModelNode<?> obj) throws Exception {
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || field.get(obj) != null) continue;
            this.factory.addField(obj, field);
        }
    }

    private void readEnablement(NodeBase<?> node, Attributes attributes) {
        if (node.isMandatory()) {
            return;
        }
        String enabledStr = attributes.getValue("enabled");
        node.setEnabled(Boolean.parseBoolean(enabledStr));
    }

    private class InitialState
    implements State {
        private final ModelNode<?> obj;

        public InitialState(ModelNode<?> obj) {
            this.obj = obj;
        }

        @Override
        public void characters(String str) {
        }

        @Override
        public void endElement(String name) {
            Check.equals(this.obj.getClass().getSimpleName(), name);
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            Check.equals(this.obj.getClass().getSimpleName(), name);
            XMLReader.this.states.push(new ObjectReaderState(this.obj, attributes));
        }
    }

    private static interface State {
        public void characters(String var1);

        public void endElement(String var1);

        public void startElement(String var1, Attributes var2);
    }

    private abstract class StateBase
    implements State {
        protected ModelNode<?> parent;
        protected Field field;
        private final StringBuilder text = new StringBuilder();

        public StateBase(ModelNode<?> parent, Field field) {
            this.parent = parent;
            this.field = field;
        }

        @Override
        public final void characters(String str) {
            this.text.append(str);
        }

        protected abstract void handleCharacters(String var1) throws Exception;

        @Override
        public final void endElement(String name) {
            String str = this.text.toString();
            if (!str.isEmpty()) {
                try {
                    this.handleCharacters(str);
                }
                catch (Exception e2) {
                    Check.fail(e2);
                }
            }
            XMLReader.this.states.pop();
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            Check.illegalState();
        }
    }

    public class UnknownTagState
    implements State {
        private int nestingLevel = 0;

        @Override
        public void characters(String str) {
        }

        @Override
        public void endElement(String name) {
            if (this.nestingLevel == 0) {
                XMLReader.this.states.pop();
            }
            --this.nestingLevel;
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            ++this.nestingLevel;
        }
    }

    private class ListReaderState<T extends ListEntry<T>>
    implements State {
        private final ListNode<T> list;
        private final Class<T> type;

        public ListReaderState(ModelNode<?> parent, Field field, Attributes attributes) {
            this.list = XMLReader.this.factory.createList(parent, field);
            this.type = this.list.getType();
            try {
                field.set(parent, this.list);
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            XMLReader.this.readEnablement(this.list, attributes);
        }

        @Override
        public void characters(String str) {
        }

        @Override
        public void endElement(String name) {
            XMLReader.this.states.pop();
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            ListEntry child;
            try {
                child = (ListEntry)XMLReader.this.factory.createObject(this.type);
                child.setMandatory(true);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            this.list.add(child);
            XMLReader.this.states.push(new ObjectReaderState(child, attributes));
        }
    }

    private class SelectionReaderState
    extends StateBase {
        public SelectionReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createSelection(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class StringPrimitiveReaderState
    extends StateBase {
        public StringPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createStringPrimitive(str, this.field));
        }
    }

    private class TimestampPrimitiveReaderState
    extends StateBase {
        public TimestampPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createTimestampPrimitive(str, this.field));
        }
    }

    private class LongPrimitiveReaderState
    extends StateBase {
        public LongPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createLongPrimitive(str, this.field));
        }
    }

    private class DoublePrimitiveReaderState
    extends StateBase {
        public DoublePrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createDoublePrimitive(str, this.field));
        }
    }

    private class IntegerPrimitiveReaderState
    extends StateBase {
        public IntegerPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createIntegerPrimitive(str, this.field));
        }
    }

    private class BooleanPrimitiveReaderState
    extends StateBase {
        public BooleanPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createBooleanPrimitive(str, this.field));
        }
    }

    private class EnumPrimitiveReaderState
    extends StateBase {
        public EnumPrimitiveReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createEnumPrimitive(str, this.field, this.parent));
        }
    }

    private class EnumReaderState
    extends StateBase {
        public EnumReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createEnum(str, this.field, this.parent));
        }
    }

    private class FileReaderState
    extends StateBase {
        public FileReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createFile(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class TimestampReaderState
    extends StateBase {
        public TimestampReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createTimestamp(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class EdecDateReaderState
    extends StateBase {
        public EdecDateReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createEdecDate(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class DateReaderState
    extends StateBase {
        public DateReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createDate(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class DecimalReaderState
    extends StateBase {
        public DecimalReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createDecimal(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class BooleanReaderState
    extends StateBase {
        public BooleanReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createBoolean(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class IntegerReaderState
    extends StateBase {
        public IntegerReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createInteger(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class BinaryReaderState
    extends StateBase {
        public BinaryReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            String trimmed2 = str.trim();
            this.field.set(this.parent, XMLReader.this.factory.createBinary(XMLReader.this.context, this.parent, trimmed2, this.field));
        }
    }

    private class StringReaderState
    extends StateBase {
        public StringReaderState(ModelNode<?> parent, Field field) {
            super(parent, field);
        }

        @Override
        public void handleCharacters(String str) throws Exception {
            this.field.set(this.parent, XMLReader.this.factory.createString(XMLReader.this.context, this.parent, str, this.field));
        }
    }

    private class ObjectReaderState
    implements State,
    IObjectReader {
        final ModelNode<?> obj;

        public ObjectReaderState(ModelNode<?> obj, Attributes attributes) {
            this.obj = obj;
            XMLReader.this.readEnablement(obj, attributes);
        }

        @Override
        public void characters(String str) {
        }

        @Override
        public void endElement(String name) {
            XMLReader.this.safeAddMissingElements(this.obj);
            XMLReader.this.states.pop();
            this.obj.postConstructionNotification();
        }

        @Override
        public void startElement(String name, Attributes attributes) {
            try {
                Field field = this.obj.getClass().getDeclaredField(name);
                if (Modifier.isTransient(field.getModifiers())) {
                    this.unknownTag("Field is transient in domain model: " + this.obj.getClass().getName() + "." + field.getName());
                    return;
                }
                field.setAccessible(true);
                NodeTypes.getType(field.getType()).handleRead(this, field, attributes);
            }
            catch (NoSuchFieldException e2) {
                this.unknownTag("Unknown field '" + name + "' in " + this.obj.getPath());
            }
            catch (Exception e3) {
                throw new RuntimeException("failed reading '" + name + "' on " + this.obj.getPath(), e3);
            }
        }

        private void unknownTag(String msg) {
            XMLReader.this.context.log(msg);
            XMLReader.this.states.push(new UnknownTagState());
        }

        @Override
        public void handleString(Field field) {
            XMLReader.this.states.push(new StringReaderState(this.obj, field));
        }

        @Override
        public void handleBinary(Field field) {
            XMLReader.this.states.push(new BinaryReaderState(this.obj, field));
        }

        @Override
        public void handleInteger(Field field) {
            XMLReader.this.states.push(new IntegerReaderState(this.obj, field));
        }

        @Override
        public void handleBoolean(Field field) {
            XMLReader.this.states.push(new BooleanReaderState(this.obj, field));
        }

        @Override
        public void handleDecimal(Field field) {
            XMLReader.this.states.push(new DecimalReaderState(this.obj, field));
        }

        @Override
        public void handleList(Field field, Attributes attributes) {
            XMLReader.this.states.push(new ListReaderState(this.obj, field, attributes));
        }

        @Override
        public void handleObject(Field field, Attributes attributes) throws Exception {
            Object child = XMLReader.this.factory.createObject(this.obj, field);
            field.set(this.obj, child);
            XMLReader.this.states.push(new ObjectReaderState((ModelNode<?>)child, attributes));
        }

        @Override
        public void handleEnum(Field field) {
            XMLReader.this.states.push(new EnumReaderState(this.obj, field));
        }

        @Override
        public void handleSelection(Field field) {
            XMLReader.this.states.push(new SelectionReaderState(this.obj, field));
        }

        @Override
        public void handleDate(Field field) {
            XMLReader.this.states.push(new DateReaderState(this.obj, field));
        }

        @Override
        public void handleEdecDate(Field field) {
            XMLReader.this.states.push(new EdecDateReaderState(this.obj, field));
        }

        @Override
        public void handleTimestamp(Field field) {
            XMLReader.this.states.push(new TimestampReaderState(this.obj, field));
        }

        @Override
        public void handleFile(Field field) {
            XMLReader.this.states.push(new FileReaderState(this.obj, field));
        }

        @Override
        public void handleEnumPrimitive(Field field) {
            XMLReader.this.states.push(new EnumPrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleBooleanPrimitive(Field field) {
            XMLReader.this.states.push(new BooleanPrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleIntegerPrimitive(Field field) {
            XMLReader.this.states.push(new IntegerPrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleDoublePrimitive(Field field) {
            XMLReader.this.states.push(new DoublePrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleTimestampPrimitive(Field field) {
            XMLReader.this.states.push(new TimestampPrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleStringPrimitive(Field field) {
            XMLReader.this.states.push(new StringPrimitiveReaderState(this.obj, field));
        }

        @Override
        public void handleLongPrimitive(Field field) {
            XMLReader.this.states.push(new LongPrimitiveReaderState(this.obj, field));
        }
    }
}

