/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.indexhandling;

import ch.transsoft.edec.model.infra.indexhandling.IndexEntryBase;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.RootNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import java.util.Iterator;

public abstract class IndexBase<E extends IndexBase<E, T>, T extends IndexEntryBase<T>>
extends ModelNode<E>
implements RootNode<E> {
    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public abstract ListNode<T> getEntryList();

    public void updateIndexEntry(T newEntry) {
        T entry = this.findEntry(((IndexEntryBase)newEntry).getId());
        if (entry != null) {
            ((ModelNode)entry).apply(newEntry);
        } else {
            this.addEntry(newEntry);
        }
    }

    public void addEntry(T newEntry) {
        this.getEntryList().add((IndexEntryBase)((ModelNode)newEntry).getCopy(this.getEntryList()));
    }

    private T findEntry(Object id) {
        for (IndexEntryBase current : this.getEntryList()) {
            if (!current.getId().equals(id)) continue;
            return (T)current;
        }
        return null;
    }

    public void removeIndexEntry(T indexEntry) {
        Object id = ((IndexEntryBase)indexEntry).getId();
        Iterator<T> iter = this.getEntryList().iterator();
        while (iter.hasNext()) {
            if (!((IndexEntryBase)iter.next()).getId().equals(id)) continue;
            iter.remove();
            return;
        }
    }
}

