/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.StringNodeBase;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public abstract class ModelNode<T extends ModelNode<T>>
extends NodeBase<T> {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Pattern LIST_QUALIFIER = Pattern.compile("(.*)\\[(\\d*)]");

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printObj(node, this, tagName);
    }

    public IntegralNode findIntegral(String xpath) {
        return (IntegralNode)this.find(xpath);
    }

    public StringNodeBase<?> findString(String xpath) {
        return (StringNodeBase)this.find(xpath);
    }

    public INode<?> find(String xpath) {
        Check.assertNotNull(xpath);
        Check.assertFalse(xpath.isEmpty(), "empty path");
        String[] path = xpath.split("/");
        return this.find(path, 0);
    }

    public List<INode<?>> findAll(String xpath) {
        Check.assertNotNull(xpath);
        if (xpath.isEmpty()) {
            return new ArrayList();
        }
        String[] path = xpath.split("/");
        ArrayList result = new ArrayList();
        this.findAll(path, 0, result);
        return result;
    }

    public void findAll(String[] path, int index, ArrayList<INode<?>> result) {
        INode<?> match = ReflectionUtil.getField(this, path[index]);
        this.findNextAll(path, index, match, result);
    }

    private void findNextAll(String[] path, int index, INode<?> match, ArrayList<INode<?>> result) {
        if (index == path.length - 1) {
            result.add(match);
            return;
        }
        if (match instanceof ListNode) {
            for (ListEntry current : (ListNode)match) {
                current.findAll(path, index + 1, result);
            }
            return;
        }
        ((ModelNode)match).findAll(path, index + 1, result);
    }

    private INode<?> find(String[] path, int index) {
        Matcher matcher = LIST_QUALIFIER.matcher(path[index]);
        if (matcher.matches()) {
            return this.findListElement(path, index, matcher.group(1), Integer.parseInt(matcher.group(2)));
        }
        INode<?> match = ReflectionUtil.getField(this, path[index]);
        return this.findNext(path, index, match);
    }

    private INode<?> findNext(String[] path, int index, INode<?> match) {
        if (index == path.length - 1) {
            return match;
        }
        return ((ModelNode)match).find(path, index + 1);
    }

    private INode<?> findListElement(String[] path, int index, String fieldName, int pos) {
        ListNode list = (ListNode)ReflectionUtil.getField(this, fieldName);
        if (pos >= list.size()) {
            return null;
        }
        if (index == path.length - 1) {
            return list.get(pos);
        }
        return this.findNext(path, index, (INode<?>)list.get(pos));
    }

    @Override
    public T getCopy(ModelNode<?> parent) {
        T result = this.createInstance();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field)) continue;
            this.setCopyOfField(result, field);
        }
        this.completeCopy((NodeBase<?>)result, parent);
        ((NodeBase)result).postConstructionNotification();
        return result;
    }

    private void setCopyOfField(T obj, Field field) {
        try {
            field.set(obj, this.getNode(field, this).getCopy((ModelNode<?>)obj));
        }
        catch (Exception e2) {
            Check.fail(e2, "Failed to copy field " + String.valueOf(field));
        }
    }

    private T createInstance() {
        try {
            Class<?> aClass = this.getClass();
            return (T)((ModelNode)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    @Override
    public void apply(T other) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || !INode.class.isAssignableFrom(field.getType())) continue;
            this.getNode(field, this).apply(this.getNode(field, (ModelNode<?>)other));
        }
    }

    @Override
    public boolean isEquals(T other) {
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || !INode.class.isAssignableFrom(field.getType()) || this.getNode(field, (ModelNode<?>)other).isEquals(this.getNode(field, this))) continue;
            return false;
        }
        return this.isEnabled() == ((NodeBase)other).isEnabled();
    }

    @Override
    public void traverse(ITraversal traversal) {
        if (!traversal.visitChildren(this)) {
            return;
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || !INode.class.isAssignableFrom(field.getType())) continue;
            this.getNode(field, this).traverse(traversal);
        }
    }

    private <E extends INode<E>> E getNode(Field field, ModelNode<?> parent) {
        if (!INode.class.isAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("Field must be of type INode.");
        }
        try {
            INode result = (INode)field.get(parent);
            return (E)result;
        }
        catch (Exception e2) {
            throw Check.fail(e2);
        }
    }

    @Override
    public void cumulate(T other) {
        if (((NodeBase)other).isEnabled()) {
            this.setEnabled(((NodeBase)other).isEnabled());
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || !INode.class.isAssignableFrom(field.getType())) continue;
            this.getNode(field, this).cumulate(this.getNode(field, (ModelNode<?>)other));
        }
    }

    @Override
    public void inject(T other, InjectionSpec spec) {
        if (spec.useUninitialized() || ((NodeBase)other).isEnabled()) {
            this.setEnabled(((NodeBase)other).isEnabled());
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field) || !INode.class.isAssignableFrom(field.getType())) continue;
            this.getNode(field, this).inject(this.getNode(field, (ModelNode<?>)other), spec);
        }
    }
}

