/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node;

import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.util.ReflectionUtil;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableAdapter
implements ITableAdapter {
    private final String fieldName;
    private final int colName;
    private final Class<?> colType;
    private final Integer maxWidth;
    private final Class<? extends TableCellEditor> cellEditor;
    private final Class<? extends TableCellRenderer> cellRenderer;
    private final boolean editable;

    public TableAdapter(String fieldName, int colName, Class<?> colType, boolean editable) {
        this(fieldName, colName, colType, null, null, null, editable);
    }

    public TableAdapter(String fieldName, int colName, Class<?> colType) {
        this(fieldName, colName, colType, null, null, null, true);
    }

    public TableAdapter(String fieldName, int colName, Class<?> colType, Integer maxWidth) {
        this(fieldName, colName, colType, maxWidth, true);
    }

    public TableAdapter(String fieldName, int colName, Class<?> colType, Integer maxWidth, boolean editable) {
        this(fieldName, colName, colType, maxWidth, null, null, editable);
    }

    public TableAdapter(String fieldName, int colName, Class<?> colType, Class<? extends TableCellEditor> cellEditor, Class<? extends TableCellRenderer> cellRenderer) {
        this(fieldName, colName, colType, null, cellEditor, cellRenderer, true);
    }

    public TableAdapter(String fieldName, int colName, Class<?> colType, Integer maxWidth, Class<? extends TableCellEditor> cellEditor, Class<? extends TableCellRenderer> cellRenderer, boolean editable) {
        this.fieldName = fieldName;
        this.colName = colName;
        this.colType = colType;
        this.maxWidth = maxWidth;
        this.cellEditor = cellEditor;
        this.cellRenderer = cellRenderer;
        this.editable = editable;
    }

    @Override
    public String getColName() {
        return Services.getText(this.colName);
    }

    @Override
    public Class<?> getColType() {
        return this.colType;
    }

    @Override
    public Integer getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public INode<?> getValue(ModelNode<?> parent) {
        String[] path = this.fieldName.split("\\.");
        INode<?> current = parent;
        for (String seg : path) {
            current = ReflectionUtil.getField(current, seg);
        }
        return current;
    }

    @Override
    public Class<? extends TableCellEditor> getCellEditor() {
        return this.cellEditor;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public Class<? extends TableCellRenderer> getCellRenderer() {
        return this.cellRenderer;
    }
}

