/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.infra.node.list;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.node.INode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.NodeBase;
import ch.transsoft.edec.model.infra.node.list.ListElementAdded;
import ch.transsoft.edec.model.infra.node.list.ListElementMoved;
import ch.transsoft.edec.model.infra.node.list.ListElementRemoved;
import ch.transsoft.edec.util.Check;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

public final class ListNode<T extends ListEntry<T>>
extends ModelNode<ListNode<T>>
implements Iterable<T> {
    private List<T> list = new ArrayList<T>();
    private final Class<T> type;
    private Integer maxLength;

    public ListNode(Class<T> type, Integer maxLength) {
        this.type = type;
        this.maxLength = maxLength;
    }

    public ListNode(Class<T> type) {
        this.type = type;
    }

    public ListNode(List<T> list, Class<T> type) {
        this.list = list;
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void add(T element) {
        this.add(this.list.size(), element);
    }

    public void add(int index, T element) {
        ((NodeBase)element).setParent(this);
        this.list.add(index, element);
        this.fireEvent(new ListElementAdded(index, (INode<?>)element));
    }

    public void remove(T obj) {
        int index = this.list.indexOf(obj);
        Check.assertTrue(this.list.remove(obj), new Object[0]);
        ((NodeBase)obj).setParent(null);
        this.fireEvent(new ListElementRemoved(index));
        this.removeError((INode<?>)obj);
    }

    private void removeError(INode<?> node) {
        if (node.getErrorInfo().hasError()) {
            this.decrementErrorCount(node.getErrorInfo().getErrorCount());
        }
    }

    public T remove(int row) {
        ListEntry result = (ListEntry)this.list.remove(row);
        result.setParent(null);
        this.fireEvent(new ListElementRemoved(row));
        this.removeError(result);
        return (T)result;
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        writer.printList(node, this, tagName);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public T get(int pos) {
        return (T)((ListEntry)this.list.get(pos));
    }

    public String toString() {
        return this.list.toString();
    }

    public int size() {
        return this.list.size();
    }

    public int indexOf(T t) {
        return this.list.indexOf(t);
    }

    @Override
    public ListNode<T> getCopy(ModelNode<?> parent) {
        ListNode<ListEntry> result = new ListNode<ListEntry>(this.getType());
        this.completeCopy(result, parent);
        for (ListEntry child : this.list) {
            result.add((ListEntry)child.getCopy(result));
        }
        result.maxLength = this.maxLength;
        return result;
    }

    @Override
    public void apply(ListNode<T> other) {
    }

    @Override
    public boolean isEquals(ListNode<T> other) {
        throw Check.fail("equals() is not supported for ListNodes");
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
        for (ListEntry t : this.list) {
            t.traverse(traversal);
        }
    }

    public String getPath(ListEntry<? extends T> child) {
        if (this.getParent() == null) {
            return this.getFieldName();
        }
        String parentPath = this.getParent().getPath();
        if (parentPath == null) {
            return this.getFieldName(child);
        }
        return this.getParent().getPath() + "/" + this.getFieldName(child);
    }

    private String getFieldName(ListEntry<? extends T> child) {
        return this.getFieldName() + "[" + this.list.indexOf(child) + "]";
    }

    public T getLastItem() {
        Check.assertFalse(this.isEmpty(), "getLastItem not possible on empty list");
        return (T)((ListEntry)this.list.get(this.list.size() - 1));
    }

    @Override
    public void inject(ListNode<T> other, InjectionSpec spec) {
        if (spec.useUninitialized() || other.isEnabled()) {
            this.setEnabled(other.isEnabled());
        }
        for (ListEntry element : other) {
            ListEntry copy = (ListEntry)element.getCopy((ModelNode)null);
            spec.repair(this, copy, element);
            this.add(copy);
        }
    }

    public void clear() {
        this.list.clear();
    }

    public void moveDown(T selected) {
        if (this.list.size() < 2) {
            return;
        }
        int index = this.list.indexOf(selected);
        Check.assertTrue(index != -1, "element to move not in list " + String.valueOf(selected));
        this.list.remove(index);
        this.list.add(index + 1, selected);
        this.fireEvent(new ListElementMoved((ListEntry<?>)selected, index, index + 1));
    }

    public void moveUp(T selected) {
        if (this.list.size() < 2) {
            return;
        }
        int index = this.list.indexOf(selected);
        Check.assertTrue(index != -1, "element to move not in list " + String.valueOf(selected));
        this.list.remove(index);
        this.list.add(index - 1, selected);
        this.fireEvent(new ListElementMoved((ListEntry<?>)selected, index, index - 1));
    }

    @Override
    public void cumulate(ListNode<T> other) {
        for (ListEntry element : other) {
            this.add(element);
        }
    }

    public boolean validateSizeConstraint() {
        if (this.maxLength == null) {
            return true;
        }
        return this.list.size() <= this.maxLength;
    }

    public String getMaxElementsString() {
        return this.maxLength == null ? "undefined" : this.maxLength.toString();
    }
}

