/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending;

import ch.transsoft.edec.model.infra.ITraversal;
import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.InjectionSpec;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.sending.ALState;
import ch.transsoft.edec.model.sending.AzaStatusCodes;
import ch.transsoft.edec.model.sending.EVVState;
import ch.transsoft.edec.model.sending.EvvValidationState;
import ch.transsoft.edec.model.sending.InternalState;
import ch.transsoft.edec.model.sending.OperatingMode;
import java.lang.reflect.Field;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class State
extends ModelNode<State> {
    private ALState alState;
    private InternalState internalState;
    private EVVState evvState;
    private OperatingMode operatingMode;
    private Boolean avisMailed;
    private Boolean evvMailed;
    private EvvValidationState evvValidationState;
    private Integer status;

    @Override
    public State getCopy(ModelNode<?> parent) {
        State result = new State();
        result.alState = this.alState;
        result.internalState = this.internalState;
        result.evvState = this.evvState;
        result.operatingMode = this.operatingMode;
        result.avisMailed = this.avisMailed;
        result.evvMailed = this.evvMailed;
        result.evvValidationState = this.evvValidationState;
        result.status = this.status;
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public void apply(State other) {
        this.alState = other.alState;
        this.internalState = other.internalState;
        this.evvState = other.evvState;
        this.operatingMode = other.operatingMode;
        this.avisMailed = other.avisMailed;
        this.evvMailed = other.evvMailed;
        this.evvValidationState = other.evvValidationState;
        this.status = other.status;
    }

    @Override
    public void inject(State other, InjectionSpec spec) {
    }

    @Override
    public void traverse(ITraversal traversal) {
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        Element element = writer.printModelNode(node, this, tagName);
        this.printAllFields(element, writer);
    }

    private void printAllFields(Element element, IXMLWriter writer) throws Exception {
        for (Field field : this.getClass().getDeclaredFields()) {
            Object obj = field.get(this);
            if (obj == null) {
                return;
            }
            writer.printPrimitive((Node)element, obj, field.getName());
        }
    }

    public void toggleInternalState() {
        boolean undefined = this.internalState == InternalState.undefined;
        InternalState newValue = undefined ? InternalState.complete : InternalState.undefined;
        this.setInternalState(newValue);
    }

    public boolean isProduction() {
        return this.getOperatingMode() == OperatingMode.production;
    }

    public ALState getAlState() {
        return this.alState;
    }

    public void setAlState(ALState alState) {
        this.alState = alState;
        this.fireEvent();
    }

    public InternalState getInternalState() {
        return this.internalState;
    }

    public void setInternalState(InternalState internalState) {
        this.internalState = internalState;
        this.fireEvent();
    }

    public EVVState getEvvState() {
        return this.evvState;
    }

    public void setEvvState(EVVState evvState) {
        this.evvState = evvState;
        this.fireEvent();
    }

    public OperatingMode getOperatingMode() {
        return this.operatingMode;
    }

    public void setOperatingMode(OperatingMode operatingMode) {
        this.operatingMode = operatingMode;
        this.fireEvent();
    }

    public boolean isAvisMailed() {
        return this.avisMailed;
    }

    public void setAvisMailed(boolean avisMailed) {
        this.avisMailed = avisMailed;
        this.fireEvent();
    }

    public boolean isEvvMailed() {
        return this.evvMailed;
    }

    public void setEvvMailed(boolean evvMailed) {
        this.evvMailed = evvMailed;
        this.fireEvent();
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isSelectedState() {
        return AzaStatusCodes.isSelected(this.status);
    }

    public void setStatus(int status) {
        this.status = status;
        this.fireEvent();
    }

    public void clearStatus() {
        this.status = 0;
        this.fireEvent();
    }

    public boolean hasAl() {
        return this.alState == ALState.complete;
    }

    public boolean hasEvv() {
        return this.evvState == EVVState.complete;
    }

    public void setAlComplete() {
        this.alState = ALState.complete;
        this.fireEvent();
    }

    public void evvReceived() {
        this.evvState = EVVState.complete;
    }

    public EvvValidationState getEvvValidationState() {
        return this.evvValidationState;
    }

    public void setEvvValid(boolean evvValid) {
        this.evvValidationState = evvValid ? EvvValidationState.valid : EvvValidationState.invalid;
    }
}

