/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.goodsdeclaration;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.IAddress;
import ch.transsoft.edec.model.infra.annotation.domainRef;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;

public final class Address
extends ListEntry<Address>
implements IAddress {
    public static ITableAdapter[] tableConfig = new ITableAdapter[]{new TableAdapter("id", 512, StringNode.class), new TableAdapter("name", 500, StringNode.class), new TableAdapter("street", 501, StringNode.class), new TableAdapter("postalCode", 508, StringNode.class), new TableAdapter("city", 509, StringNode.class), new TableAdapter("country", 504, SelectionNode.class)};
    @maxlen(value=17)
    private StringNode id;
    @maxlen(value=35)
    @mandatory
    private StringNode name;
    @maxlen(value=35)
    @mandatory
    private StringNode street;
    @maxlen(value=35)
    private StringNode addressSupplement1;
    @maxlen(value=35)
    private StringNode addressSupplement2;
    @maxlen(value=9)
    @mandatory
    private StringNode postalCode;
    @maxlen(value=35)
    @mandatory
    private StringNode city;
    @domainRef(value=Domain.isoCode, allowEmpty=true)
    @mandatory
    private SelectionNode country;
    @maxlen(value=20)
    private StringNode vatNumber;
    @maxlen(value=27)
    private StringNode eoriNumber;
    private StringNode salutation;
    @maxlen(value=50)
    private StringNode contact;
    @maxlen(value=50)
    private StringNode phone;
    @maxlen(value=200)
    private StringNode email;

    public StringNode getId() {
        return this.id;
    }

    public StringNode getName() {
        return this.name;
    }

    public StringNode getStreet() {
        return this.street;
    }

    public StringNode getAddressSupplement1() {
        return this.addressSupplement1;
    }

    public StringNode getAddressSupplement2() {
        return this.addressSupplement2;
    }

    public StringNode getPostalCode() {
        return this.postalCode;
    }

    public StringNode getCity() {
        return this.city;
    }

    public SelectionNode getCountry() {
        return this.country;
    }

    public StringNode getVatNumber() {
        return this.vatNumber;
    }

    public StringNode getEoriNumber() {
        return this.eoriNumber;
    }

    public StringNode getEmail() {
        return this.email;
    }

    public String getZipAndCity() {
        return this.getPostalCode().getValue() + " " + this.getCity().getValue();
    }

    public StringNode getSalutation() {
        return this.salutation;
    }

    public StringNode getContact() {
        return this.contact;
    }

    public StringNode getPhone() {
        return this.phone;
    }

    @Override
    public String getPhoneAndEmail() {
        return this.getPhone().isInitialized() ? this.getPhone().getValue() + "  " + this.getEmail().getValue() : this.getEmail().getValue();
    }

    @Override
    public AddressRenderer getAddress() {
        AddressRenderer result = new AddressRenderer();
        result.addLine(this.getName());
        result.addLine(this.getAddressSupplement1());
        result.addLine(this.getAddressSupplement2());
        result.addLine(this.getStreet());
        result.addCountryAndCity(this.getCountry(), this.getPostalCode(), this.getCity());
        return result;
    }
}

