/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.goodsdeclaration;

import ch.transsoft.edec.model.infra.AddressRenderer;
import ch.transsoft.edec.model.infra.IAddress;
import ch.transsoft.edec.model.infra.annotation.domainRef;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.annotation.trimmed;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.ui.pm.model.ISelectionFieldData;
import ch.transsoft.edec.util.DateUtil;

public final class Consignor
extends ListEntry<Consignor>
implements ISelectionFieldData,
IAddress {
    public static ITableAdapter[] tableConfig = new ITableAdapter[]{new TableAdapter("id", 512, StringNode.class), new TableAdapter("name", 500, StringNode.class), new TableAdapter("street", 501, StringNode.class), new TableAdapter("postalCode", 508, StringNode.class), new TableAdapter("city", 509, StringNode.class), new TableAdapter("country", 504, SelectionNode.class), new TableAdapter("vatNumber", 513, StringNode.class)};
    @maxlen(value=17)
    private StringNode id;
    @maxlen(value=35)
    @mandatory
    private StringNode name;
    @maxlen(value=35)
    @mandatory
    private StringNode street;
    @maxlen(value=35)
    private StringNode addressSupplement1;
    @maxlen(value=35)
    private StringNode addressSupplement2;
    @maxlen(value=9)
    @mandatory
    private StringNode postalCode;
    @maxlen(value=35)
    @mandatory
    private StringNode city;
    @mandatory
    @domainRef(value=Domain.isoCode, allowEmpty=true)
    private SelectionNode country;
    @maxlen(value=20)
    @mandatory
    @trimmed
    private StringNode vatNumber;
    @maxlen(value=50)
    private StringNode phone;
    @maxlen(value=50)
    private StringNode email;
    @maxlen(value=15)
    @mandatory
    @trimmed
    private StringNode tin;
    @maxlen(value=40)
    private StringNode authorizationNumber;

    public static ITableAdapter[] getTableConfig() {
        return tableConfig;
    }

    public StringNode getName() {
        return this.name;
    }

    public StringNode getStreet() {
        return this.street;
    }

    public StringNode getAddressSupplement1() {
        return this.addressSupplement1;
    }

    public StringNode getAddressSupplement2() {
        return this.addressSupplement2;
    }

    public StringNode getPostalCode() {
        return this.postalCode;
    }

    public StringNode getCity() {
        return this.city;
    }

    public SelectionNode getCountry() {
        return this.country;
    }

    public StringNode getVatNumber() {
        return this.vatNumber;
    }

    public StringNode getUid() {
        return this.tin;
    }

    public String toString() {
        return this.getName().getStringValue();
    }

    @Override
    public String getDesc() {
        if (!this.getName().isInitialized()) {
            return "";
        }
        String separator = ", ";
        StringBuilder result = new StringBuilder().append(this.getName().getStringValue()).append(separator);
        String addressSupplement1 = this.getAddressSupplement1().getStringValue();
        if (!addressSupplement1.isEmpty()) {
            result.append(addressSupplement1).append(separator);
        }
        result.append(this.getCity().getStringValue());
        return result.toString();
    }

    public StringNode getEmail() {
        return this.email;
    }

    public StringNode getPhone() {
        return this.phone;
    }

    public StringNode getId() {
        return this.id;
    }

    public StringNode getAuthorizationNumber() {
        return this.authorizationNumber;
    }

    @Override
    public String getKey() {
        return "";
    }

    public StringNode getZipAndCity() {
        if (this.getPostalCode().isInitialized() || this.getCity().isInitialized()) {
            return new StringNode(this.getPostalCode().getValue() + " " + this.getCity().getValue());
        }
        return new StringNode("");
    }

    public StringNode getPlaceAndDate() {
        return new StringNode(this.getCity().getValue() + ", " + DateUtil.getCurrentDateAsStr());
    }

    @Override
    public String getDesc(ITextService.Language language) {
        return this.getDesc();
    }

    @Override
    public String getPhoneAndEmail() {
        return this.getPhone().isInitialized() ? this.getPhone().getValue() + this.getEmail().getValue() : this.getEmail().getValue();
    }

    @Override
    public AddressRenderer getAddress() {
        AddressRenderer result = new AddressRenderer();
        result.addLine(this.getName());
        result.addLine(this.getAddressSupplement1());
        result.addLine(this.getAddressSupplement2());
        result.addLine(this.getStreet());
        result.addCountryAndCity(this.getCountry(), this.getPostalCode(), this.getCity());
        return result;
    }
}

