/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.goodsdeclaration;

import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.domainRef;
import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.goodsdeclaration.Address;
import ch.transsoft.edec.model.sending.goodsdeclaration.BondedWarehouse;
import ch.transsoft.edec.model.sending.goodsdeclaration.Business;
import ch.transsoft.edec.model.sending.goodsdeclaration.Carrier;
import ch.transsoft.edec.model.sending.goodsdeclaration.Consignor;
import ch.transsoft.edec.model.sending.goodsdeclaration.Container;
import ch.transsoft.edec.model.sending.goodsdeclaration.CustomerDeclarationNumberWithVersion;
import ch.transsoft.edec.model.sending.goodsdeclaration.Declarant;
import ch.transsoft.edec.model.sending.goodsdeclaration.SpecialMentionHeader;
import ch.transsoft.edec.model.sending.goodsdeclaration.TransportMeans;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;

public final class GoodsDeclaration
extends ModelNode<GoodsDeclaration> {
    private transient CustomerDeclarationNumberWithVersion customsDeclarationNumberWithVersion;
    @domainRef(value=Domain.serviceType)
    @mandatory
    @defaultValue(value="2")
    private SelectionNode serviceType;
    @mandatory
    @maxlen(value=22)
    private StringNode traderDeclarationNumber;
    @maxlen(value=30)
    private StringNode customsDeclarationNumber;
    private IntegralNode customsDeclarationVersion;
    private StringNode traderReference;
    @domainRef(value=Domain.clearanceLocation)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode clearanceLocation;
    @domainRef(value=Domain.notificationCode, allowEmpty=true)
    private SelectionNode customsOfficeNumber;
    @domainRef(value=Domain.declarationTime)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode declarationTime;
    @domainRef(value=Domain.declarationType)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode declarationType;
    @domainRef(value=Domain.correctionCode)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode correctionCode;
    @domainRef(value=Domain.correctionReason, allowEmpty=true)
    private SelectionNode correctionReason;
    @domainRef(value=Domain.isoCode, allowEmpty=true)
    @mandatory
    private SelectionNode deliveryDestination;
    @domainRef(value=Domain.yesNoCode)
    @mandatory
    @defaultValue(value="0")
    private SelectionNode transferToTransitSystem;
    @mandatory
    private TransportMeans transportMeans;
    @listType(value=Container.class)
    @maxlen(value=99)
    private ListNode<Container> containers;
    private BondedWarehouse bondedWarehouse;
    @listType(value=SpecialMentionHeader.class)
    @maxlen(value=99)
    @mandatory
    private ListNode<SpecialMentionHeader> specialMentions;
    @mandatory
    private Consignor consignor;
    @mandatory
    private Address consignee;
    private Address delivery;
    @mandatory
    private Declarant declarant;
    @mandatory
    private Carrier carrier;
    @mandatory
    private Business business;
    @defaultValue(value="CHF")
    @mandatory
    private StringNode defaultCurrency;
    @maxlen(value=42)
    private StringNode defaultPackagingReferenceNumber;
    @maxlen(value=10000)
    private StringNode internalComment;

    @Override
    public void postConstructionNotification() {
        this.addFieldListener("customsDeclarationNumber", (source, info) -> this.updateCustomerDeclarationNumberWithVersion());
        this.addFieldListener("customsDeclarationVersion", (source, info) -> this.updateCustomerDeclarationNumberWithVersion());
        this.addFieldListener("correctionCode", (source, info) -> {
            SelectionNode correctionCode = (SelectionNode)source;
            if (correctionCode.asInt() == 2) {
                this.getCorrectionReason().setValue("1");
            }
        });
    }

    private void updateCustomerDeclarationNumberWithVersion() {
        this.getCustomsDeclarationNumberWithVersion().fireEvent();
    }

    public StringNode getInternalComment() {
        return this.internalComment;
    }

    public SelectionNode getServiceType() {
        return this.serviceType;
    }

    public StringNode getTraderDeclarationNumber() {
        return this.traderDeclarationNumber;
    }

    public StringNode getTraderReference() {
        return this.traderReference;
    }

    public SelectionNode getClearanceLocation() {
        return this.clearanceLocation;
    }

    public SelectionNode getCustomsOfficeNumber() {
        return this.customsOfficeNumber;
    }

    public SelectionNode getDeclarationTime() {
        return this.declarationTime;
    }

    public SelectionNode getDeclarationType() {
        return this.declarationType;
    }

    public SelectionNode getCorrectionCode() {
        return this.correctionCode;
    }

    public SelectionNode getCorrectionReason() {
        return this.correctionReason;
    }

    public SelectionNode getDeliveryDestination() {
        return this.deliveryDestination;
    }

    public TransportMeans getTransportMeans() {
        return this.transportMeans;
    }

    public ListNode<Container> getContainers() {
        return this.containers;
    }

    public BondedWarehouse getBondedWarehouse() {
        return this.bondedWarehouse;
    }

    public ListNode<SpecialMentionHeader> getSpecialMentions() {
        return this.specialMentions;
    }

    public Consignor getConsignor() {
        return this.consignor;
    }

    public Address getConsignee() {
        return this.consignee;
    }

    public Declarant getDeclarant() {
        return this.declarant;
    }

    public Carrier getCarrier() {
        return this.carrier;
    }

    public Business getBusiness() {
        return this.business;
    }

    public Address getDelivery() {
        return this.delivery;
    }

    public StringNode getCustomsDeclarationNumber() {
        return this.customsDeclarationNumber;
    }

    public IntegralNode getCustomsDeclarationVersion() {
        return this.customsDeclarationVersion;
    }

    public CustomerDeclarationNumberWithVersion getCustomsDeclarationNumberWithVersion() {
        if (this.customsDeclarationNumberWithVersion == null) {
            this.customsDeclarationNumberWithVersion = new CustomerDeclarationNumberWithVersion(this, this.getCustomsDeclarationNumber(), this.getCustomsDeclarationVersion());
        }
        return this.customsDeclarationNumberWithVersion;
    }

    public StringNode getDefaultCurrency() {
        return this.defaultCurrency;
    }

    public StringNode getDefaultPackagingReferenceNumber() {
        return this.defaultPackagingReferenceNumber;
    }

    public void cleanDeclarant() {
        this.declarant = NodeFactory.create(Declarant.class);
    }

    public String getTraderReferenceFirst35Chars() {
        String result = this.getTraderReference().getValue();
        if (result.length() <= 35) {
            return result;
        }
        return result.substring(0, 35);
    }

    public SelectionNode getTransferToTransitSystem() {
        return this.transferToTransitSystem;
    }
}

