/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.itemlist.goodsitem;

import ch.transsoft.edec.model.infra.annotation.decimalSpec;
import ch.transsoft.edec.model.infra.annotation.defaultValue;
import ch.transsoft.edec.model.infra.annotation.domainRef;
import ch.transsoft.edec.model.infra.annotation.integralSpec;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.annotation.validator;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.model.sending.itemlist.CompactKey;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.CommodityCodeValidator;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItem;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.StatisticalValueCHF;
import ch.transsoft.edec.service.masterdataezv.DomainValue;
import ch.transsoft.edec.service.masterdataezv.internal.Domain;

public final class GoodsData
extends ModelNode<GoodsData> {
    public static final String BEIGEPACKT_KEY = "--";
    public static final DomainValue BEIPACK = new DomainValue("--", "Beigepackt", "Joint", "", "Enclosed", false);
    private transient StatisticalValueCHF statisticalValueChf;
    @mandatory
    @maxlen(value=5)
    private IntegralNode traderItemID;
    @maxlen(value=280)
    @mandatory
    private StringNode descriptionShort;
    @maxlen(value=280)
    private StringNode descriptionEn;
    @domainRef(value=Domain.isoCodeWithCE, allowEmpty=true)
    private SelectionNode origin;
    @mandatory
    @defaultValue(value="true")
    private BooleanNode inEur;
    @maxlen(value=14)
    private StringNode eurInvoices;
    @maxlen(value=1)
    private StringNode bgLetter;
    @maxlen(value=10)
    @validator(value=CommodityCodeValidator.class)
    @mandatory
    private StringNode commodityCode;
    @integralSpec(digits=3)
    private IntegralNode statisticalCode;
    @decimalSpec(fractionDigits=3, totalDigits=12)
    @mandatory
    private DecimalNode grossMass;
    @decimalSpec(fractionDigits=3, totalDigits=12)
    private DecimalNode netMass;
    @domainRef(value=Domain.customsClearanceType)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode customsClearanceType;
    @domainRef(value=Domain.commercialGood)
    @mandatory
    @defaultValue(value="1")
    private SelectionNode commercialGood;
    @decimalSpec(totalDigits=12, fractionDigits=2)
    @mandatory
    private DecimalNode statisticalValue;
    @mandatory
    private StringNode currency;
    @decimalSpec(totalDigits=6, fractionDigits=5)
    @mandatory
    private DecimalNode currencyRate;
    @domainRef(value=Domain.packagingType, allowEmpty=true)
    @mandatory
    private SelectionNode packagingType;
    @integralSpec(digits=5)
    private IntegralNode quantity;
    @mandatory
    @defaultValue(value="1")
    @domainRef(value=Domain.grossupType)
    private SelectionNode grossupType;
    @maxlen(value=42)
    private StringNode packagingReferenceNumber;
    @decimalSpec(fractionDigits=1, totalDigits=10)
    private DecimalNode additionalUnit;
    @domainRef(value=Domain.refundType, allowEmpty=true)
    private SelectionNode refundType;
    @decimalSpec(fractionDigits=3, totalDigits=12)
    private DecimalNode VOCQuantity;

    @Override
    public void postConstructionNotification() {
        this.addFieldListener("statisticalValue", (source, info) -> this.updateStatisticalValueChf());
        this.addFieldListener("currencyRate", (source, info) -> this.updateStatisticalValueChf());
    }

    private void updateStatisticalValueChf() {
        this.getStatisticalValueChf().fireEvent();
    }

    public DecimalNode getAdditionalUnit() {
        return this.additionalUnit;
    }

    public IntegralNode getTraderItemID() {
        return this.traderItemID;
    }

    public StringNode getDescriptionShort() {
        return this.descriptionShort;
    }

    private Sending getSending() {
        return (Sending)this.getParent().getParent().getParent().getParent();
    }

    private GoodsItem getGoodsItem() {
        return (GoodsItem)this.getParent();
    }

    public StringNode getDescriptionBill() {
        Object text;
        Sending sending = this.getSending();
        Object object = text = sending.getForms().getBill().getDescriptionInEnglish().getValue() != false ? this.getDescriptionEn().getValue() : this.getDescriptionShort().getValue();
        if (sending.getForms().getBill().getShowAdditianalUnit().getValue().booleanValue() && this.getAdditionalUnit().isInitialized()) {
            text = this.getAdditionalUnit().getValue().intValue() + " " + (String)text;
        }
        return new StringNode((String)text);
    }

    public StringNode getPackagingTypeBill() {
        Sending sending = this.getSending();
        String text = sending.getForms().getBill().getDescriptionInEnglish().getValue() != false ? this.getPackagingType().getValue().getDescEn() : this.getPackagingType().getValue().getDesc();
        return new StringNode(text);
    }

    public StringNode getPackagingReferenceNumberBill() {
        return this.getSending().getForms().getBill().getIdInsteadMark().getValue() != false ? this.getGoodsItem().getId() : this.getPackagingReferenceNumber();
    }

    public StringNode getDescriptionDeliveryNote() {
        Object text;
        Sending sending = this.getSending();
        Object object = text = sending.getForms().getDeliveryNote().getDescriptionInEnglish().getValue() != false ? this.getDescriptionEn().getValue() : this.getDescriptionShort().getValue();
        if (sending.getForms().getDeliveryNote().getShowAdditianalUnit().getValue().booleanValue() && this.getAdditionalUnit().isInitialized()) {
            text = this.getAdditionalUnit().getValue().intValue() + " " + (String)text;
        }
        return new StringNode((String)text);
    }

    public StringNode getPackagingTypeDeliveryNote() {
        Sending sending = this.getSending();
        String text = sending.getForms().getDeliveryNote().getDescriptionInEnglish().getValue() != false ? this.getPackagingType().getValue().getDescEn() : this.getPackagingType().getValue().getDesc();
        return new StringNode(text);
    }

    public StringNode getPackagingReferenceNumberDeliveryNote() {
        return this.getSending().getForms().getDeliveryNote().getIdInsteadMark().getValue() != false ? this.getGoodsItem().getId() : this.getPackagingReferenceNumber();
    }

    public StringNode getDescriptionBg() {
        Sending sending = this.getSending();
        String text = sending.getForms().getBg().getDescriptionInEnglish().getValue() != false ? this.getDescriptionEn().getValue() : this.getDescriptionShort().getValue();
        return new StringNode(text);
    }

    public StringNode getPackagingTypeBg() {
        Sending sending = this.getSending();
        String text = sending.getForms().getBg().getDescriptionInEnglish().getValue() != false ? this.getPackagingType().getValue().getDescEn() : this.getPackagingType().getValue().getDesc();
        return new StringNode(text);
    }

    public StringNode getDescriptionUz() {
        Sending sending = this.getSending();
        String text = sending.getForms().getUz().getDescriptionInEnglish().getValue() != false ? this.getDescriptionEn().getValue() : this.getDescriptionShort().getValue();
        return new StringNode(text);
    }

    public StringNode getPackagingTypeUz() {
        Sending sending = this.getSending();
        String text = sending.getForms().getUz().getDescriptionInEnglish().getValue() != false ? this.getPackagingType().getValue().getDescEn() : this.getPackagingType().getValue().getDesc();
        return new StringNode(text);
    }

    public StringNode getDescriptionEur1Front() {
        Sending sending = this.getSending();
        String text = sending.getForms().getEur1().getDescriptionInEnglishFront().getValue() != false ? this.getDescriptionEn().getValue() : this.getDescriptionShort().getValue();
        return new StringNode(text);
    }

    public StringNode getPackagingTypeEur1Front() {
        Sending sending = this.getSending();
        String text = sending.getForms().getEur1().getDescriptionInEnglishFront().getValue() != false ? this.getPackagingType().getValue().getDescEn() : this.getPackagingType().getValue().getDesc();
        return new StringNode(text);
    }

    public StringNode getDescriptionEn() {
        return this.descriptionEn;
    }

    public StringNode getCommodityCode() {
        return this.commodityCode;
    }

    public DecimalNode getGrossMass() {
        return this.grossMass;
    }

    public DecimalNode getNetMass() {
        return this.netMass;
    }

    public SelectionNode getGrossupType() {
        return this.grossupType;
    }

    public void setGrossupType(SelectionNode grossupType) {
        this.grossupType = grossupType;
    }

    public SelectionNode getCustomsClearanceType() {
        return this.customsClearanceType;
    }

    public SelectionNode getCommercialGood() {
        return this.commercialGood;
    }

    public DecimalNode getStatisticalValue() {
        return this.statisticalValue;
    }

    public SelectionNode getPackagingType() {
        return this.packagingType;
    }

    public StringNode getPackagingTypeEn() {
        return new StringNode(this.getPackagingType().getValue().getDescEn());
    }

    public IntegralNode getQuantity() {
        return this.quantity;
    }

    public StringNode getPackagingReferenceNumber() {
        return this.packagingReferenceNumber;
    }

    public IntegralNode getStatisticalCode() {
        return this.statisticalCode;
    }

    public DecimalNode getStatisticalValueChf() {
        if (this.statisticalValueChf == null) {
            this.statisticalValueChf = new StatisticalValueCHF(this, this.getStatisticalValue(), this.getCurrencyRate());
        }
        return this.statisticalValueChf;
    }

    public StringNode getCurrency() {
        return this.currency;
    }

    public DecimalNode getCurrencyRate() {
        return this.currencyRate;
    }

    public BooleanNode getInEur() {
        return this.inEur;
    }

    public StringNode getEurInvoices() {
        return this.eurInvoices;
    }

    public SelectionNode getOrigin() {
        return this.origin;
    }

    public SelectionNode getRefundType() {
        return this.refundType;
    }

    public DecimalNode getVOCQuantity() {
        return this.VOCQuantity;
    }

    public StringNode getBgLetter() {
        return this.bgLetter;
    }

    public String getEdecDescription() {
        return this.getDescriptionShort().getValue();
    }

    public boolean isBeipack() {
        return this.getPackagingType().getValue() == BEIPACK;
    }

    public CompactKey getCompactKey() {
        if (!this.getCommercialGood().isInitialized()) {
            return null;
        }
        Integer statCode = this.getStatisticalCode().isInitialized() ? Integer.valueOf(this.getStatisticalCode().getIntValue()) : null;
        return new CompactKey(this.getCommodityCode().getValue(), this.getCommercialGood().asInt(), statCode, this.getInEur().getValue(), this.getCurrency().getValue());
    }
}

