/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.itemlist.goodsitem;

import ch.transsoft.edec.model.infra.annotation.listType;
import ch.transsoft.edec.model.infra.annotation.mandatory;
import ch.transsoft.edec.model.infra.annotation.maxlen;
import ch.transsoft.edec.model.infra.node.BooleanNode;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.ITableAdapter;
import ch.transsoft.edec.model.infra.node.IntegralNode;
import ch.transsoft.edec.model.infra.node.ListEntry;
import ch.transsoft.edec.model.infra.node.SelectionNode;
import ch.transsoft.edec.model.infra.node.StringNode;
import ch.transsoft.edec.model.infra.node.TableAdapter;
import ch.transsoft.edec.model.infra.node.list.ListNode;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Confirmation;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsData;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.GoodsItemDetail;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.NonCustomsLaws;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Notification;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Permits;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.ProducedDocument;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.Refund;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.RepairAndRefinement;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.SensibleGoods;
import ch.transsoft.edec.model.sending.itemlist.goodsitem.SpecialMention;

public final class GoodsItem
extends ListEntry<GoodsItem> {
    public static ITableAdapter[] tableConfig = new ITableAdapter[]{new TableAdapter("goodsData.traderItemID", 1200, IntegralNode.class, 40), new TableAdapter("id", 1213, StringNode.class), new TableAdapter("goodsData.commodityCode", 1209, StringNode.class), new TableAdapter("goodsData.descriptionShort", 1201, StringNode.class), new TableAdapter("goodsData.quantity", 1202, IntegralNode.class, 60), new TableAdapter("goodsData.packagingType", 1203, SelectionNode.class), new TableAdapter("goodsData.packagingReferenceNumber", 1204, StringNode.class), new TableAdapter("goodsData.netMass", 1206, DecimalNode.class), new TableAdapter("goodsData.grossMass", 1207, DecimalNode.class), new TableAdapter("goodsData.statisticalValue", 1210, DecimalNode.class), new TableAdapter("goodsData.currency", 1211, StringNode.class, 60, false), new TableAdapter("goodsData.inEur", 1212, BooleanNode.class, 45)};
    public static ITableAdapter[] masterDatatableConfig = new ITableAdapter[]{new TableAdapter("id", 1213, StringNode.class, 150), new TableAdapter("goodsData.commodityCode", 1209, StringNode.class, 150), new TableAdapter("goodsData.descriptionShort", 1201, StringNode.class)};
    @maxlen(value=2000)
    private StringNode id;
    @mandatory
    private GoodsData goodsData;
    @mandatory
    @listType(value=ProducedDocument.class)
    @maxlen(value=99)
    private ListNode<ProducedDocument> producedDocuments;
    @mandatory
    private Permits permits;
    @mandatory
    private NonCustomsLaws nonCustomLaws;
    @mandatory
    @listType(value=SensibleGoods.class)
    @maxlen(value=9)
    private ListNode<SensibleGoods> sensibleGoods;
    @mandatory
    @listType(value=Notification.class)
    @maxlen(value=99)
    private ListNode<Notification> notifications;
    @mandatory
    @listType(value=SpecialMention.class)
    @maxlen(value=99)
    private ListNode<SpecialMention> specialMentions;
    @mandatory
    @listType(value=GoodsItemDetail.class)
    private ListNode<GoodsItemDetail> goodsItemDetail;
    private RepairAndRefinement repairAndRefinement;
    @mandatory
    private Confirmation confirmation;
    @mandatory
    private Refund refund;

    @Override
    public void postConstructionNotification() {
    }

    public NonCustomsLaws getNonCustomLaws() {
        return this.nonCustomLaws;
    }

    public RepairAndRefinement getRepairAndRefinement() {
        return this.repairAndRefinement;
    }

    public ListNode<ProducedDocument> getProducedDocuments() {
        return this.producedDocuments;
    }

    public Permits getPermits() {
        return this.permits;
    }

    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public ListNode<SensibleGoods> getSensibleGoods() {
        return this.sensibleGoods;
    }

    public ListNode<SpecialMention> getSpecialMentions() {
        return this.specialMentions;
    }

    public ListNode<Notification> getNotifications() {
        return this.notifications;
    }

    public String getEdecDescription() {
        return this.getGoodsData().getEdecDescription();
    }

    public ListNode<GoodsItemDetail> getGoodsItemDetail() {
        return this.goodsItemDetail;
    }

    public StringNode getId() {
        return this.id;
    }

    public GoodsData getGoodsData() {
        return this.goodsData;
    }

    public Refund getRefund() {
        return this.refund;
    }

    public void addId(StringNode id) {
        this.getId().setValue(this.getId().getValue() + ", " + String.valueOf(id));
    }

    public IntegralNode getIndex() {
        return new IntegralNode((long)((ListNode)this.getParent()).indexOf(this) + 1L);
    }

    public String toString() {
        return "GoodsItem " + String.valueOf(this.getId());
    }
}

