/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.model.sending.itemlist.goodsitem;

import ch.transsoft.edec.model.infra.IXMLWriter;
import ch.transsoft.edec.model.infra.node.DecimalNode;
import ch.transsoft.edec.model.infra.node.ModelNode;
import ch.transsoft.edec.util.Check;
import java.math.BigDecimal;
import org.w3c.dom.Node;

public final class StatisticalValueCHF
extends DecimalNode {
    private final DecimalNode statisticalValue;
    private final DecimalNode currencyRate;

    public StatisticalValueCHF(ModelNode<?> parent, DecimalNode statisticalValue, DecimalNode currencyRate) {
        super(12, 2);
        Check.assertNotNull(statisticalValue);
        Check.assertNotNull(currencyRate);
        this.setMandatory(false);
        this.setParent(parent);
        this.statisticalValue = statisticalValue;
        this.currencyRate = currencyRate;
    }

    @Override
    public boolean isInitialized() {
        return this.statisticalValue.isInitialized() && this.currencyRate.isInitialized();
    }

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        Check.unsupportedOperation();
    }

    @Override
    public Double getValue() {
        if (!this.isInitialized()) {
            return null;
        }
        return this.statisticalValue.getValue() * this.currencyRate.getValue();
    }

    @Override
    public void setValue(Number value) {
    }

    @Override
    public StatisticalValueCHF getCopy(ModelNode<?> parent) {
        throw Check.fail("copy not possible for computed values");
    }

    @Override
    public void apply(DecimalNode other) {
        Check.unsupportedOperation();
    }

    @Override
    public boolean isEquals(DecimalNode other) {
        throw Check.unsupportedOperation();
    }

    @Override
    public BigDecimal asBigDecimal() {
        Double value = this.getValue();
        if (value == null) {
            return BigDecimal.valueOf(0L);
        }
        return BigDecimal.valueOf(this.getValue());
    }
}

