/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service;

import ch.transsoft.edec.util.Check;
import java.util.HashMap;
import java.util.Map;

public class ServiceFactory {
    private Map<Class<?>, Class<?>> implementations = new HashMap();
    private Map<Class<?>, Object> services = new HashMap();

    public void change(Class<?> serviceInterface, Class<?> implementation) {
        this.add(serviceInterface, implementation);
    }

    public void add(Class<?> serviceInterface, Class<?> implementation) {
        this.checkIsInterface(serviceInterface);
        this.checkIsClass(implementation);
        this.checkIsAssignable(serviceInterface, implementation);
        this.implementations.put(serviceInterface, implementation);
    }

    private void checkIsAssignable(Class<?> serviceInterface, Class<?> implementation) {
        Check.assertTrue(serviceInterface.isAssignableFrom(implementation), implementation, "does not implement", serviceInterface);
    }

    public <T> T getService(Class<T> serviceInterface) {
        this.checkIsInterface(serviceInterface);
        Object result = this.services.get(serviceInterface);
        if (result == null) {
            Class<?> serviceType = this.implementations.get(serviceInterface);
            Check.assertNotNull(serviceType, "no service registered for interface", serviceInterface);
            try {
                result = serviceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e2) {
                Check.fail(e2);
            }
            this.services.put(serviceInterface, result);
        }
        return (T)result;
    }

    public void setService(Class<?> serviceInterface, Object implementation) {
        this.checkIsAssignable(serviceInterface, implementation.getClass());
        this.services.put(serviceInterface, implementation);
    }

    private <T> void checkIsInterface(Class<T> interfaze) {
        Check.assertTrue(interfaze.isInterface(), interfaze.getSimpleName(), "is not an interface");
    }

    private <T> void checkIsClass(Class<T> clazz) {
        Check.assertFalse(clazz.isInterface(), clazz.getSimpleName(), "is not an interface");
    }
}

