/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service;

import ch.transsoft.edec.service.ServiceFactory;
import ch.transsoft.edec.service.app.AppService;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.BackendService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.certificate.CertificateService;
import ch.transsoft.edec.service.certificate.ICertificateService;
import ch.transsoft.edec.service.config.ConfigService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.ezv.EZVService;
import ch.transsoft.edec.service.ezv.IEZVService;
import ch.transsoft.edec.service.form.FormService;
import ch.transsoft.edec.service.form.IFormService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.index.bordereau.BordereauService;
import ch.transsoft.edec.service.index.bordereau.IBordereauService;
import ch.transsoft.edec.service.index.receipt.IReceiptService;
import ch.transsoft.edec.service.index.receipt.ReceiptService;
import ch.transsoft.edec.service.index.sending.IIndexService;
import ch.transsoft.edec.service.index.sending.IndexService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.service.logging.LoggingService;
import ch.transsoft.edec.service.masterdata.DataService;
import ch.transsoft.edec.service.masterdata.IDataService;
import ch.transsoft.edec.service.masterdataezv.IMasterDataEZVService;
import ch.transsoft.edec.service.masterdataezv.internal.MasterDataEZVService;
import ch.transsoft.edec.service.outlook.IOutlookService;
import ch.transsoft.edec.service.outlook.OutlookService;
import ch.transsoft.edec.service.polling.IPollingService;
import ch.transsoft.edec.service.polling.PollingService;
import ch.transsoft.edec.service.printer.IPrinterService;
import ch.transsoft.edec.service.printer.PrinterService;
import ch.transsoft.edec.service.proxy.ConnectionService;
import ch.transsoft.edec.service.proxy.IConnectionService;
import ch.transsoft.edec.service.smtp.ISmtpService;
import ch.transsoft.edec.service.smtp.SmtpService;
import ch.transsoft.edec.service.text.ITextService;
import ch.transsoft.edec.service.text.internal.TextService;
import ch.transsoft.edec.service.validate.IValidateService;
import ch.transsoft.edec.service.validate.ValidateService;

public class Services {
    private static final ServiceFactory factory = new ServiceFactory();

    private static synchronized <T> void add(Class<? super T> serviceInterface, Class<T> implementation) {
        factory.add(serviceInterface, implementation);
    }

    public static synchronized void setService(Class<?> serviceInterface, Object implementation) {
        factory.setService(serviceInterface, implementation);
    }

    public static ServiceFactory getServiceFactory() {
        return factory;
    }

    public static synchronized <T> T get(Class<T> serviceInterface) {
        return factory.getService(serviceInterface);
    }

    public static String getText(int id) {
        return Services.get(ITextService.class).getText(id);
    }

    public static String format(int format, int arg) {
        return Services.format(format, Services.getText(arg));
    }

    public static String format(int format, Object ... args) {
        return String.format(Services.getText(format), args);
    }

    static {
        Services.add(IBackendService.class, BackendService.class);
        Services.add(IMasterDataEZVService.class, MasterDataEZVService.class);
        Services.add(ILoggingService.class, LoggingService.class);
        Services.add(ITextService.class, TextService.class);
        Services.add(IDataService.class, DataService.class);
        Services.add(IEZVService.class, EZVService.class);
        Services.add(IIndexService.class, IndexService.class);
        Services.add(IConfigService.class, ConfigService.class);
        Services.add(IFormService.class, FormService.class);
        Services.add(IPrinterService.class, PrinterService.class);
        Services.add(IValidateService.class, ValidateService.class);
        Services.add(IAppService.class, AppService.class);
        Services.add(IGuiService.class, GuiService.class);
        Services.add(IPollingService.class, PollingService.class);
        Services.add(IBordereauService.class, BordereauService.class);
        Services.add(IReceiptService.class, ReceiptService.class);
        Services.add(IConnectionService.class, ConnectionService.class);
        Services.add(ICertificateService.class, CertificateService.class);
        Services.add(IOutlookService.class, OutlookService.class);
        Services.add(ISmtpService.class, SmtpService.class);
    }
}

