/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.action;

import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.ActionBase;
import ch.transsoft.edec.service.backend.IActionLockListener;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.config.IConfigServiceListener;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.service.gui.IModuleListener;
import javax.swing.Icon;

public abstract class LockedActionBase
extends ActionBase {
    private boolean isLocked;
    private boolean currentValue;
    private String currentToolTip;

    public LockedActionBase(String name) {
        super(name);
        this.addActionLockListener();
    }

    public LockedActionBase(String name, Icon smallIcon, Icon largeIcon) {
        super(name, smallIcon, largeIcon);
        this.addActionLockListener();
    }

    protected void disableIfNoEvvExportLicense(final int disabledToolTip, final int enabledToolTip) {
        this.checkEvvExportLicense(disabledToolTip, enabledToolTip);
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                LockedActionBase.this.checkEvvExportLicense(disabledToolTip, enabledToolTip);
            }

            @Override
            public void rootChanged() {
                LockedActionBase.this.checkEvvExportLicense(disabledToolTip, enabledToolTip);
            }

            @Override
            public void modeChanged(boolean isDemo) {
                LockedActionBase.this.checkEvvExportLicense(disabledToolTip, enabledToolTip);
            }
        });
    }

    protected void checkEvvExportLicense(int disabledToolTip, int enabledToolTip) {
        this.checkLicense(disabledToolTip, enabledToolTip, Services.get(IConfigService.class).hasLicenseForModuleEvvExport());
    }

    protected void disableIfNoExportLicense(final int textId, final int enabledToolTip) {
        this.checkExportLicense(textId, enabledToolTip);
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                LockedActionBase.this.checkExportLicense(textId, enabledToolTip);
            }

            @Override
            public void rootChanged() {
                LockedActionBase.this.checkExportLicense(textId, enabledToolTip);
            }

            @Override
            public void modeChanged(boolean isDemo) {
                LockedActionBase.this.checkExportLicense(textId, enabledToolTip);
            }
        });
    }

    protected void checkExportLicense(int disabledToolTop, int enabledToolTip) {
        this.checkLicense(disabledToolTop, enabledToolTip, Services.get(IConfigService.class).hasLicenseForModuleExport());
    }

    protected void disableIfNoImportLicense(final int enabledToolTip) {
        this.checkImportLicense(enabledToolTip);
        Services.get(IConfigService.class).add(new IConfigServiceListener(){

            @Override
            public void configurationChanged() {
                LockedActionBase.this.checkImportLicense(enabledToolTip);
            }

            @Override
            public void rootChanged() {
                LockedActionBase.this.checkImportLicense(enabledToolTip);
            }

            @Override
            public void modeChanged(boolean isDemo) {
                LockedActionBase.this.checkImportLicense(enabledToolTip);
            }
        });
    }

    protected void checkImportLicense(int enabledToolTip) {
        this.checkLicense(137, enabledToolTip, Services.get(IConfigService.class).hasLicenseForModuleImport());
    }

    private void checkLicense(int disabledToolTip, int enabledToolTip, boolean hasLicense) {
        if (hasLicense) {
            this.setEnabled(true);
            this.setTooltip(Services.getText(enabledToolTip));
        } else {
            this.setEnabled(false);
            this.setTooltip(Services.getText(disabledToolTip));
        }
    }

    protected void disableForModuleImport(final String tooltip) {
        this.updateModuleExportEnabling(tooltip);
        Services.get(IGuiService.class).addModuleListener(new IModuleListener(){

            @Override
            public void moduleChanged() {
                LockedActionBase.this.updateModuleExportEnabling(tooltip);
            }
        });
    }

    protected void updateModuleExportEnabling(String tooltip) {
        if (Services.get(IConfigService.class).isModuleExport()) {
            this.setEnabled(true);
            this.setTooltip(tooltip);
            this.updateState();
        } else {
            this.setEnabled(false);
            this.setTooltip(Services.getText(4431));
        }
    }

    protected void updateState() {
    }

    private void addActionLockListener() {
        this.currentValue = this.isEnabled();
        this.isLocked = this.getBackendService().isActionsLocked();
        this.getBackendService().add(new IActionLockListener(){

            @Override
            public void unlock() {
                LockedActionBase.this.isLocked = false;
                LockedActionBase.super.setEnabled(LockedActionBase.this.currentValue);
                LockedActionBase.super.setTooltip(LockedActionBase.this.currentToolTip);
            }

            @Override
            public void lock(String jobName) {
                LockedActionBase.this.isLocked = true;
                LockedActionBase.super.setEnabled(false);
                LockedActionBase.super.setTooltip(Services.getText(800) + " " + jobName);
            }
        });
    }

    private IBackendService getBackendService() {
        return Services.get(IBackendService.class);
    }

    @Override
    public void setTooltip(String text) {
        this.currentToolTip = text;
        if (this.isLocked) {
            return;
        }
        super.setTooltip(text);
    }

    @Override
    public void setEnabled(boolean newValue) {
        this.currentValue = newValue;
        if (this.isLocked) {
            return;
        }
        super.setEnabled(newValue);
    }
}

