/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.app;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.sending.Sending;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.action.IActionService;
import ch.transsoft.edec.service.app.AppState;
import ch.transsoft.edec.service.app.IAppChangedListener;
import ch.transsoft.edec.service.app.IAppService;
import ch.transsoft.edec.service.backend.IBackendService;
import ch.transsoft.edec.service.backend.jobs.OpenSendingJob;
import ch.transsoft.edec.service.backend.jobs.SaveSendingInitiallyJob;
import ch.transsoft.edec.service.backend.jobs.SaveSendingJob;
import ch.transsoft.edec.service.backend.jobs.template.OpenTemplateJob;
import ch.transsoft.edec.service.backend.jobs.template.SaveTemplateJob;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.gui.GuiService;
import ch.transsoft.edec.service.gui.IGuiService;
import ch.transsoft.edec.ui.action.NewAction;
import ch.transsoft.edec.ui.dialog.DialogUtil;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.disposable.IDisposable;
import ch.transsoft.edec.util.disposable.ListenerList;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;

public class AppService
implements IAppService {
    private Sending currentSending;
    private ListenerList<IAppChangedListener> listeners = new ListenerList();
    private AppState appState = AppState.newSending;
    private File currentTemplate;

    @Override
    public void handleExitRequest() {
        Check.checkEDT();
        Services.get(IGuiService.class).commitCurrentEditor();
        if (this.askSavePendingChanges()) {
            Services.get(IGuiService.class).shutdown();
        }
    }

    @Override
    public Sending getCurrentSending() {
        Check.checkEDT();
        if (this.currentSending == null) {
            this.currentSending = NodeFactory.create(Sending.class);
            this.currentSending.activateBusinessLogicListeners();
        }
        return this.currentSending;
    }

    @Override
    public IDisposable addChangeListener(IAppChangedListener listener) {
        Check.checkEDT();
        return this.listeners.add(listener);
    }

    @Override
    public void changeTemplateState(File template) {
        this.changeTemplateState(template, template == null ? AppState.sending : AppState.template);
    }

    private void changeTemplateState(File template, AppState appState) {
        this.currentTemplate = template;
        this.appState = appState;
        for (IAppChangedListener listener : this.listeners) {
            listener.stateChanged(appState, template);
        }
    }

    @Override
    public void openTemplate(File location, Sending sending) {
        this.changeTemplateState(location);
        this.setCurrentSending(sending);
    }

    @Override
    public void openSending(Sending sending) {
        this.changeTemplateState(null);
        this.setCurrentSending(sending);
    }

    @Override
    public void newSending() {
        this.changeTemplateState(null, AppState.newSending);
        Sending create = NodeFactory.create(Sending.class);
        this.setCurrentSending(create);
    }

    private void setCurrentSending(Sending sending) {
        Check.checkEDT();
        sending.activateBusinessLogicListeners();
        this.currentSending = sending;
        for (IAppChangedListener listener : this.listeners) {
            listener.sendingChanged(sending);
        }
    }

    @Override
    public boolean askSavePendingChanges() {
        if (!this.getCurrentSending().hasPendingChanges()) {
            return true;
        }
        switch (DialogUtil.showSaveDialogt(Services.get(IGuiService.class).getMainFrame(), this.getSaveText(), Services.getText(203))) {
            case 0: {
                this.save();
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private String getSaveText() {
        if (this.getAppState() == AppState.template) {
            return String.format(Services.getText(801), this.getCurrentTemplate().getName());
        }
        return String.format(Services.getText(802), this.createNameSuggestion());
    }

    @Override
    public void saveSendingFirstTime(String historyEntry) {
        Services.get(IGuiService.class).commitCurrentEditor();
        Services.get(IBackendService.class).put(new SaveSendingInitiallyJob(this.getCurrentSending(), historyEntry));
        this.changeTemplateState(null, AppState.sending);
    }

    @Override
    public void saveCurrentSending() {
        if (!this.getCurrentSending().hasSendingId()) {
            return;
        }
        Services.get(IGuiService.class).commitCurrentEditor();
        this.changeTemplateState(null);
        Services.get(IBackendService.class).put(new SaveSendingJob(this.getCurrentSending()));
    }

    @Override
    public void requestOpenSending(IndexEntry selected) {
        if (Services.get(IBackendService.class).isActionsLocked()) {
            return;
        }
        if (this.getCurrentSending().isSending(selected)) {
            Services.get(IGuiService.class).selectExportTab(GuiService.ExportTab.header);
            return;
        }
        if (!this.askSavePendingChanges()) {
            return;
        }
        Services.get(IBackendService.class).put(new OpenSendingJob(selected), true);
    }

    @Override
    public void requestOpenTemplate(File file) {
        if (Services.get(IBackendService.class).isActionsLocked()) {
            return;
        }
        if (!this.askSavePendingChanges()) {
            return;
        }
        Services.get(IBackendService.class).put(new OpenTemplateJob(file), true);
    }

    @Override
    public void saveTemplateAs(boolean saveSendingAsTemplate) {
        FileDialog dialog = new FileDialog((Frame)Services.get(IGuiService.class).getMainFrame(), Services.getText(803), 1);
        File suggestion = Services.get(IConfigService.class).getTemplateDir(false);
        dialog.setDirectory(suggestion.getPath());
        dialog.setFile(this.createNameSuggestion());
        dialog.setVisible(true);
        String file = dialog.getFile();
        String path = dialog.getDirectory();
        if (path == null) {
            return;
        }
        if (file == null) {
            return;
        }
        File target = new File(path, file);
        target = FileUtil.addExtension(target, "xml");
        this.saveTemplate(target, saveSendingAsTemplate);
        this.changeTemplateState(target);
        Services.get(IBackendService.class).put(new OpenTemplateJob(target), true);
    }

    private String createNameSuggestion() {
        String customer = this.getCurrentSending().getGoodsDeclaration().getConsignee().getName().getValue();
        if (!customer.isEmpty()) {
            return customer;
        }
        return this.getCurrentSending().getTraderDeclarationNumber();
    }

    @Override
    public void saveTemplate() {
        Check.assertNotNull(this.currentTemplate, "No template open");
        this.saveTemplate(this.currentTemplate, false);
    }

    private void saveTemplate(File target, boolean saveSendingAsTemplate) {
        Sending sending = Services.get(IAppService.class).getCurrentSending();
        Services.get(IBackendService.class).put(new SaveTemplateJob(target, sending, saveSendingAsTemplate));
    }

    @Override
    public AppState getAppState() {
        return this.appState;
    }

    @Override
    public void save() {
        switch (this.getAppState()) {
            case newSending: {
                this.saveSendingFirstTime("Created from new sending");
                break;
            }
            case sending: {
                this.saveCurrentSending();
                break;
            }
            case template: {
                this.saveTemplate();
            }
        }
    }

    @Override
    public File getCurrentTemplate() {
        return this.currentTemplate;
    }

    @Override
    public void closeCurrentSending() {
        Services.get(IActionService.class).getAction(NewAction.class).actionPerformed(null);
    }
}

