/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend;

import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.ThreadUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class LockFile
implements Serializable {
    private final String user;
    private final String guid;

    public LockFile(String user, String guid) {
        this.user = user;
        this.guid = guid;
    }

    public static LockFile read(File file) {
        try {
            return LockFile.internalRead(file);
        }
        catch (Exception e2) {
            ThreadUtil.sleep(100L);
            return LockFile.internalRead(file);
        }
    }

    /*
     * Loose catch block
     */
    public static LockFile internalRead(File file) {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(file));
            LockFile lockFile = (LockFile)in.readObject();
            FileUtil.close(in);
            return lockFile;
        }
        catch (EOFException | FileNotFoundException | StreamCorruptedException e2) {
            LockFile lockFile = null;
            return lockFile;
        }
        catch (Exception e3) {
            throw Check.fail(e3);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            FileUtil.close(in);
        }
    }

    public void write(File file) throws IOException {
        int currentWaitTime = 0;
        int sleepTime = 100;
        int MAX_WAIT_TIME = 4000;
        while (currentWaitTime < MAX_WAIT_TIME) {
            try {
                this.internalWrite(file);
                return;
            }
            catch (IOException e2) {
                ThreadUtil.sleep(sleepTime);
                currentWaitTime += sleepTime;
                sleepTime *= 2;
            }
        }
    }

    public void internalWrite(File file) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(file);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(this);
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getGuid() {
        return this.guid;
    }
}

