/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.index.IndexEntry;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.backend.BackendJobBase;
import ch.transsoft.edec.service.backend.jobs.manip.ArchiveUpdate;
import ch.transsoft.edec.service.backend.jobs.manip.IIndexUpdater;
import ch.transsoft.edec.service.backend.jobs.manip.IndexUpdate;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.service.logging.ILoggingService;
import ch.transsoft.edec.util.FileUtil;
import ch.transsoft.edec.util.SendingUtil;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;

public class DeleteSendingJob
extends BackendJobBase {
    private List<File> result;
    private final IndexEntry indexEntry;
    private final boolean archive;
    private IIndexUpdater indexUpdater;

    public DeleteSendingJob(IndexEntry indexEntry, boolean archive) {
        super(IConfigService.Module.moduleExport);
        this.indexEntry = indexEntry;
        this.archive = archive;
    }

    @Override
    public void done() {
        this.indexUpdater.notifyChange();
        if (this.result.isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DeleteSendingJob.this.showDialogAsync();
            }
        });
    }

    private void showDialogAsync() {
        StringBuilder message = new StringBuilder(Services.getText(901) + ":\n\n");
        for (File file : this.result) {
            message.append(file.toString());
            message.append("\n");
        }
        Services.get(ILoggingService.class).logAndReport(Services.getText(902), message.toString());
    }

    @Override
    public String getMessage() {
        return Services.getText(903) + " " + this.indexEntry.getTraderDeclarationNumber().getValue();
    }

    @Override
    public void execute() throws Exception {
        this.deleteSending();
        this.updateIndex();
    }

    private void updateIndex() throws Exception {
        this.indexUpdater = this.archive ? new ArchiveUpdate(this.indexEntry) : new IndexUpdate(this.indexEntry);
        this.indexUpdater.deleteEntry();
    }

    private void deleteSending() {
        File sendingDir = SendingUtil.getSendingDir(this.indexEntry.getSendingId(), true);
        this.result = FileUtil.recursiveDelete(sendingDir);
    }

    protected IndexEntry getIndexEntry() {
        return this.indexEntry;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public void handleError(Throwable e2) {
        this.log(e2, Services.getText(904));
    }

    @Override
    public boolean locksActions() {
        return true;
    }
}

