/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.edec.service.backend.jobs;

import ch.transsoft.edec.model.evvimport.bordereau.BordereauIndex;
import ch.transsoft.edec.model.evvimport.receipt.ReceiptIndex;
import ch.transsoft.edec.model.index.Index;
import ch.transsoft.edec.model.infra.NodeFactory;
import ch.transsoft.edec.model.infra.indexhandling.IndexBase;
import ch.transsoft.edec.model.infra.indexhandling.IndexEntryBase;
import ch.transsoft.edec.service.Services;
import ch.transsoft.edec.service.config.IConfigService;
import ch.transsoft.edec.util.Check;
import ch.transsoft.edec.util.FileUtil;
import java.io.File;

public class IndexUtil {
    private static final String INDEX_FILE_NAME = "index";

    public static File getArchiveDir(boolean readOnly) {
        return Services.get(IConfigService.class).getArchiveDir(readOnly);
    }

    public static File getIndexDir(boolean readOnly) {
        return Services.get(IConfigService.class).getIndexDir(readOnly);
    }

    public static Index readIndex() throws Exception {
        return IndexUtil.readIndexFile(IndexUtil.getIndexDir(true), INDEX_FILE_NAME, Index.class);
    }

    public static void writeIndex(Index index) {
        IndexUtil.internalWriteIndex(index, IndexUtil.getIndexDir(false));
    }

    public static Index readArchive(int year) throws Exception {
        return IndexUtil.readIndexFile(IndexUtil.getArchiveDir(true), IndexUtil.getArchiveFileName(year), Index.class);
    }

    public static void writeArchive(int year, Index index) {
        IndexUtil.internalWriteArchive(year, index, IndexUtil.getArchiveDir(false));
    }

    public static File getBordereauArchiveDir(boolean readOnly) {
        return Services.get(IConfigService.class).getBordereauArchiveDir(readOnly);
    }

    public static File getBordereauIndexDir(boolean readOnly) {
        return Services.get(IConfigService.class).getBordereauIndexDir(readOnly);
    }

    public static BordereauIndex readBordereauIndex() {
        return IndexUtil.readIndexFile(IndexUtil.getBordereauIndexDir(true), INDEX_FILE_NAME, BordereauIndex.class);
    }

    public static void writeBordereauIndex(BordereauIndex index) {
        IndexUtil.internalWriteIndex(index, IndexUtil.getBordereauIndexDir(false));
    }

    public static BordereauIndex readBordereauArchive(int year) {
        return IndexUtil.readIndexFile(IndexUtil.getBordereauArchiveDir(true), IndexUtil.getArchiveFileName(year), BordereauIndex.class);
    }

    public static void writeBordereauArchive(int year, BordereauIndex index) {
        IndexUtil.internalWriteArchive(year, index, IndexUtil.getBordereauArchiveDir(false));
    }

    public static File getReceiptArchiveDir(boolean readOnly) {
        return Services.get(IConfigService.class).getReceiptArchiveDir(readOnly);
    }

    public static File getReceiptIndexDir(boolean readOnly) {
        return Services.get(IConfigService.class).getReceiptIndexDir(readOnly);
    }

    public static ReceiptIndex readReceiptIndex() {
        return IndexUtil.readIndexFile(IndexUtil.getReceiptIndexDir(true), INDEX_FILE_NAME, ReceiptIndex.class);
    }

    public static void writeReceiptIndex(ReceiptIndex index) {
        IndexUtil.internalWriteIndex(index, IndexUtil.getReceiptIndexDir(false));
    }

    public static ReceiptIndex readReceiptArchive(int year) {
        return IndexUtil.readIndexFile(IndexUtil.getReceiptArchiveDir(true), IndexUtil.getArchiveFileName(year), ReceiptIndex.class);
    }

    public static void writeReceiptArchive(int year, ReceiptIndex index) {
        IndexUtil.internalWriteArchive(year, index, IndexUtil.getReceiptArchiveDir(false));
    }

    public static String getArchiveFileName(int year) {
        return Integer.toString(year);
    }

    public static <X extends IndexEntryBase<X>, T extends IndexBase<T, X>> void internalWriteIndex(T index, File indexDir) {
        try {
            File file = new File(indexDir, "index.xml.gz");
            FileUtil.writeGZipFile(index, file);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    public static <X extends IndexEntryBase<X>, T extends IndexBase<T, X>> void internalWriteArchive(int year, T index, File archiveDir) {
        try {
            File file = new File(archiveDir, IndexUtil.getArchiveFileName(year) + ".xml.gz");
            FileUtil.writeGZipFile(index, file);
        }
        catch (Exception ex) {
            Check.fail(ex);
        }
    }

    private static <X extends IndexEntryBase<X>, T extends IndexBase<T, X>> T readIndexFile(File folder, String filenameWithoutExtension, Class<T> klass) {
        try {
            return (T)((IndexBase)FileUtil.readFile(folder, filenameWithoutExtension, klass));
        }
        catch (Exception exception) {
            return (T)((IndexBase)NodeFactory.create(klass));
        }
    }
}

